/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.nls;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.nls.NLSUtils;
import com.ibm.cic.common.core.utils.LinkedProperties;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ContentResourceManager {
    private static final char DOT = '.';
    private static final char DOT_REPLACEMENT = '`';
    private static final String COLON_SLASH_SLASH = "://";
    private static final String COLON_SLASH_SLASH_REPLACEMENT = ";//";
    public static final String NL_FILE_EXTENSION = ".properties";
    ResourceBundle resourceBundle;

    public ContentResourceManager(String a_nlLocation) {
        this(a_nlLocation, Locale.getDefault());
    }

    public ContentResourceManager(String a_nlLocation, Locale locale) {
        this(a_nlLocation, locale, new RepositoryURLClassLoader());
    }

    public ContentResourceManager(String a_nlLocation, URLClassLoader loader) {
        this(a_nlLocation, Locale.getDefault(), loader);
    }

    public ContentResourceManager(String a_nlLocation, Locale locale, URLClassLoader loader) {
        String nlLocation1 = ContentResourceManager.locationToResourceName(a_nlLocation);
        try {
            this.resourceBundle = ResourceBundle.getBundle(nlLocation1, locale, loader, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            Locale bundleLocale = this.resourceBundle.getLocale();
            if (!bundleLocale.equals(Locale.ROOT) && !bundleLocale.getLanguage().equals(locale.getLanguage())) {
                assert (bundleLocale.getLanguage().equals(Locale.getDefault().getLanguage()));
                this.resourceBundle = ResourceBundle.getBundle(nlLocation1, Locale.ROOT, loader);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public String getString(String key, String defaultVal) {
        String return_value = defaultVal;
        try {
            if (this.resourceBundle != null) {
                return_value = this.resourceBundle.getString(key.substring(1));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return return_value;
    }

    public IStatus performNLSupdate(IContent element) {
        LinkedProperties props;
        this.processInformation(element.getInformation());
        if (element instanceof IOffering) {
            this.walkFeatures(((IOffering)element).getFeatureGroup());
        }
        if (element instanceof IFix) {
            IFix fix = (IFix)element;
            this.performNLSupdateForEnhancedFixContents(fix);
        }
        if (element instanceof IOfferingOrFix && !(props = ((IOfferingOrFix)element).getProperties()).isEmpty()) {
            Map propKeys = ((IOfferingOrFix)element).getPropertyKeys();
            LinkedProperties translatedProperties = new LinkedProperties();
            for (Map.Entry property : props.entrySet()) {
                String val = (String)property.getValue();
                String key = (String)property.getKey();
                if (NLSUtils.isNLKey(val)) {
                    String newVal = this.getString(val, val);
                    if (!propKeys.containsKey(key)) {
                        propKeys.put(key, val);
                    }
                    translatedProperties.setProperty(key, newVal);
                    continue;
                }
                translatedProperties.setProperty(key, val);
            }
            props.clear();
            props.putAll(translatedProperties);
        }
        return Status.OK_STATUS;
    }

    private void performNLSupdateForEnhancedFixContents(IFix fix) {
        List categories = fix.getCategories();
        for (IFixCategory category : categories) {
            String val = category.getNameKey();
            if (!NLSUtils.isNLKey(val)) continue;
            category.setName(this.getString(val, val));
        }
        List resolves = fix.getProblemsResolvedList();
        for (IProblemsResolved resolved : resolves) {
            String val = resolved.getDescriptionKey();
            if (val != null && NLSUtils.isNLKey(val)) {
                resolved.setDescription(this.getString(val, val));
            }
            List problems = resolved.getProblems();
            for (IProblemResolved problem : problems) {
                this.performNLSupdateForProblem(problem);
            }
        }
    }

    private void performNLSupdateForProblem(IProblemResolved problem) {
        String val2 = problem.getDescriptionKey();
        if (val2 != null && NLSUtils.isNLKey(val2)) {
            problem.setDescription(this.getString(val2, val2));
        }
    }

    private void processInformation(Information info) {
        if (info != null) {
            String val = info.getNameKey();
            if (NLSUtils.isNLKey(val)) {
                info.setName(this.getString(val, val));
            }
            if (NLSUtils.isNLKey(val = info.getDescriptionKey())) {
                info.setDescription(this.getString(val, val));
            }
        }
    }

    private void walkFeatures(IFeatureBase f) {
        if (f != null) {
            List l;
            this.processInformation(f.getInformation());
            if (f instanceof IFeatureGroup && (l = ((IFeatureGroup)f).getChildren()) != null) {
                for (Object element : l) {
                    if (!(element instanceof IFeatureBase)) continue;
                    this.walkFeatures((IFeatureBase)element);
                }
            }
        }
    }

    protected static String locationToResourceName(String location) {
        String name = location.replace('.', '`');
        name = name.replaceFirst(COLON_SLASH_SLASH, COLON_SLASH_SLASH_REPLACEMENT);
        return name;
    }

    protected static String resourceNameToLocation(String name) {
        String location = name.replace('`', '.');
        location = location.replaceFirst(COLON_SLASH_SLASH_REPLACEMENT, COLON_SLASH_SLASH);
        return location;
    }

    private static class RepositoryURLClassLoader
    extends URLClassLoader {
        public RepositoryURLClassLoader() {
            super(new URL[0], (ClassLoader)null);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            URL theURL = new CicFileLocation(ContentResourceManager.resourceNameToLocation(name)).toURL();
            try {
                return TransferUtils.getValidatedStreamForURLDirectForFiles(theURL, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (CoreException e) {
                return null;
            }
        }

        @Override
        public URL getResource(String name) {
            String nlLocation1 = ContentResourceManager.resourceNameToLocation(name);
            CicFileLocation l = new CicFileLocation(nlLocation1);
            URL return_value = l.toURL();
            if (return_value != null && !TransferUtils.validURL(return_value, null)) {
                return_value = null;
            }
            return return_value;
        }
    }
}

