/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.repository.RepositoryUpdateOfferingHandler;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestBaseOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestDictionary;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingOrFixData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.osgi.framework.Version;

public class RepositoryDigestOfferingData
extends RepositoryDigestOfferingOrFixData {
    public static final RepositoryDigestOfferingData NULL = new NullRepositoryDigestOfferingData();
    private RepositoryDigestBaseOfferingData updateData = RepositoryDigestBaseOfferingData.NULL;

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\n  " + this.updateData;
    }

    public RepositoryDigestOfferingData(IIdentity id, Version version) {
        super(id, version);
    }

    void emitXML(XMLWriter writer) {
        writer.start("offering");
        writer.attribute("id", this.getIdentity());
        writer.attribute("version", this.getVersion());
        this.updateData.emitXML(writer);
        this.emitCommonXML(writer);
        writer.end("offering");
    }

    public void setBaseOfferingInfo(RepositoryDigestBaseOfferingData a_updateData) {
        this.updateData = a_updateData;
        if (this.getParent() != null) {
            this.getParent().addUpdateProperty(this);
        }
    }

    public boolean isUpdate() {
        return this.updateData != RepositoryDigestBaseOfferingData.NULL;
    }

    public RepositoryDigestBaseOfferingData getBaseOfferingData() {
        return this.updateData;
    }

    void addUpdateProperty(LinkedProperties siteProperties) {
        String key = RepositoryUpdateOfferingHandler.constructKey(this);
        if (this.isUpdate()) {
            siteProperties.put(key, RepositoryUpdateOfferingHandler.constructVal(this.updateData));
        } else {
            siteProperties.remove(key);
        }
    }

    @Override
    public void addToSiteProperties(LinkedProperties siteProperties) {
        this.addUpdateProperty(siteProperties);
        super.addToSiteProperties(siteProperties);
    }

    @Override
    public void removeFromSiteProperties(LinkedProperties siteProperties) {
        siteProperties.remove(RepositoryUpdateOfferingHandler.constructKey(this));
        super.removeFromSiteProperties(siteProperties);
    }

    private static class NullRepositoryDigestOfferingData
    extends RepositoryDigestOfferingData {
        NullRepositoryDigestOfferingData() {
            super(null, null);
        }

        @Override
        public String toString() {
            return "No offering data";
        }

        @Override
        void emitXML(XMLWriter writer) {
        }

        @Override
        public void setBaseOfferingInfo(RepositoryDigestBaseOfferingData a_updateData) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setInformation(String name, String version) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setInformation(Information information) {
            throw new UnsupportedOperationException();
        }

        @Override
        void performNlUpdate() {
            throw new UnsupportedOperationException();
        }

        @Override
        void addDictionary(RepositoryDigestDictionary a_dict) {
            throw new UnsupportedOperationException();
        }

        @Override
        void addUntranslatedProperty(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        void addTocEntryList(ICicLocation fileLocation, IContentRepository subRepository) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setParent(RepositoryDigestRepositoryData rep) {
            throw new UnsupportedOperationException();
        }

        @Override
        Collection addUntranslatedProperties(IOfferingOrFix a_ofOrFix, String[] keys) {
            throw new UnsupportedOperationException();
        }

        @Override
        void addRepositoryDigestDictionaryList(ArrayList translatable, IContentRepository contRep) {
            throw new UnsupportedOperationException();
        }
    }
}

