/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.model.proxy.IFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.digest.IRepositoryDigestXML;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestParser;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.xml.sax.InputSource;

public class RepositoryDigest {
    public static final int REQUEST_GENERATE_CONTENT_INFO = 1;
    public static final int REQUEST_DELETE_CONTENT_INFO = 2;
    public static final int REQUEST_VERIFY_CONTENT_INFO = 4;
    public static final int REQUEST_COLLECT_CONTENT_INFO = 8;
    private static final Logger log = Logger.getLogger(RepositoryDigest.class);
    public static final String REPOSITORY_DIGEST_NAME = "repository.xml";
    static final Version VERSION_0 = new Version(0, 0, 0);
    private static final Version VERSION_1;
    private static final Version VERSION_LATEST;
    private static final Version VERSION_MAX;
    static final VersionRange INSTALL_REPOSITORY_DIGEST_VERSION_TOLERANCE;
    private final FileCacheManager fcm = RepositoryPool.getDefault().getFileCacheManager();
    private RepositoryDigestRepositoryData m_thisRepositoryDigestData = null;
    private final RepositorySiteProperties m_siteProperties;

    static {
        VERSION_LATEST = VERSION_1 = new Version(0, 0, 1);
        VERSION_MAX = new Version(0, 1, 0);
        INSTALL_REPOSITORY_DIGEST_VERSION_TOLERANCE = new VersionRange(VERSION_1, true, VERSION_MAX, false);
    }

    public RepositoryDigest(RepositorySiteProperties siteProperties) {
        this.m_siteProperties = siteProperties;
    }

    public IStatus saveXML(ICicLocation a_loc) {
        try {
            this.saveXML(this.fcm.getFile(a_loc, false, null));
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.RepositoryDigest_Cant_Write_To_File, (Object)a_loc.toString()), 6253, log);
        }
    }

    public void saveXML(File a_file) throws IOException {
        log.start(log.debug("Saving {0}", a_file));
        new FileUtil.SafeUpdate(a_file){

            @Override
            public void write(FileOutputStream stream) throws IOException {
                RepositoryDigestXMLWriter wr = new RepositoryDigestXMLWriter();
                XMLWriter writer = new XMLWriter((OutputStream)stream, wr.getProcessingInstruction());
                wr.write(writer);
                writer.flush();
                FileUtil.fdSync(stream.getFD());
                writer.close();
            }
        }.write();
        log.stop();
    }

    public IStatus load(File file, ICicLocation remotePath) throws IOException {
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setSystemId(file.getAbsolutePath());
        return this.load(inputSource, remotePath);
    }

    public IStatus load(File file) throws IOException {
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setSystemId(file.getAbsolutePath());
        return this.load(inputSource);
    }

    public IStatus load(InputSource inputSource) throws IOException {
        return this.load(inputSource, null);
    }

    public IStatus load(InputSource inputSource, ICicLocation remotePath) throws IOException {
        RepositoryDigestParser parser = new RepositoryDigestParser(ComIbmCicCommonCorePlugin.getBundleContext(), this, remotePath);
        log.start(log.debug("Parsing RepositoryDigest from InputStream"));
        parser.parse(inputSource);
        log.stop();
        IStatus status = parser.getStatus();
        if (!status.isOK()) {
            throw new IOException(status.getMessage());
        }
        this.getThisRepositoryData().setDigestDataCleared(false);
        return status;
    }

    public RepositoryDigestRepositoryData getThisRepositoryData() {
        if (this.m_thisRepositoryDigestData == null) {
            if (this.m_siteProperties != null) {
                this.m_thisRepositoryDigestData = this.m_siteProperties.getRepository().getRepositoryInfo().getRepositoryDigestData();
            }
            if (this.m_thisRepositoryDigestData == null) {
                this.m_thisRepositoryDigestData = new RepositoryDigestRepositoryData("", "");
            }
        }
        return this.m_thisRepositoryDigestData;
    }

    public List<IOfferingReference> getAllOfferings() {
        return this.getAllOfferings(false);
    }

    public List<IOfferingReference> getAllOfferings(boolean includeUnavailable) {
        return this.getThisRepositoryData().getOfferingReferences(includeUnavailable);
    }

    public List<IFixReference> getAllFixes() {
        return this.getAllFixes(false);
    }

    public List<IFixReference> getAllFixes(boolean includeUnavailable) {
        return this.getThisRepositoryData().getFixReferences(includeUnavailable);
    }

    public List<IOfferingReference> getAllUpdates() {
        return this.getAllUpdates(false);
    }

    public List<IOfferingReference> getAllUpdates(boolean includeUnavailable) {
        return this.getThisRepositoryData().getUpdates(includeUnavailable);
    }

    public boolean isEmpty() {
        return this.getThisRepositoryData().getProperties().isEmpty() || this.getThisRepositoryData().isDigestDataCleared();
    }

    public void clear() {
        this.getThisRepositoryData().clear();
        this.m_thisRepositoryDigestData = null;
    }

    public void clearDigestInfo() {
        this.getThisRepositoryData().clearDigestInfo();
    }

    private class RepositoryDigestXMLWriter
    implements IRepositoryDigestXML {
        private RepositoryDigestXMLWriter() {
        }

        public XMLWriter.ProcessingInstruction getProcessingInstruction() {
            return new XMLWriter.ProcessingInstruction("repositoryDigest", MetaInfo.formatVersion(VERSION_LATEST));
        }

        public void write(XMLWriter writer) {
            writer.start("repositoryDigest");
            RepositoryDigest.this.getThisRepositoryData().emitXML(writer, false);
            writer.end("repositoryDigest");
        }
    }
}

