/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.downloads.DefaultDownloader;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.Writer;
import com.ibm.cic.common.core.model.proxy.IOfferingOrFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.utils.ContentCollection;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.AbstractFileBasedRepository;
import com.ibm.cic.common.core.repository.ArcRepositoryAdapter;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ContentJar2Repository;
import com.ibm.cic.common.core.repository.ContentZip2Repository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.LayoutPolicyDefaultLayout;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.RepositoryZipBasedSiteProperties;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.ZipArtifactRepository;
import com.ibm.cic.common.core.repository.ZipFileHandler;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentAddRemove;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ZipRepository
extends AbstractFileBasedRepository {
    private static final Logger log = Logger.getLogger(ZipRepository.class);
    public static final String ZIP_REPOSITORY_TYPE = "Zip";
    public static final String ZIP_REPOSITORY_VERSION = "0.0.0.1";
    private IZipFileHandler m_arcHandler;
    private boolean m_isLocal = false;
    protected ICicLocation m_subRepositoryLocation;

    public ZipRepository() {
        this(ZIP_REPOSITORY_TYPE, ZIP_REPOSITORY_VERSION);
    }

    protected ZipRepository(String type, String version) {
        super(type, version);
        this.setArtifactRepository(new ZipArtifactRepository(){

            @Override
            public ZipRepository getRepository() {
                return ZipRepository.this;
            }
        });
        this.setLayoutPolicy(new LayoutPolicyDefaultLayout(this));
        this.setSiteProperties(new RepositoryZipBasedSiteProperties(this.getLP()));
    }

    public IZipFileHandler getArcHandler() {
        return this.m_arcHandler;
    }

    @Override
    public IStatus initializeRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        IStatus return_value = super.initializeRepository(repInfo, progressMonitor);
        if (return_value.isOK()) {
            File locationFile = repInfo.getLocation().toFile();
            CicFileLocation nameLoc = new CicFileLocation(repInfo.getName());
            File nameFile = nameLoc.toFile();
            if (nameFile.getName().endsWith(this.getDotFileExt()) && !nameFile.isDirectory() || locationFile.getName().endsWith(this.getDotFileExt()) && !locationFile.isDirectory()) {
                File dir_or_file;
                ICicLocation fileLocation;
                if (repInfo.getLocationStr().endsWith(this.getDotFileExt())) {
                    fileLocation = repInfo.getLocation();
                    dir_or_file = repInfo.getLocation().toFile().getParentFile();
                    this.m_isLocal = dir_or_file != null && dir_or_file.exists();
                } else {
                    fileLocation = repInfo.getLocation().append(repInfo.getName());
                    dir_or_file = repInfo.getLocation().toFile();
                    this.m_isLocal = dir_or_file.exists();
                }
                if (this.m_isLocal && this.isWritable()) {
                    this.m_arcHandler = new ZipFileHandler(fileLocation.toFile());
                } else {
                    try {
                        this.setWritable(false);
                        this.m_arcHandler = new ZipFileHandler(new FileContentInfo(fileLocation), this.getDownloader());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return_value = this.getStatus(false, null);
                if (!return_value.isOK() && !this.getSiteProperties().isInitialized()) {
                    return_value = Status.OK_STATUS;
                }
            } else {
                return_value = RepositoryStatus.createErrorMultiStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr(), return_value);
            }
            this.m_subRepositoryLocation = repInfo.getLocationStr().endsWith(this.getDotFileExt()) ? this.getLocation() : this.getLocation().append(this.getName());
        }
        return return_value;
    }

    @Override
    protected void setDownloader() {
        this.setDownloader(new DefaultDownloader(false));
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        IStatus return_value = super.isRepInfoMatchingRepositoryObject(repInfo);
        if (!(!return_value.isOK() || repInfo.getLocationStr().endsWith(this.getDotFileExt()) || repInfo.getName() != null && repInfo.getName().equals(this.getName()))) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        return return_value;
    }

    @Override
    public IStatus canCreateRepository() {
        Object return_value = null;
        if (this.m_isLocal) {
            return_value = super.canCreateRepository();
            if (return_value.isOK()) {
                return_value = this.getSiteProperties().canCreate();
            }
        } else {
            return_value = new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_AT_REMOTE_LOC, this, this.getLocationStr());
        }
        return return_value;
    }

    @Override
    protected IStatus doCreateRepository() {
        IStatus return_value = super.doCreateRepository();
        if (return_value.isOK()) {
            return_value = this.getSiteProperties().save();
        }
        return return_value;
    }

    @Override
    protected String[] getFileNames(ICicLocation relativeDirLocation, AbstractFileBasedRepository.Filter filter) {
        ArrayList<String> return_value = new ArrayList<String>();
        Set allFileNames = this.getArcHandler().getFileNames();
        Iterator I = allFileNames.iterator();
        while (I.hasNext()) {
            String fileName;
            CicFileLocation loc = new CicFileLocation((String)I.next());
            if (!relativeDirLocation.toString().equals(loc.getPathSegments()) || !filter.acceptableFileName(fileName = loc.getName())) continue;
            return_value.add(fileName);
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    public IContent addContent(IContent content) throws IOException {
        IContent return_value = null;
        if (content != null && this.isOpen() && this.isWritable() && this.getStatus(true, null).isOK() && this.canStoreMetadata()) {
            IContentRepository subRepository;
            ICicLocation contentFolderPath = this.getLP().getRelativeTopDirPath(content.getClass());
            String fileName = Writer.getFileName(content);
            if (!this.getArcHandler().containsFile(contentFolderPath.append(fileName).toString()) && this.getArcHandler().openToAddOrDeleteFiles() && (subRepository = this.createSubRepository(content, fileName, this.getLP().getRelativeTopDirPath(content.getClass()))) != null) {
                IContentRepository cer = RepositoryUtils.getContentRepository(content);
                if (cer != null) {
                    subRepository.copyFrom(cer, null);
                }
                if (content instanceof IOffering) {
                    IOffering offering = (IOffering)content;
                    this.addOfferingChildrenToCer(offering, subRepository);
                    this.getUpdatesHandler().setUpdateOffering(offering);
                }
                if (content instanceof IOfferingOrFixReference) {
                    IOfferingOrFixReference ref = (IOfferingOrFixReference)content;
                    ref.addToSiteProperties(this.getSiteProperties());
                }
                this.getArcHandler().close();
                return_value = subRepository.getElement();
                if (return_value != null) {
                    return_value = this.customizeNewIContentObject(subRepository, return_value, this.getLP().getRelativeTopDirPath(return_value.getClass()).append(fileName));
                    this.publishEvent(new RepositoryEventContentAddRemove(this, return_value, true));
                }
            }
        }
        return return_value;
    }

    private void addOfferingChildrenToCer(IOffering offering, IRepository subRepo) {
        IAssembly assembly = offering.getAssembly();
        if (assembly != null) {
            ContentCollection contentCollection = new ContentCollection(assembly, offering.getProperties(), false, null);
            ArrayList<IContent> elements = new ArrayList<IContent>();
            for (IContent element : contentCollection) {
                elements.add(element);
            }
            try {
                subRepo.addContent(elements);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected IContentRepository createSubRepository(IContent content, String fileName, ICicLocation relativeLocation) {
        AbstractBaseRepository return_value = null;
        IRepositoryInfo subRepositoryInfo = this.createSubRepositoryInfo(relativeLocation, fileName);
        if (subRepositoryInfo != null) {
            try {
                subRepositoryInfo.setProperty("ArcHandler", this.getArcHandler());
                subRepositoryInfo.setProperty("RepositoryElement", content);
                subRepositoryInfo.setProperty("InternalDirOffset", relativeLocation.toString());
                AbstractBaseRepository rep = null;
                rep = subRepositoryInfo.getType() == "ContentZip2" ? ContentZip2Repository.createRepositoryObject(subRepositoryInfo) : ContentJar2Repository.createRepositoryObject(subRepositoryInfo);
                IStatus status = rep.addExistingRepository();
                if (!status.isOK() && content != null) {
                    status = rep.createRepository();
                }
                if (status.isOK()) {
                    return_value = rep;
                    return_value.setRepositoryReference(this.getRepositoryReference());
                }
            }
            catch (Throwable e) {
                ExceptionUtil.debugLogToReview(e);
                e.printStackTrace();
            }
        }
        return (IContentRepository)((Object)return_value);
    }

    @Override
    protected IContentRepository findSubRepository(IContent content, String fileName, ICicLocation relativeLocation) {
        AbstractBaseRepository return_value = null;
        IRepositoryInfo subRepositoryInfo = this.createSubRepositoryInfo(relativeLocation, fileName);
        if (subRepositoryInfo != null) {
            try {
                subRepositoryInfo.setProperty("ArcHandler", this.getArcHandler());
                subRepositoryInfo.setProperty("RepositoryElement", null);
                subRepositoryInfo.setProperty("InternalDirOffset", relativeLocation.toString());
                AbstractBaseRepository rep = null;
                rep = subRepositoryInfo.getType() == "ContentZip2" ? ContentZip2Repository.createRepositoryObject(subRepositoryInfo) : ContentJar2Repository.createRepositoryObject(subRepositoryInfo);
                IStatus status = rep.addExistingRepository();
                if (status.isOK()) {
                    return_value = rep;
                    return_value.setRepositoryReference(this.getRepositoryReference());
                }
            }
            catch (Throwable e) {
                ExceptionUtil.debugLogToReview(e);
                e.printStackTrace();
            }
        }
        return (IContentRepository)((Object)return_value);
    }

    protected IRepositoryInfo createSubRepositoryInfo(ICicLocation relLoc, String a_fileName) {
        IRepositoryInfo return_value = null;
        if (CicConstants.fileMatchesDEFAULT_EXTENSIONS(a_fileName) || a_fileName.endsWith(CicConstants.getZipFileDotExt())) {
            return_value = RepositoryGroup.getDefault().createRepositoryInfo(a_fileName, "ContentZip2", ZIP_REPOSITORY_VERSION, this.m_subRepositoryLocation, null);
        } else if (a_fileName.endsWith(CicConstants.getJarFileDotExt())) {
            return_value = RepositoryGroup.getDefault().createRepositoryInfo(a_fileName, "ContentJar2", ZIP_REPOSITORY_VERSION, this.m_subRepositoryLocation.append(relLoc).append(a_fileName), null);
        }
        return return_value;
    }

    @Override
    public InputStream getInputStream(String relativePath) throws IOException {
        return this.m_arcHandler.getInputStream(relativePath);
    }

    @Override
    public IStatus doSaveContent(IContent content) throws IOException {
        IStatus return_value = this.deleteContent(content);
        if (return_value.isOK()) {
            this.addContent(content);
        }
        return return_value;
    }

    @Override
    public IStatus doDeleteContent(IContent content) {
        IContentRepository rep;
        if (this.getStatus(false, null).isOK() && (rep = this.getContentRepository(content)) != null && rep.delete(true).isOK()) {
            if (UpdateOfferingUtils.isUpdate(content)) {
                this.getUpdatesHandler().unsetUpdateOffering((IOffering)content);
            }
            if (content instanceof IOfferingReference) {
                IOfferingOrFixReference ref = (IOfferingOrFixReference)content;
                ref.removeFromSiteProperties(this.getSiteProperties());
            }
        }
        return this.getStatus(false, null);
    }

    @Override
    public IStatus delete(boolean mustClear) {
        if (this.getStatus(false, null).isOK()) {
            this.dispose();
        }
        if (this.getStatus(false, null).isOK()) {
            if (!mustClear) {
                this.m_arcHandler.deleteFiles(RepositoryFileBasedSiteProperties.REP_MAIN_SITE_PROPERTY_FILES);
            } else if (!this.m_arcHandler.delete()) {
                this.setStatus((IStatus)new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this));
            }
        }
        return this.getStatus(false, null);
    }

    @Override
    public IStatus clear() {
        if (this.getStatus(false, null).isOK()) {
            Set files = this.m_arcHandler.getFileNames();
            files.removeAll(RepositoryFileBasedSiteProperties.REP_MAIN_SITE_PROPERTY_FILES);
            this.m_arcHandler.deleteFiles(files);
        }
        return super.clear();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ArcRepositoryAdapter.class) {
            return new ArcRepositoryAdapter(this);
        }
        if (adapter == ZipRepository.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getDotFileExt() {
        return CicConstants.getZipFileDotExt();
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        return this.getArcHandler().containsFile(this.getLP().getRelativeP2FilePath().toString());
    }

    @Override
    protected IStatus doDeleteP2Repository(IProgressMonitor monitor) {
        IStatus return_value = null;
        if (this.isWritable()) {
            try {
                if (this.getArcHandler().openToAddOrDeleteFiles() && this.getArcHandler().deleteFile(this.getLP().getRelativeP2FilePath().toString())) {
                    this.getArcHandler().close();
                    return_value = Status.OK_STATUS;
                }
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2RepositoryReadOnly, this, 6074, log);
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2Repository, this, 6073, log);
        }
        return return_value;
    }

    @Override
    protected IStatus doImportP2Repository(File sourceP2RepositoryFile, IProgressMonitor monitor) {
        IStatus return_value = null;
        if (sourceP2RepositoryFile != null && this.isOpen() && this.canStoreMetadata()) {
            if (this.isWritable()) {
                if (sourceP2RepositoryFile.exists()) {
                    try {
                        if (this.getArcHandler().openToAddOrDeleteFiles()) {
                            ZipOutputStream zout = this.getArcHandler().startAddingFile(this.getLP().getRelativeP2FilePath().toString());
                            FileUtil.copyFileToStream(sourceP2RepositoryFile, zout, false, monitor);
                            this.getArcHandler().completeAddingFile();
                            this.getArcHandler().close();
                            return_value = Status.OK_STATUS;
                        }
                    }
                    catch (IOException e) {
                        return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log, e);
                    }
                } else {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryIsMissing, this, 6070, log);
                }
            } else {
                return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryReadOnly, this, 6071, log);
            }
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log);
        }
        return return_value;
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor monitor) {
        return this.exportZippedP2Repository(this.getArcHandler(), destinationFile);
    }

    @Override
    public String[] getNLSFileList() {
        ArrayList<String> return_value = new ArrayList<String>();
        ICicLocation subPath = this.getLP().getRelativeTopNLSDirPath();
        Iterator I = this.getArcHandler().getFileNames().iterator();
        while (I.hasNext()) {
            CicFileLocation loc = new CicFileLocation((String)I.next());
            String file = loc.getNextSegment(subPath);
            if (file == null || !file.endsWith(".properties")) continue;
            return_value.add(file);
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    protected IStatus doAddNLSFile(String fileName, InputStream source) throws IOException {
        ICicLocation contentFolderPath = this.getLP().getRelativeTopNLSDirPath();
        if (this.m_arcHandler.openToAddOrDeleteFiles()) {
            ZipOutputStream zout = this.m_arcHandler.startAddingFile(contentFolderPath.append(fileName).toString());
            try {
                int num;
                byte[] buf = new byte[1024];
                while ((num = source.read(buf, 0, 1024)) != -1) {
                    zout.write(buf, 0, num);
                }
            }
            finally {
                this.m_arcHandler.completeAddingFile();
                this.m_arcHandler.close();
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus doDeleteNLSFile(String fileName) {
        IStatus return_value = null;
        if (this.isWritable()) {
            String fileToDelete = this.getLP().getRelativeTopNLSDirPath().append(fileName).toString();
            if (this.getArcHandler().deleteFile(fileToDelete)) {
                return_value = Status.OK_STATUS;
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteNLFileReadOnly, fileName, this, 6081, log);
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteNLFile, fileName, this, 6080, log);
        }
        return return_value;
    }
}

