/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.utils.FilterCollectionUtil;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class UnspecifiedUtils {
    public static final Version versionUnspecified = Version.emptyVersion;
    public static final VersionRange toleranceUnspecified = VersionUtil.UNSPECIFIED_TOLERANCE;
    private static final String QUALIFIER = "qualifier";
    private static UnspecifiedUtils defaultUtils;
    private final IRepositoryGroup repoService;
    private boolean updateAllQualifiers = false;

    public UnspecifiedUtils(IRepositoryGroup repoService) {
        this.repoService = repoService;
    }

    public static UnspecifiedUtils getDefault() {
        if (defaultUtils == null) {
            RepositoryGroup repoService = RepositoryGroup.getDefault();
            defaultUtils = new UnspecifiedUtils(repoService);
        }
        return defaultUtils;
    }

    public IShareableEntity findShareableEntityUpdateIncludedShareableEntity(IIncludedShareableEntity include, IProgressMonitor progressMonitor) {
        IIdentity id = include.getIdentity();
        Version version = include.getVersion();
        VersionRange tolerance = include.getTolerance();
        IShareableEntity se = this.findShareableEntity(id, version, tolerance, progressMonitor);
        this.fixupISE(include, se);
        return se;
    }

    public void fixupISE(IIncludedShareableEntity include, IShareableEntity se) {
        if (se != null) {
            Version version = include.getVersion();
            VersionRange tolerance = include.getTolerance();
            include.setContent(se);
            Version seVersion = se.getVersion();
            if (version.equals((Object)versionUnspecified)) {
                include.setVersion(seVersion);
            }
            if (tolerance.equals((Object)toleranceUnspecified)) {
                include.setTolerance(VersionUtil.getDefaultTolerance(seVersion));
            } else if (tolerance.getMinimum().equals((Object)versionUnspecified)) {
                include.setTolerance(VersionUtil.replaceMinimumForVersion(seVersion, tolerance));
            }
        }
    }

    public boolean resolveVersionQualifier(IContent content, String qualifier) {
        Version newVersion;
        if (qualifier != null && (newVersion = this.getNewVersion(content.getVersion(), qualifier)) != null) {
            content.setVersion(newVersion);
            return true;
        }
        return false;
    }

    public boolean resolveVersionQualifier(IIncludedShareableEntity ise, String qualifier) {
        Version newVersion;
        if (qualifier != null && (newVersion = this.getNewVersion(ise.getVersion(), qualifier)) != null) {
            ise.setVersion(newVersion);
            return true;
        }
        return false;
    }

    private Version getNewVersion(Version version, String qualifier) {
        Version newVersion = null;
        if (version.getQualifier().equals(QUALIFIER)) {
            newVersion = new Version(version.getMajor(), version.getMinor(), version.getMicro(), qualifier);
        } else if (this.updateAllQualifiers && !version.equals((Object)versionUnspecified)) {
            String existingQualifier = version.getQualifier();
            String updatedQualifier = null;
            if (existingQualifier == null || existingQualifier.length() == 0) {
                updatedQualifier = qualifier;
            } else if (!existingQualifier.endsWith(qualifier)) {
                updatedQualifier = String.valueOf(existingQualifier) + '-' + qualifier;
            }
            if (updatedQualifier != null) {
                newVersion = new Version(version.getMajor(), version.getMinor(), version.getMicro(), updatedQualifier);
            }
        }
        return newVersion;
    }

    public IAssembly findAssemblyUpdateOfferingOrFixAndAssembly(IOfferingOrFix oof, String qualifier, IProgressMonitor monitor) {
        this.resolveVersionQualifier(oof, qualifier);
        IAssembly assembly = oof.getAssembly();
        if (assembly == null) {
            assembly = this.findAssemblyUpdateOfferingOrFix(oof, null);
        }
        if (assembly != null && this.resolveVersionQualifier(assembly, qualifier)) {
            oof.setAssemblyVersion(assembly.getVersion());
        }
        return assembly;
    }

    public void updateQualifierOfferingOrFixAndAssembly(IOfferingOrFix oof, String qualifier) {
        this.resolveVersionQualifier(oof, qualifier);
        IAssembly assembly = oof.getAssembly();
        if (assembly != null && this.resolveVersionQualifier(assembly, qualifier)) {
            oof.setAssemblyVersion(assembly.getVersion());
        }
    }

    public IAssembly findAssemblyUpdateOfferingOrFix(IOfferingOrFix oof, IProgressMonitor progressMonitor) {
        Version version;
        IIdentity id = oof.getAssemblyId();
        IShareableEntity se = this.findShareableEntity(id, version = oof.getAssemblyVersion(), null, progressMonitor);
        if (se == null) {
            return null;
        }
        if (!(se instanceof IAssembly)) {
            return null;
        }
        IAssembly assembly = (IAssembly)se;
        oof.setAssembly(assembly);
        if (version.equals((Object)versionUnspecified)) {
            oof.setAssemblyVersion(assembly.getVersion());
        }
        return assembly;
    }

    public IShareableEntity findShareableEntity(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor progressMonitor) {
        if (versionUnspecified.equals((Object)version)) {
            version = null;
        }
        if (toleranceUnspecified.equals((Object)tolerance)) {
            tolerance = null;
        }
        IShareableEntity highestVersionSe = null;
        List seList = this.repoService.getShareableEntities(id, version, tolerance, progressMonitor);
        for (IShareableEntity se : seList) {
            if (se.compareVersion(highestVersionSe) <= 0) continue;
            highestVersionSe = se;
        }
        return highestVersionSe;
    }

    public IOffering findOffering(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor progressMonitor) {
        if (!version.equals((Object)versionUnspecified)) {
            return this.repoService.findOffering(id, version, progressMonitor);
        }
        List offeringOrFixList = this.repoService.getAllOfferings(progressMonitor);
        return (IOffering)this.findHighestOfferingOrFix(id, tolerance, offeringOrFixList);
    }

    public IOffering findUpdateOffering(IIdentity id, Version version, VersionRange tolerance, final Version baseVersion, IProgressMonitor progressMonitor) {
        if (!version.equals((Object)versionUnspecified)) {
            return this.repoService.findUpdate(id, version, progressMonitor);
        }
        List updates = this.repoService.getAllUpdates(id, null, progressMonitor);
        ArrayList list = new ArrayList();
        FilterCollectionUtil.filter((Collection)updates, list, new FilterCollectionUtil.CollectionFilter(){

            @Override
            public boolean include(Object o) {
                if (o instanceof IOffering) {
                    if (baseVersion.equals((Object)versionUnspecified)) {
                        return true;
                    }
                    IOffering offering = (IOffering)o;
                    Version v = UpdateOfferingUtils.getBaseOfferingVersion(offering);
                    return baseVersion.equals((Object)v);
                }
                return false;
            }
        });
        return (IOffering)this.findHighestOfferingOrFix(id, tolerance, list);
    }

    public IFix findFix(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor progressMonitor) {
        if (!version.equals((Object)versionUnspecified)) {
            return this.repoService.findFix(id, version, progressMonitor);
        }
        List offeringOrFixList = this.repoService.getAllFixes(progressMonitor);
        return (IFix)this.findHighestOfferingOrFix(id, tolerance, offeringOrFixList);
    }

    public void setUpdateAllQualifiers(boolean updateAllQualifiers) {
        this.updateAllQualifiers = updateAllQualifiers;
    }

    private IOfferingOrFix findHighestOfferingOrFix(IIdentity id, VersionRange tolerance, List offeringOrFixList) {
        if (tolerance != null && tolerance.equals((Object)toleranceUnspecified)) {
            tolerance = null;
        }
        IOfferingOrFix highestOfferingOrFix = null;
        for (IOfferingOrFix oof : offeringOrFixList) {
            if (!oof.getIdentity().equals(id) || tolerance != null && !tolerance.isIncluded(oof.getVersion()) || oof.compareVersion(highestOfferingOrFix) <= 0) continue;
            highestOfferingOrFix = oof;
        }
        return highestOfferingOrFix;
    }
}

