/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.LayoutPolicy;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.ZipRepository;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class RepositoryZipBasedSiteProperties
extends RepositoryFileBasedSiteProperties {
    RepositoryZipBasedSiteProperties(LayoutPolicy layoutPolicy) {
        super(layoutPolicy);
    }

    @Override
    public IStatus save() {
        IZipFileHandler zipHandler = this.getZipRepository().getArcHandler();
        try {
            if (zipHandler.openToAddOrDeleteFiles()) {
                ZipOutputStream zout = zipHandler.startAddingFile("repository.config");
                this.save(zout, null);
                zipHandler.completeAddingFile();
                zipHandler.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.RepositoryDigest_Cant_Write_To_File, (Object)"repository.config"), 6253, log);
        }
        return Status.OK_STATUS;
    }

    @Override
    IStatus canCreate() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus load(IDownloader downloader, IProgressMonitor progressMonitor) {
        block7: {
            try {
                IZipFileHandler zipHandler = this.getZipRepository().getArcHandler();
                if (!zipHandler.exists()) break block7;
                String propName = null;
                for (String name : REP_MAIN_SITE_PROPERTY_FILES) {
                    if (!zipHandler.containsFile(name)) continue;
                    propName = name;
                    break;
                }
                if (propName != null) {
                    this.m_outputFileName = propName;
                    File file = zipHandler.getFile();
                    InputStream input = zipHandler.getInputStream(propName);
                    try {
                        this.load(file.getAbsolutePath(), propName, input);
                    }
                    finally {
                        FileUtil.close(input);
                    }
                }
                return Status.OK_STATUS;
            }
            catch (IOException e) {
                log.debug("Repository site information not read. ");
                log.debug("Reason:", e);
                RepositoryStatus stat = new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this.getLayoutPolicy().getRepository());
                stat.setException(e);
                return stat;
            }
        }
        return new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, this.getLayoutPolicy().getRepository());
    }

    @Override
    public ICicPreferenceHandler getChildPreferenceHandler(String childHandlerId) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IStatus deleteRepositoryDigest() {
        IZipFileHandler zipHandler = this.getZipRepository().getArcHandler();
        if (!zipHandler.exists()) return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.Downloader_File_Does_Not_Exist, (Object)"repository.xml"), 6251, log);
        if (!zipHandler.containsFile("repository.xml")) return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.Downloader_File_Does_Not_Exist, (Object)"repository.xml"), 6251, log);
        if (!zipHandler.deleteFile("repository.xml")) {
            return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.FileLog_Failed_To_Delete, (Object)"repository.xml"), 6251, log);
        }
        this.m_repDigest.clearDigestInfo();
        this.m_repDigest.getThisRepositoryData().setUseContentData(false);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus saveRepositoryDigest(ICicLocation a_destLocation) {
        if (a_destLocation != null) {
            return super.saveRepositoryDigest(a_destLocation);
        }
        IZipFileHandler zipHandler = this.getZipRepository().getArcHandler();
        if (zipHandler.exists()) {
            try {
                File tmpDigest = TempUtil.createTempFile("FCM_repository.xml", "");
                this.m_repDigest.saveXML(tmpDigest);
                zipHandler.addFile("repository.xml", tmpDigest);
                this.m_repDigest.getThisRepositoryData().setUseContentData(true);
                tmpDigest.delete();
                return Status.OK_STATUS;
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return RepositoryStatus.createErrorStatus(NLS.bind((String)Messages.RepositoryDigest_Cant_Write_To_File, (Object)"repository.xml"), 6253, log);
    }

    private ZipRepository getZipRepository() {
        return (ZipRepository)this.getLayoutPolicy().getRepository();
    }
}

