/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.IncludedShareableEntity;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class LayoutPolicy {
    private static final String SUBDIR_SHAREABLE_ENTITIES = "ShareableEntities";
    private static final String SUBDIR_FIXES = "Fixes";
    public static final String SUBDIR_NL = "nl/";
    public static final String P2_REPOSITORY_FILE = "content.xml";
    private static final String SUBDIR_P2_FILE = "p2/content.xml";
    static final String SUBDIR_NL_FILE = "messages";
    private static final String SUBDIR_OFFERINGS = "Offerings";
    private static final String EMPTY_STR = "";
    protected static final ICicLocation EMPTY_LOCATION = new CicFileLocation("");
    private final IRepository m_repository;
    private ICicLocation m_relativeDirectoryPrefix;
    private ICicLocation m_fqTopBaseLocation;
    private ICicLocation m_fqTopNLSLocation;
    private ICicLocation m_fqTopSeLocation;
    private ICicLocation m_fqTopP2Location;
    private ICicLocation m_relativeTopSeDir;
    private ICicLocation m_relativeTopNLSDir;
    private ICicLocation m_relativeTopFixDir;
    private ICicLocation m_relativeTopOfferingDir;
    private ICicLocation m_relativeTopP2File;
    static final int TYPE_UNKNOWN = -1;
    static final int TYPE_OFFERING = 1;
    static final int TYPE_ASSEMBLY = 2;
    static final int TYPE_SU = 3;
    static final int TYPE_SU_FRAGMENT = 4;
    static final int TYPE_SE = 5;
    static final int TYPE_FIX = 6;
    public static final String CONFIG_PREF_OFFERING = "RECOMMENDED_OFFERING_";

    protected LayoutPolicy(IRepository repository) {
        this.m_repository = repository;
    }

    protected IRepository getRepository() {
        return this.m_repository;
    }

    protected ICicLocation getRelativeDirectoryPrefix() {
        if (this.m_relativeDirectoryPrefix == null) {
            this.m_relativeDirectoryPrefix = EMPTY_LOCATION;
        }
        return this.m_relativeDirectoryPrefix;
    }

    public abstract String getId();

    public abstract String getVersion();

    public IStatus setDefaultSiteInformation() {
        this.getRepository().getSiteProperties().setProperty("LayoutPolicy", this.getId());
        this.getRepository().getSiteProperties().setProperty("LayoutPolicyVersion", this.getVersion());
        return Status.OK_STATUS;
    }

    public ICicLocation getRelativeTopFixDirPath() {
        if (this.m_relativeTopFixDir == null) {
            this.m_relativeTopFixDir = this.getRelativeDirectoryPrefix().append(SUBDIR_FIXES);
        }
        return this.m_relativeTopFixDir;
    }

    public ICicLocation getRelativeTopOfferingDirPath() {
        if (this.m_relativeTopOfferingDir == null) {
            this.m_relativeTopOfferingDir = this.getRelativeDirectoryPrefix().append(SUBDIR_OFFERINGS);
        }
        return this.m_relativeTopOfferingDir;
    }

    public ICicLocation getRelativeTopSeDirPath() {
        if (this.m_relativeTopSeDir == null) {
            this.m_relativeTopSeDir = this.getRelativeDirectoryPrefix().append(SUBDIR_SHAREABLE_ENTITIES);
        }
        return this.m_relativeTopSeDir;
    }

    protected ICicLocation getRelativeP2FilePath() {
        if (this.m_relativeTopP2File == null) {
            this.m_relativeTopP2File = this.getRelativeDirectoryPrefix().append(SUBDIR_P2_FILE);
        }
        return this.m_relativeTopP2File;
    }

    public ICicLocation getRelativeTopSuDirPath() {
        return this.getRelativeTopSeDirPath();
    }

    public ICicLocation getRelativeTopAssemblyDirPath() {
        return this.getRelativeTopSeDirPath();
    }

    protected ICicLocation getRelativeTopNLSDirPath() {
        if (this.m_relativeTopNLSDir == null) {
            this.m_relativeTopNLSDir = this.getRelativeDirectoryPrefix().append(SUBDIR_NL);
        }
        return this.m_relativeTopNLSDir;
    }

    protected final ICicLocation getRelativeTopDirPath(Class elementClass) {
        if (IOffering.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopOfferingDirPath();
        }
        if (IShareableEntity.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopSeDirPath();
        }
        if (IAssembly.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopAssemblyDirPath();
        }
        if (IShareableUnit.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopSuDirPath();
        }
        if (ISuFragment.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopSuDirPath();
        }
        if (IFix.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopFixDirPath();
        }
        if (IInstallableUnit.class.isAssignableFrom(elementClass)) {
            return this.getRelativeTopSeDirPath();
        }
        return null;
    }

    protected String getRelativeTopDir(IContent content) {
        if (IOffering.class.isInstance(content)) {
            return this.getRelativeTopOfferingDirPath().toString();
        }
        if (IncludedShareableEntity.class.isInstance(content)) {
            return this.getRelativeTopSeDirPath().toString();
        }
        if (IAssembly.class.isInstance(content)) {
            return this.getRelativeTopAssemblyDirPath().toString();
        }
        if (IShareableUnit.class.isInstance(content)) {
            return this.getRelativeTopSuDirPath().toString();
        }
        if (ISuFragment.class.isInstance(content)) {
            return this.getRelativeTopSuDirPath().toString();
        }
        if (IFix.class.isInstance(content)) {
            return this.getRelativeTopFixDirPath().toString();
        }
        if (IInstallableUnit.class.isInstance(content)) {
            return this.getRelativeTopSeDirPath().toString();
        }
        ComIbmCicCommonCorePlugin.getTrace().println("getRelativeTopDir(): unknown content type");
        return null;
    }

    public ICicLocation getFQTopP2Path() {
        if (this.m_fqTopP2Location == null) {
            this.m_fqTopP2Location = this.getRepository().getLocation().append(this.getRelativeP2FilePath());
        }
        return this.m_fqTopP2Location;
    }

    protected ICicLocation getFQTopBaseDirPath() {
        if (this.m_fqTopBaseLocation == null) {
            this.m_fqTopBaseLocation = this.getRepository().getLocation().append(this.getRelativeDirectoryPrefix());
        }
        return this.m_fqTopBaseLocation;
    }

    protected ICicLocation getFQTopSeDirPath() {
        if (this.m_fqTopSeLocation == null) {
            this.m_fqTopSeLocation = this.getRepository().getLocation().append(this.getRelativeTopAssemblyDirPath());
        }
        return this.m_fqTopSeLocation;
    }

    protected ICicLocation getFQTopNLSPath() {
        if (this.m_fqTopNLSLocation == null) {
            this.m_fqTopNLSLocation = this.getRepository().getLocation().append(this.getRelativeTopNLSDirPath());
        }
        return this.m_fqTopNLSLocation;
    }

    protected ICicLocation getCalculatedFQDirPath(IContent content) {
        ICicLocation path = this.getRepository().getLocation();
        String folder = this.getRelativeTopDir(content);
        return path.append(folder);
    }

    public abstract IPath getCalculatedFQDirPath(String var1, IContent var2);

    public abstract IPath getCalculatedRelativeDirPath(IContent var1);

    protected void reset() {
        this.m_relativeDirectoryPrefix = null;
        this.m_fqTopBaseLocation = null;
        this.m_fqTopNLSLocation = null;
        this.m_fqTopSeLocation = null;
        this.m_fqTopP2Location = null;
        this.m_relativeTopSeDir = null;
        this.m_relativeTopNLSDir = null;
        this.m_relativeTopFixDir = null;
        this.m_relativeTopOfferingDir = null;
        this.m_relativeTopP2File = null;
    }
}

