/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.preferences.ProxyPreferenceInternalUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.ProxyProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class ICicPreferenceConstants {
    public static final String PREFERENCES_FILE_EXTENSION = ".prefs";
    public static final PreferenceTag REPOSITORY_SPECIAL_SETTINGS = new PreferenceTag("RepositorySpecialSettings", Messages.Prefs_RepositorySpecialSettingsLabel, Messages.Prefs_RepositorySpecialSettingsDesc);
    public static final PreferenceTag REPOSITORY_IS_OPEN = new PreferenceTag("RepositoryIsOpen", Messages.Prefs_RepositoryIsOpenLabel, Messages.Prefs_RepositoryIsOpenDesc, 2);
    public static final PreferenceTag REPOSITORY_LOCATIONS = new PreferenceTag("com.ibm.cic.common.core.preferences.repositoryLocations", Messages.Prefs_RepositoryLocationsLabel, Messages.Prefs_RepositoryLocationsDesc, 1, new PreferenceTag[]{REPOSITORY_SPECIAL_SETTINGS, REPOSITORY_IS_OPEN}, true);
    public static final PreferenceTag SERVICE_REPOSITORY_MAP = new PreferenceTag("SERVICE_REPOSITORY_MAP", Messages.Prefs_ServiceRepositoryMapLabel, Messages.Prefs_ServiceRepositoryMapDesc);
    public static final PreferenceTag DIRECT_ARTIFACT_ACCESS_MODE = new PreferenceTag("com.ibm.cic.common.core.preferences.directArtifactAccessMode", Messages.Prefs_DirectArtifactAccessModeLabel, Messages.Prefs_DirectArtifactAccessModeDesc, 2, null, false);
    public static final PreferenceTag LOG_LOCATION = new PreferenceTag("com.ibm.cic.common.core.preferences.logLocation", Messages.Prefs_LogLocationLabel, Messages.Prefs_LogLocationDesc, 1, null, false);
    public static final PreferenceTag DEFAULT_PROFILE = new PreferenceTag("com.ibm.cic.common.core.preferences.defaultProfile", Messages.Prefs_DefaultProfileLocationLabel, Messages.Prefs_DefaultProfileLocationDesc);
    public static final PreferenceTag CONNECT_TIMEOUT = new PreferenceTag("com.ibm.cic.common.core.preferences.connectTimeout", Messages.Prefs_ConnectTimeoutLabel, Messages.Prefs_ConnectTimeoutDesc);
    public static final PreferenceTag READ_TIMEOUT = new PreferenceTag("com.ibm.cic.common.core.preferences.readTimeout", Messages.Prefs_ReadTimeoutLabel, Messages.Prefs_ReadTimeoutDesc);
    public static final PreferenceTag DOWNLOAD_AUTO_RETRY_COUNT = new PreferenceTag("com.ibm.cic.common.core.preferences.downloadAutoRetryCount", Messages.Prefs_DownloadAutoRetryCountLabel, Messages.Prefs_DownloadAutoRetryCountDesc);
    public static final PreferenceTag USE_SERVICE_REPOSITORIES = new PreferenceTag("offering.service.repositories.areUsed", "Messages.Prefs_OfferingServiceRepositoriesIsUsedLabel", "Messages.Prefs_OfferingServiceRepositoriesIsUsedDesc", 2);
    public static final PreferenceTag PRESERVE_DOWNLOADED_ARTIFACTS = new PreferenceTag("com.ibm.cic.common.core.preferences.preserveDownloadedArtifacts", Messages.DownloadCachePreference_PreserveArtifacts, Messages.DownloadCachePreference_PreserveArtifacts, 2);
    public static final PreferenceTag KEEP_FETCHED_FILES = new PreferenceTag("com.ibm.cic.common.core.preferences.keepFetchedFiles", Messages.DownloadCachePreference_KeepFetchedFiles, Messages.DownloadCachePreference_KeepFetchedFiles, 2);
    public static final PreferenceTag SSL_NONSECURE_MODE = new PreferenceTag("com.ibm.cic.common.core.preferences.ssl.nonsecureMode", Messages.Prefs_SSL_NonsecureModeLabel, Messages.Prefs_SSL_NonsecureModeDesc, 2);
    public static final PreferenceTag HTTP_DISABLE_PREEMPTIVE_AUTHENTICATION = new PreferenceTag("com.ibm.cic.common.core.preferences.http.disablePreemptiveAuthentication", Messages.ICicPreferenceConstants_Prefs_HTTP_DisablePreemptiveAuthenticationLabel, Messages.ICicPreferenceConstants_Prefs_HTTP_DisablePreemptiveAuthenticationDesc, 2);
    public static final PreferenceTag HTTP_ENABLE_GZIP_ACCEPT_ENCODING = new PreferenceTag("com.ibm.cic.common.core.preferences.http.enableGzipAcceptEncoding", Messages.ICicPreferenceConstants_Prefs_HTTP_EnableGzipAcceptEncodingLabel, Messages.ICicPreferenceConstants_Prefs_HTTP_EnableGzipAcceptEncodingDesc, 2);
    public static final PreferenceTag HTTP_NTLM_AUTH_KIND = new PreferenceTag("http.ntlm.auth.kind", Messages.ICicPreferenceConstants_ntlmAuthKindLabel, Messages.ICicPreferenceConstants_ntlmAuthKindDescr);
    public static final String HTTP_NTLM_AUTH_KIND_LM = "LM";
    public static final String HTTP_NTLM_AUTH_KIND_NTLM = "NTLM";
    public static final String HTTP_NTLM_AUTH_KIND_NTLMv2 = "NTLMv2";
    public static final String HTTP_NTLM_AUTH_INTEGRATED_PREFIX = "http.ntlm.auth.enableIntegrated.";
    public static final PreferenceTag HTTP_NTLM_AUTH_INTEGRATED_WIN = new PreferenceTag("http.ntlm.auth.enableIntegrated.win32", "Authenticate using Windows for NTLM over HTTP", "Enable Windows integrated authentication for NTLM over HTTP (true or false). ", 2);
    public static final PreferenceTag PASSPORT_ADVANTAGE_ENABLED = new PreferenceTag("PassportAdvantageIsEnabled", Messages.Prefs_PassportAdvantage_IsEnabledLabel, Messages.Prefs_PassportAdvantage_IsEnabledDesc, 2);
    public static final PreferenceTag PASSPORT_ADVANTAGE_SITE_ID = new PreferenceTag("PassportAdvantageSiteId", Messages.Prefs_PassportAdvantage_SiteIdLabel, Messages.Prefs_PassportAdvantage_SiteIdDesc);
    public static final PreferenceTag PREF_LOCATION = new PreferenceTag("REMOTE_PREF_LOCATION", Messages.PrefsPrefs_LocationLabel, Messages.PrefsPrefs_LocationDesc);
    public static final PreferenceTag PREF_LICENSE_POLICY_LOCATION = new PreferenceTag("com.ibm.cic.license.policy.location", Messages.PrefsPrefs_LicensePolicyLocationLabel, Messages.PrefsPrefs_LicensePolicyLocationDesc);
    public static final PreferenceTag PREF_LICENSE_AUTO_PEK = new PreferenceTag("com.ibm.cic.license.auto.pek", Messages.PrefsPrefs_LicenseAutoPekLabel, Messages.PrefsPrefs_LicenseAutoPekDesc);
    public static final PreferenceTag SEARCH_FOR_UPDATES = new PreferenceTag("com.ibm.cic.common.core.preferences.searchForUpdates", Messages.UpdatesPreference_searchForUpdates, Messages.UpdatesPreference_searchForUpdates, 2);
    public static final PreferenceTag IMPORT_ENABLED = new PreferenceTag("com.ibm.cic.common.core.preferences.import.enabled", Messages.Prefs_Import_IsEnabledLabel, Messages.Prefs_Import__IsEnabledDesc, 2);
    public static final PreferenceTag DISPLAY_INTERNAL_VERSION = new PreferenceTag("com.ibm.cic.agent.ui.displayInternalVersion", Messages.DisplayInternalVersion, Messages.DisplayInternalVersion, 2);
    public static final PreferenceTag ShowErrorLog = new PreferenceTag("com.ibm.cic.common.sharedUI.showErrorLog", Messages.ViewLogFilter_Error, Messages.ViewLogFilter_Error, 2);
    public static final PreferenceTag ShowWarningLog = new PreferenceTag("com.ibm.cic.common.sharedUI.showWarningLog", Messages.ViewLogFilter_Warning, Messages.ViewLogFilter_Warning, 2);
    public static final PreferenceTag ShowNoteLog = new PreferenceTag("com.ibm.cic.common.sharedUI.showNoteLog", Messages.ViewLogFilter_Note, Messages.ViewLogFilter_Note, 2);
    public static final PreferenceTag ShowInformationLog = new PreferenceTag("com.ibm.cic.common.sharedUI.showInformationLog", Messages.ViewLogFilter_Information, Messages.ViewLogFilter_Information, 2, null, false);
    public static final PreferenceTag WINDOW_SIZE = new PreferenceTag("com.ibm.cic.agent.ui.windowSize", Messages.Prefs_WindowSizeLabel, Messages.Prefs_WindowSizeDesc, 1, null, false);
    private static final PreferenceTag[] REGISTERED_PREFERENCES = new PreferenceTag[]{REPOSITORY_LOCATIONS, DIRECT_ARTIFACT_ACCESS_MODE, LOG_LOCATION, DEFAULT_PROFILE, CONNECT_TIMEOUT, READ_TIMEOUT, DOWNLOAD_AUTO_RETRY_COUNT, USE_SERVICE_REPOSITORIES, SERVICE_REPOSITORY_MAP, SSL_NONSECURE_MODE, HTTP_DISABLE_PREEMPTIVE_AUTHENTICATION, HTTP_NTLM_AUTH_KIND, HTTP_NTLM_AUTH_INTEGRATED_WIN, PREF_LOCATION, PRESERVE_DOWNLOADED_ARTIFACTS, PREF_LICENSE_POLICY_LOCATION, PREF_LICENSE_AUTO_PEK, KEEP_FETCHED_FILES, PASSPORT_ADVANTAGE_ENABLED, PASSPORT_ADVANTAGE_SITE_ID, SEARCH_FOR_UPDATES, IMPORT_ENABLED, DISPLAY_INTERNAL_VERSION, ShowErrorLog, ShowWarningLog, ShowNoteLog, ShowInformationLog, WINDOW_SIZE};
    public static final List<PreferenceTag> ALL_PREFERENCES;

    static {
        ArrayList<PreferenceTag> allPrefs = new ArrayList<PreferenceTag>();
        PreferenceTag[] preferenceTagArray = REGISTERED_PREFERENCES;
        int n = REGISTERED_PREFERENCES.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTag pref = preferenceTagArray[n2];
            allPrefs.add(pref);
            ++n2;
        }
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        for (ProxyPreferenceInternalUtil.ProxyTagsKey ptKey : pi.getValidProxyKeys()) {
            ProxyPreferenceInternalUtil.ProxyTags pt = pi.getProxyTags(ptKey);
            allPrefs.add(pt.getHostTag());
            allPrefs.add(pt.getPortTag());
            ProxyPreferenceInternalUtil.ProxySelectTags pst = pi.getProxySelectTags(ptKey.getTargetProtocol());
            allPrefs.add(pst.getEnabledTag());
            allPrefs.add(pst.getUseSocksTag());
        }
        ALL_PREFERENCES = Collections.unmodifiableList(allPrefs);
    }

    public static class ComposedPreferenceTag
    extends PreferenceTag {
        private final String[] m_keys;

        public ComposedPreferenceTag(PreferenceTag superTag, String superTagVal, PreferenceTag subTag) {
            super(null, subTag.label(), subTag.description(), subTag.type(), subTag.subPrefs(), true);
            this.m_keys = new String[]{superTag.key(), superTagVal, subTag.key()};
        }

        private String constructKey(String[] keys) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < keys.length) {
                sb.append(keys[i]);
                if (i < keys.length - 1) {
                    sb.append('.');
                }
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String key() {
            if (this.m_key == null) {
                this.m_key = this.constructKey(this.m_keys);
            }
            return super.key();
        }

        public PreferenceTag replaceKey(int index, String key) {
            if (index < this.m_keys.length && !key.equals(this.m_keys[index])) {
                this.m_keys[index] = key;
                this.m_key = null;
            }
            return this;
        }
    }

    public static class PreferenceTag {
        static final int PREF_TYPE_STRING = 1;
        static final int PREF_TYPE_BOOLEAN = 2;
        static final char KEY_SEPARATOR = '.';
        private static final PreferenceTag[] NO_SUB_PREFS = new PreferenceTag[0];
        protected String m_key;
        private final String m_label;
        private final String m_description;
        private final int m_type;
        private final boolean m_needRecord;
        private final PreferenceTag[] m_subPrefs;

        public PreferenceTag(String key, String label, String description, int type) {
            this(key, label, description, type, null, true);
        }

        public PreferenceTag(String key, String label, String description) {
            this(key, label, description, 1);
        }

        PreferenceTag(String key, String label, String description, int type, PreferenceTag[] subPrefs, boolean needRecord) {
            this.m_key = key;
            this.m_label = label;
            this.m_description = description;
            this.m_type = type;
            this.m_subPrefs = subPrefs != null ? subPrefs : NO_SUB_PREFS;
            this.m_needRecord = needRecord;
        }

        public String key() {
            return this.m_key;
        }

        public int type() {
            return this.m_type;
        }

        public String label() {
            return this.m_label;
        }

        public PreferenceTag[] subPrefs() {
            return this.m_subPrefs;
        }

        public String description() {
            return this.m_description;
        }

        public boolean isBoolean() {
            return (this.m_type & 2) != 0;
        }

        public boolean isNeedRecord() {
            return this.m_needRecord;
        }

        public String toString() {
            return this.key();
        }

        public boolean equals(Object obj) {
            return obj instanceof PreferenceTag && this.key().equals(((PreferenceTag)obj).key());
        }

        public int hashCode() {
            return this.key().hashCode();
        }
    }

    public static class ProxyPreferences {
        private static HashMap tags = new HashMap();
        private static final String BASE_KEY = "com.ibm.cic.common.core.preferences.";
        private static final String FORMAT_KEY = "com.ibm.cic.common.core.preferences.{0}.{2}.for.{1}";
        private static final String ENABLED = "proxyEnabled";
        private static final String HOST = "proxyHost";
        private static final String PORT = "proxyPort";
        private static final String USE_SOCKS = "proxyUseSocks";
        public static final String PROXY_PROTOCOL_SOCKS = "SOCKS";
        public static final String PROXY_PROTOCOL_HTTP11 = "HTTP11";

        private static String makeKey(String protocol, String setting) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(BASE_KEY);
            sb.append(protocol);
            sb.append('.');
            sb.append(setting);
            return sb.toString();
        }

        private static PreferenceTag getProxyTag(String protocol, String variable, String label, String descr) {
            String key = ProxyPreferences.makeKey(protocol, variable);
            PreferenceTag tag = (PreferenceTag)tags.get(key);
            if (tag == null) {
                tag = new PreferenceTag(key, label, descr);
                tags.put(key, tag);
            }
            return tag;
        }

        public static PreferenceTag getProxyEnabled(String protocol) {
            return ProxyPreferences.getProxyTag(protocol, ENABLED, Messages.ProxyPrefs_EnabledLabel, Messages.ProxyPrefs_EnabledDesc);
        }

        public static PreferenceTag getProxyHost(String protocol) {
            return ProxyPreferences.getProxyTag(protocol, HOST, Messages.ProxyPrefs_HostLabel, Messages.ProxyPrefs_HostDesc);
        }

        public static PreferenceTag getProxyPort(String protocol) {
            return ProxyPreferences.getProxyTag(protocol, PORT, Messages.ProxyPrefs_PortLabel, Messages.ProxyPrefs_PortDesc);
        }

        public static PreferenceTag getSocksProxyHost() {
            return ProxyPreferences.getProxyTag(ProxyProtocol.SOCKS.getKey(), HOST, Messages.ProxyPrefs_SocksHostLabel, Messages.ProxyPrefs_SocksHostDesc);
        }

        public static PreferenceTag getSocksProxyPort() {
            return ProxyPreferences.getProxyTag(ProxyProtocol.SOCKS.getKey(), PORT, Messages.ProxyPrefs_SocksPortLabel, Messages.ProxyPrefs_SocksPortDesc);
        }

        public static PreferenceTag getProxyUseSocks(String protocol) {
            return ProxyPreferences.getProxyTag(protocol, USE_SOCKS, Messages.ProxyPrefs_UseSocksLabel, Messages.ProxyPrefs_UseSocksDescr);
        }

        private static String makeKey(String proxyProtocol, String targetProtocol, String setting) {
            String key = NLS.bind(FORMAT_KEY, proxyProtocol, targetProtocol, setting);
            return key;
        }

        private static PreferenceTag getProxyTag(String proxyProtocol, String targetProtocol, String variable, String label, String descr) {
            String key = ProxyPreferences.makeKey(proxyProtocol, targetProtocol, variable);
            PreferenceTag tag = (PreferenceTag)tags.get(key);
            if (tag == null) {
                tag = new PreferenceTag(key, label, descr);
                tags.put(key, tag);
            }
            return tag;
        }

        public static PreferenceTag getHttp11ProxyHost(String targetProtocol) {
            String proxyProtocol = PROXY_PROTOCOL_HTTP11;
            return ProxyPreferences.getProxyTag(proxyProtocol, targetProtocol, HOST, Messages.ProxyPrefs_HostLabel, Messages.ProxyPrefs_HostDesc);
        }

        public static PreferenceTag getHttp11ProxyPort(String targetProtocol) {
            String proxyProtocol = PROXY_PROTOCOL_HTTP11;
            return ProxyPreferences.getProxyTag(proxyProtocol, targetProtocol, PORT, Messages.ProxyPrefs_PortLabel, Messages.ProxyPrefs_PortDesc);
        }

        public static PreferenceTag getSocksProxyHost(String targetProtocol) {
            String proxyProtocol = PROXY_PROTOCOL_SOCKS;
            return ProxyPreferences.getProxyTag(proxyProtocol, targetProtocol, HOST, Messages.ProxyPrefs_SocksHostLabel, Messages.ProxyPrefs_SocksHostDesc);
        }

        public static PreferenceTag getSocksProxyPort(String targetProtocol) {
            String proxyProtocol = PROXY_PROTOCOL_SOCKS;
            return ProxyPreferences.getProxyTag(proxyProtocol, targetProtocol, PORT, Messages.ProxyPrefs_SocksPortLabel, Messages.ProxyPrefs_SocksPortDesc);
        }
    }
}

