/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.PPSettings;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class CicCommonSettings {
    private static String m_applicationDataLocation;
    private static IPath m_applicationPreferencesLocation;
    private static Boolean m_isNativeAdministrator;
    private static IPath m_applicationCredentionalStoreLocation;
    private static boolean m_ignoreRepositoryDigest;
    public static final String USERHOME = "user.home";
    protected static final String COMPANY = "IBM";
    protected static final String DOT_COMPANY = ".ibm";
    protected static final String PRODUCT = "Installation Manager";
    public static final String GROUP_FOLDER = "Group";
    protected static final String PRODUCT_NO_SPACE = "InstallationManager";
    protected static final String SETTINGS = ".settings";
    public static final String APPLICATION_DATA_KEY = "cic.appDataLocation";
    public static final String BETA_PROPERTY_KEY = "cic.beta";
    public static final String OVERRIDE_DISK_SPACE_KEY = "cic.override.disk.space";
    private static boolean m_portable;
    private static AccessRights accessRightsMode;
    private static final String CREDENTIAL_STORE = ".cstore";
    private static final String osgi_os;
    private static final String m_os;
    private static final String osgi_ws;
    private static final String m_ws;
    private static final String osgi_arch;
    private static final String m_arch;
    private static final String osgi_nl;
    private static final String m_nl;
    private static final boolean m_isWindows;
    private static final boolean m_isLinux;
    private static final boolean m_isAix;
    private static final boolean m_isSolaris;
    private static final boolean m_isHpux;
    private static final boolean m_isMacOSX;
    private static final boolean m_isZOS;
    private static final boolean m_isOS400;
    private static final boolean m_isWindowsVista;
    private static final boolean m_isWindows7;
    private static final boolean m_isWindows8;
    private static final boolean m_isWindows10;
    private static final boolean m_isWindowsXP;
    private static final boolean m_isWindows2000;
    private static final boolean m_isWindows2000Professional;
    private static final boolean m_isWindows2000AdvancedServer;
    private static final boolean m_isWindows2003Server;
    private static final boolean m_isWindows2008Server;
    private static final boolean m_isWindows2008ServerR2;
    private static final boolean m_isWindows2012Server;
    private static final boolean m_isWindows2016Server;
    private static final boolean m_isUbuntu;
    private static boolean m_is64BitOs;

    static {
        m_ignoreRepositoryDigest = false;
        m_portable = false;
        osgi_os = System.getProperty("osgi.os");
        m_os = osgi_os != null && !osgi_os.equals("") ? osgi_os : Platform.getOS();
        osgi_ws = System.getProperty("osgi.ws");
        m_ws = osgi_ws != null && !osgi_ws.equals("") ? osgi_ws : Platform.getWS();
        osgi_arch = System.getProperty("osgi.arch");
        m_arch = osgi_arch != null && !osgi_arch.equals("") ? osgi_arch : Platform.getOSArch();
        osgi_nl = System.getProperty("osgi.nl");
        m_nl = osgi_nl != null && !osgi_nl.equals("") ? osgi_nl : Platform.getNL();
        m_isWindows = "win32".equals(m_os);
        m_isLinux = "linux".equals(m_os);
        m_isAix = "aix".equals(m_os);
        m_isSolaris = "solaris".equals(m_os);
        m_isHpux = "hpux".equals(m_os);
        m_isMacOSX = "macosx".equals(m_os);
        m_isZOS = "zos".equals(m_os);
        m_isOS400 = "os400".equals(m_os);
        m_isWindowsVista = m_isWindows && NativeUtils.isWindowsVista();
        m_isWindows7 = m_isWindows && NativeUtils.isWindows7();
        m_isWindows8 = m_isWindows && NativeUtils.isWindows8();
        m_isWindows10 = m_isWindows && NativeUtils.isWindows10();
        m_isWindowsXP = m_isWindows && NativeUtils.isWindowsXP();
        m_isWindows2000 = m_isWindows && NativeUtils.isWindows2000();
        m_isWindows2000Professional = m_isWindows && NativeUtils.isWindows2000Professional();
        m_isWindows2000AdvancedServer = m_isWindows && NativeUtils.isWindows2000AdvancedServer();
        m_isWindows2003Server = m_isWindows && NativeUtils.isWindows2003Server();
        m_isWindows2008Server = m_isWindows && NativeUtils.isWindows2008Server();
        m_isWindows2008ServerR2 = m_isWindows && NativeUtils.isWindows2008ServerR2();
        m_isWindows2012Server = m_isWindows && NativeUtils.isWindows2012Server();
        m_isWindows2016Server = m_isWindows && NativeUtils.isWindows2016Server();
        m_isUbuntu = m_isLinux && CicCommonSettings.checkForUbuntu();
        m_is64BitOs = PlatformUtils.is64bitOS();
    }

    public static String getApplicationDataLocation() {
        if (!(m_applicationDataLocation != null && m_applicationDataLocation.length() != 0 || (m_applicationDataLocation = System.getProperty(APPLICATION_DATA_KEY)) != null && m_applicationDataLocation.length() != 0)) {
            m_applicationDataLocation = CicCommonSettings.getDefaultApplicationDataLocation();
        }
        return m_applicationDataLocation;
    }

    public static String getDefaultApplicationDataLocation() {
        return PPSettings.getDefaultIMCacheLocation();
    }

    public static String getBetaProperty() {
        String betaProperty = System.getProperty(BETA_PROPERTY_KEY);
        if (betaProperty == null) {
            betaProperty = "";
        }
        return betaProperty.trim();
    }

    public static boolean isBeta() {
        String betaProperty = CicCommonSettings.getBetaProperty();
        return betaProperty != null && betaProperty.length() != 0;
    }

    public static boolean isBetaOverride() {
        String betaProperty = System.getProperty(BETA_PROPERTY_KEY);
        return betaProperty != null && betaProperty.length() == 0;
    }

    public static void setApplicationDataLocation(String a_newLocation) {
        m_applicationDataLocation = a_newLocation;
        m_applicationPreferencesLocation = null;
    }

    public static boolean isNativeAdministrator() {
        if (m_isNativeAdministrator == null) {
            m_isNativeAdministrator = NativeUtils.isNativeAdministrator();
        }
        return m_isNativeAdministrator;
    }

    public static String getGroupProperty() {
        return "_Group";
    }

    public static void setIsNativeAdministrator(boolean a_nativeAdmin) {
        m_isNativeAdministrator = a_nativeAdmin;
    }

    public static void setAccessRightsMode(String a_accessRightsMode) {
        if (a_accessRightsMode == null) {
            return;
        }
        CicCommonSettings.setAccessRightsMode(AccessRights.toMode(a_accessRightsMode));
    }

    public static void setAccessRightsMode(AccessRights a_accessRightsMode) {
        accessRightsMode = a_accessRightsMode;
    }

    public static AccessRights getAccessRightsMode() {
        if (accessRightsMode == null) {
            if (NativeUtils.isNativeAdministrator()) {
                CicCommonSettings.setAccessRightsMode(AccessRights.ADMIN_MODE);
            } else {
                CicCommonSettings.setAccessRightsMode(AccessRights.NON_ADMIN_MODE);
            }
        }
        return accessRightsMode;
    }

    public static boolean isWindows() {
        return m_isWindows;
    }

    public static boolean is64BitOs() {
        return m_is64BitOs;
    }

    @Deprecated
    public static void setIs64BitOs(boolean is64BitOs) {
        m_is64BitOs = is64BitOs;
    }

    public static boolean isWindowsXP() {
        return m_isWindowsXP;
    }

    public static boolean isWindows2000() {
        return m_isWindows2000;
    }

    public static boolean isWindows2000AdvancedServer() {
        return m_isWindows2000AdvancedServer;
    }

    public static boolean isWindows2000Professional() {
        return m_isWindows2000Professional;
    }

    public static boolean isWindows2003Server() {
        return m_isWindows2003Server;
    }

    public static boolean isWindows2008Server() {
        return m_isWindows2008Server;
    }

    public static boolean isWindows2008ServerR2() {
        return m_isWindows2008ServerR2;
    }

    public static boolean isWindows2012Server() {
        return m_isWindows2012Server;
    }

    public static boolean isWindows2016Server() {
        return m_isWindows2016Server;
    }

    public static boolean isWindowsVista() {
        return m_isWindowsVista;
    }

    public static boolean isWindows7() {
        return m_isWindows7;
    }

    public static boolean isWindows8() {
        return m_isWindows8;
    }

    public static boolean isWindows10() {
        return m_isWindows10;
    }

    public static boolean isWindowsVistaOrSimilar() {
        return CicCommonSettings.isWindowsVista() || CicCommonSettings.isWindows2008Server() || CicCommonSettings.isWindows2008ServerR2() || CicCommonSettings.isWindows2012Server() || CicCommonSettings.isWindows2016Server() || CicCommonSettings.isWindows7() || CicCommonSettings.isWindows8() || CicCommonSettings.isWindows10();
    }

    public static boolean isLinux() {
        return m_isLinux;
    }

    public static boolean isUbuntu() {
        return m_isUbuntu;
    }

    public static boolean isAix() {
        return m_isAix;
    }

    public static boolean isSolaris() {
        return m_isSolaris;
    }

    public static boolean isHpux() {
        return m_isHpux;
    }

    public static boolean isMacOSX() {
        return m_isMacOSX;
    }

    public static boolean isZOS() {
        return m_isZOS;
    }

    public static boolean isOS400() {
        return m_isOS400;
    }

    public static String getOs() {
        return m_os;
    }

    public static String getWs() {
        return m_ws;
    }

    public static String getArch() {
        return m_arch;
    }

    public static String getNl() {
        return m_nl;
    }

    public static IPath getApplicationPreferenceLocation() {
        if (m_applicationPreferencesLocation == null) {
            m_applicationPreferencesLocation = CicCommonSettings.getApplicationPreferenceLocation(CicCommonSettings.getApplicationDataLocation());
        }
        return m_applicationPreferencesLocation;
    }

    public static IPath getApplicationPreferenceLocation(String dataLocation) {
        return new Path(dataLocation).append(SETTINGS);
    }

    public static IPath getApplicationCredentialStoreLocation() {
        if (m_applicationCredentionalStoreLocation == null) {
            m_applicationCredentionalStoreLocation = new Path(CicCommonSettings.getApplicationDataLocation()).append(CREDENTIAL_STORE);
        }
        return m_applicationCredentionalStoreLocation;
    }

    public static boolean ignoreRepositoryDigest() {
        return m_ignoreRepositoryDigest;
    }

    public static void setIgnoreRepositoryDigest(boolean repositoryManifest) {
        m_ignoreRepositoryDigest = repositoryManifest;
    }

    public static IStatus validateApplicationDataLocation() {
        String appDataPath = FileUtil.getCanonicalPath(CicCommonSettings.getApplicationDataLocation());
        if (appDataPath.contains("#")) {
            return Statuses.ERROR.get(Messages.CicCommonSettings_invalidDataLocation, appDataPath);
        }
        return Status.OK_STATUS;
    }

    public static IStatus setInstanceArea() {
        File appDataLoc = new File(FileUtil.getCanonicalPath(CicCommonSettings.getApplicationDataLocation()));
        IStatus appDataValidationStatus = CicCommonSettings.validateApplicationDataLocation();
        if (!appDataValidationStatus.isOK()) {
            return appDataValidationStatus;
        }
        File pluginState = new File(appDataLoc, "pluginState");
        Location location = Platform.getInstanceLocation();
        if (location == null) {
            return new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, NLS.bind((String)Messages.CicCommonSettings_badInstanceArea, (Object)"osgi.instance.area", (Object)pluginState.getPath()), null);
        }
        if (location.getURL() != null) {
            return Status.OK_STATUS;
        }
        try {
            URL url = FileURLUtil.toUnescapedFileURL(pluginState);
            location.set(url, false);
        }
        catch (Exception e) {
            return new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private static boolean checkForUbuntu() {
        String output;
        StringWriter out;
        String[] cmdArray = new String[]{"cat", "/etc/lsb-release"};
        if (new File("/bin/cat").exists()) {
            cmdArray[0] = "/bin/cat";
        }
        return PlatformUtils.runProcess(cmdArray, null, null, out = new StringWriter(4096), out) == 0 && (output = out.toString()).indexOf("Ubuntu") > 0;
    }

    public static void setPortable(boolean portable) {
        m_portable = portable;
    }

    public static boolean isPortable() {
        return m_portable;
    }

    public static enum AccessRights {
        ADMIN_MODE("admin"),
        NON_ADMIN_MODE("nonAdmin"),
        GROUP_MODE("group");

        private final String mode;

        private AccessRights(String accessRightsMode) {
            this.mode = accessRightsMode;
        }

        public boolean isMode(String a_accessRightsMode) {
            return this.mode.equals(a_accessRightsMode);
        }

        public boolean isAdminMode() {
            return this == ADMIN_MODE;
        }

        public boolean isNonAdminMode() {
            return this == NON_ADMIN_MODE;
        }

        public boolean isGroupMode() {
            return this == GROUP_MODE;
        }

        public String toString() {
            return this.mode;
        }

        public static AccessRights toMode(String a_accessRightsMode) {
            AccessRights[] accessRightsArray = AccessRights.values();
            int n = accessRightsArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessRights ar = accessRightsArray[n2];
                if (ar.isMode(a_accessRightsMode)) {
                    return ar;
                }
                ++n2;
            }
            return null;
        }
    }
}

