/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.utils.SelectorExpander;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SelectorExpanderRememberDuplicates
extends SelectorExpander {
    private final Set<IContent> ignoredUnits = new LinkedHashSet<IContent>();
    private final List<IInstallableUnit> selectedIUs = new ArrayList<IInstallableUnit>();
    private final List<IInstallableUnit> duplicateIUs = new ArrayList<IInstallableUnit>(2);

    public SelectorExpanderRememberDuplicates(IShareableEntity se, Set<IContentSelector> selectors) {
        super(se, selectors);
    }

    @Override
    protected IShareableEntity findShareableEntity(IIncludedShareableEntity ise, IProgressMonitor progress) {
        return ise.getShareableEntity();
    }

    public final Collection<IInstallableUnit> getSelectedIUs() {
        return this.selectedIUs;
    }

    public final Set<IContent> getIgnoredUnits() {
        return this.ignoredUnits;
    }

    public final Collection<IInstallableUnit> getDuplicateIUs() {
        return this.duplicateIUs;
    }

    @Override
    protected boolean selectIf(boolean assertion, IInstallableUnit iu) {
        boolean selected = super.selectIf(assertion, iu);
        if (selected) {
            this.selectedIUs.add(iu);
        } else if (assertion) {
            IInstallableUnit selectedIU = this.getInstallableUnit(iu);
            this.duplicateIUs.add(selectedIU);
            this.duplicateIUs.add(iu);
            this.rememberOrDiscard(iu, true);
            return false;
        }
        this.rememberOrDiscard(iu, selected);
        return selected;
    }

    @Override
    protected boolean selectIf(boolean assertion, IShareableEntity se, Set<IContentSelector> selectors) {
        boolean selected = super.selectIf(assertion, se, selectors);
        this.rememberOrDiscard(se, selected);
        return selected;
    }

    private void rememberOrDiscard(IContent unit, boolean selected) {
        if (selected) {
            this.ignoredUnits.remove(unit);
        } else if (unit != null) {
            this.ignoredUnits.add(unit);
        }
    }
}

