/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.definitions.ProfileArch;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IOfferingProperties;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.model.utils.TwoTierMap;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.LStringList;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class OfferingProperty
extends OfferingOrFixProperty
implements IOfferingProperties {
    private static final String PROFILE_SHARE_70 = "com.ibm.rational.sdp70";
    public static final Set UNIVERSAL_SET = new AbstractSet(){

        @Override
        public String toString() {
            return "<universal set>";
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return Integer.MAX_VALUE;
        }
    };
    private static final String ROLLBACK_ALLOWED_NONE = "none";
    private static final String ROLLBACK_ALLOWED_ANY = "any";
    private static TwoTierMap defaultRollbackAllowedProperty = new TwoTierMap(4, 1){
        {
            this.put("updateTest3", "[1.0.1,1.0.1]", OfferingProperty.ROLLBACK_ALLOWED_NONE);
            this.put("com.ibm.rational.functional.tester", "[0.0,7.0.0.20070400)", OfferingProperty.ROLLBACK_ALLOWED_NONE);
            this.put("com.ibm.rational.performance.tester", "[0.0,7.0.0.20070400)", OfferingProperty.ROLLBACK_ALLOWED_NONE);
        }
    };

    public static String getComment(IOffering offering) {
        return offering.getProperties().getProperty("offering.custom.comment", "");
    }

    public static void setComment(IOffering offering, String comment) {
        offering.getProperties().setProperty("offering.custom.comment", comment);
    }

    public static Type getType(IOffering offering) {
        String type = offering.getProperties().getProperty("offering.type", "original");
        for (Type t : Type.types) {
            if (!type.equalsIgnoreCase(t.type)) continue;
            return t;
        }
        return Type.ORIGINAL;
    }

    public static void setType(IOffering offering, Type type) {
        offering.getProperties().setProperty("offering.type", type.getType());
    }

    public static VersionedId[] getLineage(IOffering offering) {
        String vidsString = offering.getProperties().getProperty("offering.custom.lineage");
        LStringList vidList = new LStringList(vidsString);
        VersionedId[] vids = new VersionedId[vidList.size()];
        int ix = 0;
        while (ix < vids.length) {
            vids[ix] = new VersionedId(vidList.getString(ix));
            ++ix;
        }
        return vids;
    }

    public static void setLineage(IOffering offering, VersionedId[] vids) {
        LStringList vidList = new LStringList();
        VersionedId[] versionedIdArray = vids;
        int n = vids.length;
        int n2 = 0;
        while (n2 < n) {
            VersionedId vid = versionedIdArray[n2];
            vidList.add(vid.serialize());
            ++n2;
        }
        offering.getProperties().setProperty("offering.custom.lineage", vidList.serialize());
    }

    public static boolean isModifiable(IOffering offering) {
        if (OfferingProperty.getType(offering) != Type.CUSTOM) {
            return false;
        }
        return OfferingProperty.getBooleanProperty(offering, "offering.custom.modifiable", false);
    }

    public static String getSingletonOffering(IOffering offering) {
        return offering.getProperties().getProperty("singletonOffering", CommonDef.False);
    }

    public static Set getProfileShareSet(IOffering offering) {
        String profileShare = offering.getProperties().getProperty("profileShare", "false");
        if (CommonDef.False.equals(profileShare)) {
            return Collections.EMPTY_SET;
        }
        if (CommonDef.True.equals(profileShare)) {
            return Collections.singleton(PROFILE_SHARE_70);
        }
        if ("*".equals(profileShare)) {
            return UNIVERSAL_SET;
        }
        return Util.toOrderedSet(profileShare, ',');
    }

    public static List getSupercedes(IOffering offering) {
        Set ids = Util.toOrderedSet(offering.getProperties().getProperty("supercedes", ""), ',');
        ArrayList<SimpleIdentity> result = new ArrayList<SimpleIdentity>(ids.size());
        for (String id : ids) {
            result.add(new SimpleIdentity(id));
        }
        return result;
    }

    public static boolean warnVistaVirtualizationDir(IOffering offering) {
        String avoidVistaVirtualizationDir = offering.getProperties().getProperty("warnVistaVirtualizationDirectories", "true");
        return Boolean.valueOf(avoidVistaVirtualizationDir);
    }

    public static boolean setModifiable(IOffering offering, boolean modifiable) {
        if (OfferingProperty.getType(offering) != Type.CUSTOM) {
            return false;
        }
        if (modifiable) {
            offering.getProperties().setProperty("offering.custom.modifiable", CommonDef.True);
        } else {
            offering.getProperties().remove("offering.custom.modifiable");
        }
        return true;
    }

    public static boolean requiresAdminUser(IOffering offering) {
        if (offering == null) {
            return false;
        }
        if (LicenseUtils.isPEKOffering(offering)) {
            return false;
        }
        return OfferingProperty.getCachedBooleanProperty(offering, "offering.RequiresAdmin", true);
    }

    public static boolean supportsGroupMode(IOfferingOrFix offeringOrFix) {
        return OfferingProperty.getCachedBooleanProperty(offeringOrFix, "offering.SupportsGroupMode", false);
    }

    public static String getSupportedOS(IOffering offering) {
        return OfferingProperty.getCachedProperty(offering, "supportedOS", "").trim();
    }

    public static boolean isExtension(IOfferingOrFix offeringOrFix) {
        if (!(offeringOrFix instanceof IOffering)) {
            return false;
        }
        if (LicenseUtils.isPEKOffering(offeringOrFix)) {
            return false;
        }
        String profileId = OfferingProperty.getDefaultProfile(offeringOrFix);
        return profileId == null || profileId.trim().length() == 0;
    }

    public static boolean isExtensionOfExtension(IOffering offering) {
        return OfferingProperty.isExtension(offering) && OfferingProperty.getCachedBooleanProperty(offering, "extension.of.extension", false);
    }

    public static String getDefaultProfile(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix == null) {
            return null;
        }
        String result = CicCommonSettings.getAccessRightsMode().isAdminMode() ? "" : (CicCommonSettings.getAccessRightsMode().isGroupMode() ? OfferingProperty.getCachedProperty(offeringOrFix, "default.group.profile", "") : OfferingProperty.getCachedProperty(offeringOrFix, "default.user.profile", ""));
        return result.length() > 0 ? result : OfferingProperty.getCachedProperty(offeringOrFix, "default.profile", null);
    }

    public static boolean isBetaCompatible(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix == null) {
            return false;
        }
        if ("com.ibm.cic.agent".equals(offeringOrFix.getIdentity().getId())) {
            return true;
        }
        return OfferingProperty.getCachedBooleanProperty(offeringOrFix, "beta.compatible", false);
    }

    public static boolean isBetaInstallationOnly(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix == null) {
            return false;
        }
        if ("com.ibm.cic.agent".equals(offeringOrFix.getIdentity().getId())) {
            return false;
        }
        return OfferingProperty.getCachedBooleanProperty(offeringOrFix, "beta.installation.only", false);
    }

    public static boolean hasUnacceptableRequirementForUserRights(IOffering offering) {
        return !CicCommonSettings.getAccessRightsMode().isAdminMode() && OfferingProperty.requiresAdminUser(offering);
    }

    public static boolean setRequiresAdminUser(IOffering offering, boolean requiresAdmin) {
        if (requiresAdmin) {
            offering.getProperties().remove("offering.RequiresAdmin");
        } else {
            offering.getProperties().setProperty("offering.RequiresAdmin", CommonDef.False);
        }
        return true;
    }

    public static boolean hasUnacceptableRequirementForGroupMode(IOfferingOrFix offeringOrFix) {
        if (UserOptions.CIC_SKIP_SUPPORTS_GROUP_MODE_CHECK.isSet()) {
            return false;
        }
        return CicCommonSettings.getAccessRightsMode().isGroupMode() && !OfferingProperty.supportsGroupMode(offeringOrFix);
    }

    public static void setSupportedOS(IOfferingOrFix offeringOrFix, String supportedOS) {
        if (offeringOrFix != null) {
            if (supportedOS == null || supportedOS.length() == 0) {
                offeringOrFix.getProperties().remove("supportedOS");
            } else {
                offeringOrFix.getProperties().setProperty("supportedOS", supportedOS);
            }
        }
    }

    public static Set getSupportedLocales(IOffering offering) {
        return OfferingUtil.getLocaleSet(offering.getProperties().getProperty("localeLanguages", LanguageCode.ENGLISH.getId()));
    }

    public static Set getRequiredLocales(IOffering offering) {
        String value = offering.getProperties().getProperty("requiredlocaleLanguages", null);
        return OfferingUtil.getLocaleSet(value == null ? LanguageCode.ENGLISH.getId() : value);
    }

    public static boolean isRollbackAllowed(IOffering offering, Version version) {
        String property = offering.getProperties().getProperty("rollback.allowed.version");
        if (property == null) {
            String id = offering.getIdentity().getId();
            for (String range : defaultRollbackAllowedProperty.keySet(id)) {
                try {
                    if (!new VersionRange(range).isIncluded(offering.getVersion())) continue;
                    property = (String)defaultRollbackAllowedProperty.get(id, range);
                    break;
                }
                catch (IllegalArgumentException e) {
                    Logger.getGlobalLogger().warning("In {0} predefined property {1}, bad range \"{2}\": {3}", id, "rollback.allowed.version", range, e.getMessage());
                }
            }
        }
        try {
            Version allowed;
            Version version2 = ROLLBACK_ALLOWED_ANY.equals(property) ? Version.emptyVersion : (allowed = ROLLBACK_ALLOWED_NONE.equals(property) ? new Version(Integer.MAX_VALUE, 0, 0) : Version.parseVersion((String)property));
            return version.compareTo(allowed) >= 0;
        }
        catch (IllegalArgumentException e) {
            Logger.getGlobalLogger().warning("In {0} property {1}, bad version \"{2}\": {3}", offering, "rollback.allowed.version", version, e.getMessage());
            return true;
        }
    }

    public static boolean isSupportedOS(IOffering offering) {
        String property = OfferingProperty.getSupportedOS(offering);
        if (property.length() == 0) {
            return true;
        }
        Set supportedOS = Util.toOrderedSet(property, ',');
        if (supportedOS.isEmpty()) {
            return true;
        }
        return supportedOS.contains(Platform.getOS());
    }

    public static String getSupportedPlatforms(IOfferingOrFix offeringOrFix) {
        String value = OfferingProperty.getCachedProperty(offeringOrFix, "supportedPlatforms", null);
        if (value == null && UserOptions.CIC_OFFERING_SUPPORTS_ALL_PLATFORMS.isSet() && OfferingProperty.getProperty(offeringOrFix, "supportedPlatforms", null) == null && OfferingProperty.getProperty(offeringOrFix, "supportedOS", null) == null && OfferingProperty.getProperty(offeringOrFix, "offering.supports32bits", null) == null && OfferingProperty.getProperty(offeringOrFix, "offering.supports64bits", null) == null) {
            return SupportedPlatforms.getInstance().getAllSupportedPlatformsAsFilter();
        }
        return value;
    }

    public static boolean isImportEnabled(IOfferingOrFix offeringOrFix) {
        return OfferingProperty.getCachedBooleanProperty(offeringOrFix, "import.enabled", false);
    }

    public static boolean validateImportProfile(IOfferingOrFix offeringOrFix) {
        return OfferingProperty.getCachedBooleanProperty(offeringOrFix, "import.profile.validation", true);
    }

    public static boolean configureLicenseWithIM(IOffering offering) {
        if (offering == null) {
            return false;
        }
        String useIMConfigureLicense = offering.getProperties().getProperty("manage.license.with.im", CommonDef.True);
        return !CommonDef.False.equalsIgnoreCase(useIMConfigureLicense);
    }

    public static String getPrecheckBundlesProperty(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("prereq.bundles.precheck", "");
    }

    public static String getPrereqBundlesProperty(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("prereq.bundles", "");
    }

    public static String getDependenciesBundlesProperty(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("dependencies.bundles", "");
    }

    public static String getPostSessionBundlesProperty(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("post.session.bundles", "");
    }

    public static boolean supportMultipleProfileInstall(IOffering offering) {
        return OfferingProperty.getBooleanProperty(offering, "support.multiple.profile.install", false);
    }

    public static List<String> getOfferingDisplayAfter(IOfferingOrFix oof) {
        return Util.splitStringAsList(OfferingProperty.getCachedProperty(oof, "offering.display.after", ""), ",");
    }

    public static boolean enableRegressingUpdateWarning(IOffering offering) {
        return OfferingProperty.getBooleanProperty(offering, "enableRegressingUpdateWarning", false);
    }

    public static boolean supportsConsoleMode(IOffering offering) {
        return UserOptions.CIC_SUPPORTS_CONSOLE_MODE.isSet() || OfferingProperty.getCachedBooleanProperty(offering, "supports.console.mode", false);
    }

    public static boolean isPlanVerifierEnabled(IOffering offering) {
        String planVerifierEnabledStr = System.getProperty("plan.verifier.enabled");
        if (planVerifierEnabledStr == null) {
            planVerifierEnabledStr = offering.getProperties().getProperty("plan.verifier.enabled", String.valueOf(false));
        }
        return !CommonDef.False.equals(planVerifierEnabledStr);
    }

    public static String getSupports64bits(IOffering offering) {
        return offering.getProperties().getProperty("offering.supports64bits");
    }

    public static String getSupports32bits(IOffering offering) {
        return offering.getProperties().getProperty("offering.supports32bits");
    }

    public static boolean defaultProfileIs32bit(IOffering offering) {
        return OfferingProperty.getBooleanProperty(offering, "default.profile.is32bit", false);
    }

    public static boolean supports64bitIm(IOffering offering) {
        return OfferingProperty.supports64bitIm(offering, Platform.getOS(), Platform.getOSArch());
    }

    public static boolean supports64bitIm(IOffering offering, String os, String arch) {
        String value = offering.getProperties().getProperty("offering.supports.64bit.im");
        return OfferingProperty.supports64bitIm(value, os, arch);
    }

    public static boolean supports64bitIm(String value, String os, String arch) {
        if (UserOptions.CIC_SUPPORTS_64_BIT_IM.isSet()) {
            return true;
        }
        if (value == null || CommonDef.False.equalsIgnoreCase(value)) {
            return false;
        }
        if (CommonDef.True.equalsIgnoreCase(value)) {
            value = "(& (os=linux) (arch=x86_64))";
        }
        PlatformFilter f = new PlatformFilter(value);
        String arch64 = ProfileArch.get64bitArch(arch);
        return f.matchesPlatform(os, arch64).isOK();
    }

    public static boolean isExistingLocationAllowed(IOffering offering) {
        return OfferingProperty.getBooleanProperty(offering, "offering.AllowsExistingLocation", false);
    }

    public static String getSupportedWindowSystems(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("supportedWindowSystems");
    }

    public static boolean isDelayFeatureValidation(IOffering offering) {
        return OfferingProperty.getBooleanProperty(offering, "delay.feature.validation", false);
    }

    public static boolean showHasBeenInstalledDialog(IOffering offering) {
        return OfferingProperty.getCachedBooleanProperty(offering, "offering.showDialog.installed", true);
    }

    public static boolean isModifyForceEnabled(IOffering offering) {
        return OfferingProperty.getBooleanProperty(offering, "modify.force.enabled", false);
    }

    public static String getRequiresExtensions(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("offering.RequiresExtension");
    }

    public static String getRequiresExtensionNames(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("offering.RequiresExtension.name");
    }

    public static String getOptionalExtensions(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("offering.OptionalExtension");
    }

    public static String getProvidesExtensionCapability(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("offering.ProvidesExtensionCapability");
    }

    public static String getCapabilityPlatformExclusions(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("offering.RequiresExtension.excludesPlatforms");
    }

    public static String extractCapabilityId(String capabilityProp) {
        if (capabilityProp == null) {
            return capabilityProp;
        }
        int bracketIndex = capabilityProp.indexOf(91);
        int parenIndex = capabilityProp.indexOf(40);
        if (bracketIndex >= 0) {
            return capabilityProp.substring(0, bracketIndex);
        }
        if (parenIndex >= 0) {
            return capabilityProp.substring(0, parenIndex);
        }
        return capabilityProp;
    }

    public static VersionRange extractCapabilityVersion(String capabilityProp) {
        if (capabilityProp == null) {
            return VersionRange.emptyRange;
        }
        int bracketIndex = capabilityProp.indexOf(91);
        int parenIndex = capabilityProp.indexOf(40);
        if (bracketIndex >= 0) {
            return new VersionRange(capabilityProp.substring(bracketIndex));
        }
        if (parenIndex >= 0) {
            return new VersionRange(capabilityProp.substring(parenIndex));
        }
        return VersionRange.emptyRange;
    }

    public static String getIsExtensionOf(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getProperties().getProperty("offering.isExtensionOf");
    }

    public static String getCapabilityName(IOfferingOrFix offeringOrFix, String capabilityId) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String capabilityNames = OfferingProperty.getRequiresExtensionNames(offeringOrFix);
        if (capabilityNames != null && !capabilityNames.isEmpty()) {
            String[] capabilityNamesSet;
            String[] stringArray = capabilityNamesSet = capabilityNames.split(";");
            int n = capabilityNamesSet.length;
            int n2 = 0;
            while (n2 < n) {
                String capabilityNameProp = stringArray[n2];
                String[] nameProps = capabilityNameProp.split(":");
                nameMap.put(nameProps[0], nameProps[1]);
                ++n2;
            }
        }
        return nameMap.containsKey(capabilityId) ? (String)nameMap.get(capabilityId) : capabilityId;
    }

    public static class Type {
        private static List types = new Vector();
        public static final int ORIGINAL_LITERAL = 0;
        public static final int LICENSE_LITERAL = 1;
        public static final int CUSTOM_LITERAL = 2;
        public static final Type ORIGINAL = new Type("original", 0, "Original Product");
        public static final Type LICENSE = new Type("pek", 1, "Product Enablement Kit");
        public static final Type CUSTOM = new Type("custom", 2, "Installation Package");
        private final String type;
        private final int literal;
        private final String displayName;

        private Type(String type, int literal, String displayName) {
            this.type = type;
            this.literal = literal;
            this.displayName = displayName;
            types.add(this);
        }

        public int getLiteral() {
            return this.literal;
        }

        public String getType() {
            return this.type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return "<offering type: " + this.type + '>';
        }
    }

    public static class VersionedId {
        public Version version;
        public IIdentity identity;

        public VersionedId(Version version, IIdentity identity) {
            this.version = version;
            this.identity = identity;
        }

        public VersionedId(String serialized) {
            LStringList list = new LStringList(serialized);
            this.identity = new SimpleIdentity((String)list.get(0));
            this.version = new Version((String)list.get(1));
        }

        public String serialize() {
            return this.toString();
        }

        public String toString() {
            LStringList list = new LStringList();
            list.add(this.identity.getId());
            list.add(this.version.toString());
            return list.serialize();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VersionedId)) {
                return false;
            }
            VersionedId other = (VersionedId)obj;
            return this.identity.equals(other.identity) && this.version.equals((Object)other.version);
        }

        public int hashCode() {
            return (String.valueOf(this.identity.getId()) + ' ' + this.version.toString()).hashCode();
        }

        public String getLabel() {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(this.identity.getId());
            sb.append(',');
            sb.append(this.version.toString());
            sb.append(']');
            return sb.toString();
        }
    }
}

