/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.internal.BuilderDataContainer;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.LinkedProperties;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;

public abstract class BaseUnit
extends BuilderDataContainer
implements IContent,
IAdaptable {
    private IIdentity id;
    private Version version;
    private Information information;
    private int lineNumber = -1;
    protected LinkedProperties properties;
    private IRepository m_containingRepository = null;
    private ICicLocation m_location = null;

    public BaseUnit(IIdentity id, Version version) {
        this.id = id;
        this.version = version;
    }

    @Override
    public String getName() {
        String name;
        if (this.information != null && (name = this.information.getName()) != null && name.length() != 0) {
            return name;
        }
        return this.id.getId();
    }

    @Override
    public Information getInformation() {
        return this.information;
    }

    @Override
    public void setInformation(Information information) {
        this.information = information;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public IIdentity getIdentity() {
        return this.id;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public List getChildren() {
        return null;
    }

    @Override
    public void setIdentity(IIdentity id) {
        this.id = id;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String toString() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46) + 1;
        return "<" + Character.toLowerCase(name.charAt(i)) + name.substring(i + 1) + " id='" + this.getIdentity() + "' version='" + this.getVersion() + "'>";
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void setRepository(IRepository a_containingRepository) {
        this.m_containingRepository = a_containingRepository;
    }

    @Override
    public IRepository getRepository() {
        return this.m_containingRepository;
    }

    @Override
    public ICicLocation getLocation() {
        return this.m_location;
    }

    @Override
    public void setLocation(ICicLocation a_location) {
        this.m_location = a_location;
    }

    @Override
    public LinkedProperties getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedProperties();
        }
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.getProperties().getPropertyKeys();
    }

    @Override
    public int compareVersion(IContent other) {
        if (other == null) {
            return 1;
        }
        if (!this.getIdentity().equals(other.getIdentity())) {
            throw new IllegalArgumentException("Mismatched ids: " + this.getIdentity() + ' ' + other.getIdentity());
        }
        return this.getVersion().compareTo(other.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseUnit)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BaseUnit that = (BaseUnit)obj;
        return this.getIdentity().equals(that.getIdentity()) && this.getVersion().equals((Object)that.getVersion());
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.version.hashCode();
    }
}

