/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

public class RefCount {
    private final Object obj;
    private int refCount;

    public RefCount(Object obj) {
        assert (obj != null);
        this.obj = obj;
        this.refCount = 1;
    }

    public Object getObject() {
        return this.obj;
    }

    public boolean equals(Object o) {
        if (o instanceof RefCount) {
            RefCount rc = (RefCount)o;
            return rc.obj.equals(this.obj);
        }
        return false;
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public void incrRefCount() {
        ++this.refCount;
    }

    public void decrRefCount() {
        --this.refCount;
    }

    public boolean isZeroRefCount() {
        return this.refCount == 0;
    }

    public boolean isShared() {
        return this.refCount > 1;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("obj.hashCode()=");
        sb.append(this.obj.hashCode());
        sb.append(" refCount=");
        sb.append(this.refCount);
        sb.append(" ");
        sb.append(this.obj);
        return sb.toString();
    }
}

