/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.FileURLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CicConstants {
    public static final String SPACE = " ";
    public static final String EMPTY_STR = "";
    public static final String[] EMPTY_STR_ARRAY = new String[0];
    public static final ICicLocation EMPTY_LOCATION = new CicFileLocation("");
    public static final List EMPTY_LIST = new ArrayList();
    public static final String COLON = ":";
    public static final char SEMICOLON_CHAR = ';';
    public static final String SEMICOLON_STR = ";";
    public static final String NEW_LINE = "\n";
    public static final String NEW_LINE2 = "\n\n";
    public static final String FWD_SLASH = "/";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DEFAULT_IU_EXT = "iu";
    public static final String DEFAULT_SU_EXT = "su";
    public static final String DEFAULT_SU_FRAGMENT_EXT = "suFragment";
    public static final String DEFAULT_ASSEMBLY_EXT = "assembly";
    public static final String DEFAULT_OFFERING_EXT = "offering";
    public static final String DEFAULT_FIX_EXT = "fix";
    public static final Set<String> DEFAULT_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("iu", "su", "suFragment", "assembly", "offering", "fix")));
    private static final String JAR_FILE_DOT_EXT = ".jar";
    private static final String JAR_FILE_EXT = "jar";
    private static final String ZIP_FILE_DOT_EXT = ".zip";
    private static final String ZIP_FILE_EXT = "zip";
    public static final String NATIVE_UTILS_FILE_LOCATION_SYSTEM_PROPERTY = "NATIVE_UTILS_FILE_LOCATION";
    public static final String RUN_AS_ADMIN_PATH = "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers";
    public static final String NESTED_IM_FOLDER = ".ibmim";
    public static final String NESTED_SHARED_FOLDER = ".ibmim/shared";
    public static final String NESTED_DATA_FOLDER = ".ibmim/data";
    public static final String DISABLE_PORTABLE_FILTER = "DisablePortableFilter";
    public static final String ECLIPSE_IDE_LOCATION = "eclipseIdeLocation";
    public static final String ECLIPSE_JRE_LOCATION = "eclipseJreLocation";
    public static final String ECLIPSE_LAUNCHER = "eclipseLauncher";
    public static final String BUNDLE_LOCATION = "bundleLocation";

    public static boolean fileMatchesDEFAULT_EXTENSIONS(String fileName) {
        return DEFAULT_EXTENSIONS.contains(fileName.substring(fileName.lastIndexOf(46) + 1));
    }

    public static String getFileExt(Class elementClass) {
        if (IOffering.class.isAssignableFrom(elementClass)) {
            return DEFAULT_OFFERING_EXT;
        }
        if (IShareableUnit.class.isAssignableFrom(elementClass)) {
            return DEFAULT_SU_EXT;
        }
        if (ISuFragment.class.isAssignableFrom(elementClass)) {
            return DEFAULT_SU_FRAGMENT_EXT;
        }
        if (IAssembly.class.isAssignableFrom(elementClass)) {
            return DEFAULT_ASSEMBLY_EXT;
        }
        if (IFix.class.isAssignableFrom(elementClass)) {
            return DEFAULT_FIX_EXT;
        }
        if (IInstallableUnit.class.isAssignableFrom(elementClass)) {
            return DEFAULT_IU_EXT;
        }
        return null;
    }

    public static final String getZipFileExt() {
        return ZIP_FILE_EXT;
    }

    public static final String getZipFileDotExt() {
        return ZIP_FILE_DOT_EXT;
    }

    public static final String getJarFileExt() {
        return JAR_FILE_EXT;
    }

    public static final String getJarFileDotExt() {
        return JAR_FILE_DOT_EXT;
    }

    public static boolean isArchiveName(String a_fileName) {
        return a_fileName.endsWith(JAR_FILE_DOT_EXT) || a_fileName.endsWith(ZIP_FILE_DOT_EXT);
    }

    public static boolean hasArchiveInPath(ICicLocation a_loc) {
        File locFile = a_loc.toFile();
        do {
            if (!CicConstants.isArchiveName(locFile.getName()) || !FileURLUtil.isURLString(a_loc.toString(), true) && !locFile.isFile()) continue;
            return true;
        } while ((locFile = locFile.getParentFile()) != null);
        return false;
    }
}

