/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.internal.repository.UpdateWalker;
import com.ibm.cic.common.core.model.FeatureKind;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.internal.Feature;
import com.ibm.cic.common.core.model.internal.FeatureGroup;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.Version;

public class UpdateOffering
extends UpdateWalker {
    @Override
    public void updateOffering(IOffering offering1, IOffering offering2) throws Exception {
        IIdentity asmId1 = offering1.getAssemblyId();
        IIdentity asmId2 = offering2.getAssemblyId();
        if (asmId1 == null && asmId2 != null) {
            offering1.setAssemblyId(new SimpleIdentity(asmId2.toString()));
        } else if (asmId1 != null && asmId2 == null) {
            offering1.setAssemblyId(null);
        } else if (asmId1 != null && asmId2 != null && !asmId1.equals(asmId2)) {
            offering1.setAssemblyId(new SimpleIdentity(asmId2.toString()));
        }
        Version asmVersion1 = offering1.getAssemblyVersion();
        Version asmVersion2 = offering2.getAssemblyVersion();
        if (asmVersion1 == null && asmVersion2 != null) {
            offering1.setAssemblyVersion(new Version(asmVersion2.toString()));
        } else if (asmVersion1 != null && asmVersion2 == null) {
            offering1.setAssemblyVersion(null);
        } else if (asmVersion1 != null && asmVersion2 != null && !asmVersion1.equals((Object)asmVersion2)) {
            offering1.setAssemblyVersion(new Version(asmVersion2.toString()));
        }
        IAssembly asm1 = offering1.getAssembly();
        IAssembly asm2 = offering2.getAssembly();
        if (asm1 == null && asm2 != null) {
            offering1.setAssembly(asm2);
        } else if (asm1 != null && asm2 == null) {
            offering1.setAssembly(null);
        } else if (asm1 != null && asm2 != null && !asm1.equals(asm2)) {
            offering1.setAssembly(asm2);
        }
        IFeatureGroup group1 = offering1.getFeatureGroup();
        IFeatureGroup group2 = offering2.getFeatureGroup();
        if (group1 == null && group2 != null) {
            offering1.setFeatureGroup(group2);
        } else if (group1 != null && group2 == null) {
            offering1.setFeatureGroup(null);
        } else if (group1 != null && group2 != null && !group1.equals(group2)) {
            this.updateFeatureGroup(group1, group2);
        }
    }

    private void updateFeatureGroup(IFeatureGroup group1, IFeatureGroup group2) {
        Information info1 = group1.getInformation();
        Information info2 = group2.getInformation();
        if (info1 == null && info2 != null) {
            group1.setInformation(info2);
        } else if (info1 != null && info2 == null) {
            group1.setInformation(null);
        } else if (info1 != null && info2 != null && !info1.equals(info2)) {
            group1.setInformation(info2);
        }
        FeatureKind kind1 = group1.getKind();
        FeatureKind kind2 = group2.getKind();
        if (kind1 == null && kind2 != null) {
            group1.setKind(kind2);
        } else if (kind1 != null && kind2 == null) {
            group1.setKind(null);
        } else if (kind1 != null && kind2 != null && !kind1.equals(kind2)) {
            group1.setKind(kind2);
        }
        List features1 = group1.getFeatures();
        List features2 = group2.getFeatures();
        Iterator it = features1.iterator();
        while (it.hasNext()) {
            Feature feature1 = (Feature)it.next();
            if (features2.contains(feature1)) continue;
            it.remove();
        }
        for (Feature feature2 : features2) {
            if (features1.contains(feature2)) continue;
            group1.addFeature(feature2);
        }
        List featureGroups1 = group1.getGroups();
        List featureGroups2 = group2.getGroups();
        Iterator it2 = featureGroups1.iterator();
        while (it2.hasNext()) {
            FeatureGroup featureGroup1 = (FeatureGroup)it2.next();
            if (featureGroups2.contains(featureGroup1)) continue;
            it2.remove();
        }
        for (FeatureGroup featureGroup2 : featureGroups2) {
            if (featureGroups1.contains(featureGroup2)) continue;
            group1.addGroup(featureGroup2);
        }
    }
}

