/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.downloads.IDownloadListener;

public class ReceiverFactory
implements IDownloadListener.IReceiverFactory {
    @Override
    public IDownloadListener.IReceiver createBasicReceiver(String urlString) {
        return new BasicReceiver(urlString);
    }

    @Override
    public IDownloadListener.IHostReceiver createHostReceiver(String urlString, String protocol, String host, int port) {
        return new HostReceiver(urlString, protocol, host, port);
    }

    static class BasicReceiver
    implements IDownloadListener.IReceiver {
        private final String urlString;

        private BasicReceiver(String urlString) {
            this.urlString = urlString;
        }

        @Override
        public String getURLString() {
            return this.urlString;
        }

        public String toString() {
            return this.urlString;
        }
    }

    static class HostReceiver
    implements IDownloadListener.IHostReceiver {
        private final String urlString;
        private final String protocol;
        private final String host;
        private final int port;

        private HostReceiver(String urlString, String protocol, String host, int port) {
            this.urlString = urlString;
            this.protocol = protocol;
            this.host = host;
            this.port = port;
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        @Override
        public String getURLString() {
            return this.urlString;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.urlString.length() * 2 + 40);
            sb.append(this.urlString);
            sb.append(" [");
            sb.append(this.protocol);
            sb.append("://");
            sb.append(this.host);
            sb.append(":");
            sb.append(this.port);
            sb.append("]");
            return sb.toString();
        }
    }
}

