/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.IDownloadIncomplete;
import com.ibm.cic.common.downloads.IDownloadedFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DownloadedIncompleteUsingDip
implements IDownloadIncomplete {
    private final DownloadInProgressManager.IDownloadInProgress dip;
    private final List failedDownloads;

    public DownloadedIncompleteUsingDip(DownloadInProgressManager.IDownloadInProgress dip, List failedDownloads) {
        this.dip = dip;
        this.failedDownloads = failedDownloads;
    }

    @Override
    public long getFailedDownloadBytes() {
        long total = 0L;
        for (IDownloadedFile dlFile : this.failedDownloads) {
            long size = dlFile.getDownloadContentInfo().getSizeInfo().getDownloadSize();
            if (size == Long.MIN_VALUE) continue;
            total += size;
        }
        return total;
    }

    @Override
    public Collection getFailedDownloads() {
        return Collections.unmodifiableCollection(this.failedDownloads);
    }

    @Override
    public long getFragmentBytes() {
        File file = this.dip.getInProgressLocation().toFile();
        return file.length();
    }

    @Override
    public void releaseFailedDownloads() {
        for (IDownloadedFile dlFile : this.failedDownloads) {
            File file = dlFile.getFile();
            if (file == null) continue;
            FileUtil.delete(file);
        }
    }

    @Override
    public void releaseFragments() {
        DownloadInProgressManager.INSTANCE.release(this.dip);
    }

    @Override
    public long getTotalBytes() {
        return this.getFragmentBytes() + this.getFailedDownloadBytes();
    }

    @Override
    public void releaseAll() {
        this.releaseFragments();
        this.releaseFailedDownloads();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dip);
        for (IDownloadedFile dlFile : this.failedDownloads) {
            File file = dlFile.getFile();
            sb.append(" failed=");
            sb.append(file);
            sb.append('\n');
        }
        return sb.toString();
    }
}

