/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.downloads;

import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.StreamContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.downloads.DownloadContextThreadLocalInheritedAndGlobal;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.repository.URLContentLocator;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.DownloadProperties;
import com.ibm.cic.common.downloads.ICanOpenStream;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadIncomplete;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.IRestorePrevious;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.TransferManager;
import com.ibm.cic.common.downloads.TransferMonitor;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class TransferUtils {
    private static IStatus createErrorStatusGetStreamForURL(URL url, Exception e) {
        ICicStatus status = Statuses.ERROR.get(5000, e, Messages.TransferUtils_failed_to_get_stream, url.toString());
        return status;
    }

    public static IStatus download(IDownloadSession session, ICicLocation source, File destination, IContentInfo expectedContentInfo, IProgressMonitor monitor) {
        assert (source != null);
        assert (destination != null);
        URL url = source.toURL();
        assert (url != null);
        if (session == null) {
            try (IDownloadSession singleCallSession = IDownloadSession.FACTORY.createDownloadSession();){
                IStatus iStatus = TransferUtils.download(singleCallSession, source, destination, expectedContentInfo, monitor);
                return iStatus;
            }
        }
        URLContentLocator urlLocator = new URLContentLocator(url, expectedContentInfo);
        IDownloadedFile dlf = urlLocator.downloadToFile(session, (IPath)new Path(destination.toString()), monitor);
        return dlf.getStatus();
    }

    public static boolean exists(ICicLocation source, IProgressMonitor monitor) {
        IStatus status = TransferUtils.existsStatus(source, monitor);
        return status.isOK();
    }

    public static IStatus existsStatus(ICicLocation source, IProgressMonitor monitor) {
        assert (source != null);
        URL url = source.toURL();
        assert (url != null);
        URLContentLocator urlLocator = new URLContentLocator(url, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO);
        IStatus status = urlLocator.validateExists(4, monitor);
        return status;
    }

    public static ContentInfoComputation.IValidatingInputStream validateInputStreamContentInfo(File file, InputStream in, IContentInfo contentInfo) {
        if (contentInfo.getAvailableDigestsCount() > 0 || contentInfo.getSizeInfo().getDownloadSize() != Long.MIN_VALUE) {
            SimpleContentInfo sci = new SimpleContentInfo();
            List algorithms = ContentInfoComputation.getPreferredAlgorithmAsList();
            ContentInfoComputation.ComputeContentInfoInputStream cin = new ContentInfoComputation.ComputeContentInfoInputStream(algorithms, sci, in);
            return new ContentInfoComputation.ContentInfoValidatingInputStream(file, cin, contentInfo);
        }
        return new ContentInfoComputation.NOOPValidatingInputStream(file, file.length(), in);
    }

    public static InputStream getValidatedStream(IDownloadSession session, URL url, IProgressMonitor monitor) throws CoreException, FileNotFoundException, IOException {
        ContentInfo expectedContentInfo = ContentInfo.EMPTY_CONTENT_INFO;
        return TransferUtils.getValidatedStream(session, url, expectedContentInfo, monitor);
    }

    public static InputStream getValidatedStream(URL url, IProgressMonitor monitor) throws CoreException, FileNotFoundException, IOException {
        IDownloadSession session = IDownloadSession.NO_SESSION;
        ContentInfo expectedContentInfo = ContentInfo.EMPTY_CONTENT_INFO;
        return TransferUtils.getValidatedStream(session, url, expectedContentInfo, monitor);
    }

    public static InputStream getValidatedStream(IDownloadSession session, URL url, IContentInfo expectedContentInfo, IProgressMonitor monitor) throws CoreException, FileNotFoundException, IOException {
        URLContentLocator urlLocator = expectedContentInfo != null && expectedContentInfo.getAvailableDigestsCount() > 0 ? new URLContentLocator(url, expectedContentInfo) : new URLContentLocator(url, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO);
        String simpleName = PathUtil.getSimpleName(url.getPath());
        return TransferUtils.getValidatedStream(session, monitor, urlLocator, simpleName);
    }

    public static InputStream getValidatedStream(IDownloadSession session, String userName, InputStream is, IContentInfo expectedContentInfo, IProgressMonitor monitor) throws CoreException, IOException {
        StreamContentLocator locator = expectedContentInfo != null && expectedContentInfo.getAvailableDigestsCount() > 0 ? new StreamContentLocator(userName, is, expectedContentInfo) : new StreamContentLocator(userName, is, ContentInfo.EMPTY_CONTENT_INFO);
        String simpleName = PathUtil.getSimpleName(userName);
        return TransferUtils.getValidatedStream(session, monitor, locator, simpleName);
    }

    public static InputStream getValidatedStream(IDownloadSession session, IProgressMonitor monitor, IContentLocator locator, String simpleName) throws IOException, CoreException, FileNotFoundException {
        if (session == null) {
            try (IDownloadSession singleCallSession = IDownloadSession.FACTORY.createDownloadSession();){
                InputStream inputStream = TransferUtils.getValidatedStream(singleCallSession, monitor, locator, simpleName);
                return inputStream;
            }
        }
        File tempFile = TempUtil.createTempFile("cicvs", simpleName);
        boolean tempFileNeedsCleanup = true;
        try {
            IDownloadedFile dlf = locator.downloadToFile(session, (IPath)new Path(tempFile.getAbsolutePath()), monitor);
            if (StatusCodes.isContentNotFound(dlf.getStatus())) {
                throw new FileNotFoundException(locator.getUserNames().getSystemName());
            }
            if (dlf.getStatus().matches(12)) {
                IDownloadIncomplete dlIncomplete = dlf.getIncompleteDownload();
                if (dlIncomplete != null) {
                    dlIncomplete.releaseAll();
                }
                throw new CoreException((IStatus)dlf.getStatus());
            }
            DeleteTempFileOnCloseInputStream in = new DeleteTempFileOnCloseInputStream(tempFile, new FileInputStream(tempFile));
            tempFileNeedsCleanup = false;
            DeleteTempFileOnCloseInputStream deleteTempFileOnCloseInputStream = in;
            return deleteTempFileOnCloseInputStream;
        }
        finally {
            if (tempFileNeedsCleanup) {
                tempFile.delete();
            }
        }
    }

    public static InputStream getValidatedStreamForURLDirectForFiles(URL url, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (FileURLUtil.isFile(url)) {
            IDownloadContext ctxt = null;
            IContentInfo[] refContentInfo = new IContentInfo[1];
            return TransferUtils.downloadHandlerOpenStream(ctxt, url, (IProgressMonitor)sm, refContentInfo);
        }
        IDownloadSession session = IDownloadSession.FACTORY.createDownloadSession();
        SetNoProgressReporting restoreFormatter = new SetNoProgressReporting(session);
        try {
            InputStream inputStream = TransferUtils.getValidatedStream(session, url, ContentInfo.EMPTY_CONTENT_INFO, (IProgressMonitor)sm.newChild(1));
            return inputStream;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            IStatus status = TransferUtils.createErrorStatusGetStreamForURL(url, e);
            throw new CoreException(status);
        }
        finally {
            restoreFormatter.restore();
            session.close();
        }
    }

    public static InputStream getStreamForURL(URL url, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        IContentInfo[] refContentInfo = new IContentInfo[1];
        return TransferUtils.getStreamForURL(url, monitor, refContentInfo);
    }

    public static InputStream getStreamForURL(URL url, IProgressMonitor monitor, IContentInfo[] refContentInfo) throws FileNotFoundException, CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IDownloadContext ctxt = null;
        try {
            return TransferUtils.downloadHandlerOpenStream(ctxt, url, (IProgressMonitor)sm, refContentInfo);
        }
        catch (UnsupportedOperationException e) {
            File tempFile = null;
            try {
                tempFile = TransferUtils.makeTempFile(url);
            }
            catch (IOException e2) {
                IStatus status = TransferUtils.createErrorStatusGetStreamForURL(url, e);
                throw new CoreException(status);
            }
            boolean tempFileNeedsCleanup = true;
            DownloadContextThreadLocalInheritedAndGlobal.CancelMonitorRestorePrevious cmrp = DownloadContextThreadLocalInheritedAndGlobal.setupDownloadHandlerCancel(monitor);
            TransferMonitor transferMonitor = new TransferMonitor(cmrp.getCancelMonitor());
            try {
                TransferUtils.privateDownloadHandlerDownload(ctxt, url, tempFile, transferMonitor);
                DeleteTempFileOnCloseInputStream in = new DeleteTempFileOnCloseInputStream(tempFile, new FileInputStream(tempFile));
                tempFileNeedsCleanup = false;
                DeleteTempFileOnCloseInputStream deleteTempFileOnCloseInputStream = in;
                return deleteTempFileOnCloseInputStream;
            }
            finally {
                cmrp.restore();
                if (tempFileNeedsCleanup) {
                    tempFile.delete();
                }
            }
        }
    }

    private static InputStream downloadHandlerOpenStream(IDownloadContext ctxt, URL url, IProgressMonitor monitor, IContentInfo[] refContentInfo) throws CoreException, FileNotFoundException {
        DownloadContextThreadLocalInheritedAndGlobal.CancelMonitorRestorePrevious cmrp = DownloadContextThreadLocalInheritedAndGlobal.setupDownloadHandlerCancel(monitor);
        TransferMonitor transferMonitor = new TransferMonitor(cmrp.getCancelMonitor());
        try {
            InputStream in = TransferUtils.privateDownloadHandlerOpenStream(ctxt, url, transferMonitor, refContentInfo);
            monitor.worked(1);
            InputStream inputStream = in;
            return inputStream;
        }
        finally {
            cmrp.restore();
        }
    }

    private static InputStream privateDownloadHandlerOpenStream(IDownloadContext ctxt, URL url, ITransferMonitor transferPerformance, IContentInfo[] refContentInfo) throws CoreException, FileNotFoundException {
        if (url == null) {
            throw new NullPointerException();
        }
        DownloadHandler handler = TransferManager.INSTANCE.getHandler(url.getProtocol());
        if (handler != null) {
            String urlString = url.toString();
            if (handler instanceof ICanOpenStream) {
                ICanOpenStream canOpenStream = (ICanOpenStream)((Object)handler);
                if (ctxt == null) {
                    ctxt = DownloadContextThreadLocalInheritedAndGlobal.CONTEXT;
                }
                try {
                    DownloadHandlerRequest.OpenStreamRequest request = DownloadHandlerRequest.FACTORY.createOpenStreamRequest(ctxt, urlString);
                    return canOpenStream.openStream(request, transferPerformance, refContentInfo);
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (DownloadCanceledException e) {
                    throw TransferUtils.convertDownloadCancelToCoreException(e);
                }
                catch (IOException e) {
                    IStatus status = TransferUtils.createErrorStatusGetStreamForURL(url, e);
                    throw new CoreException(status);
                }
            }
            throw new UnsupportedOperationException();
        }
        String msg = NLS.bind((String)Messages.TransferUtils_no_download_handler, (Object)url.toString());
        ICicStatus status = Statuses.ERROR.get(5001, msg, new Object[0]);
        throw new CoreException((IStatus)status);
    }

    public static File makeTempFile(URL url) throws IOException, CoreException {
        String simpleName = PathUtil.getSimpleName(url.getPath());
        File tempFile = TempUtil.createTempFile("cic", simpleName);
        return tempFile;
    }

    public static long downloadHandlerDownload(IDownloadContext ctxt, URL url, File file, ITransferMonitor transferMonitor) throws FileNotFoundException, CoreException {
        DownloadContextThreadLocalInheritedAndGlobal.CancelMonitorRestorePrevious restorePrevious = DownloadContextThreadLocalInheritedAndGlobal.setupDownloadHandlerCancel(transferMonitor);
        try {
            long l = TransferUtils.privateDownloadHandlerDownload(ctxt, url, file, transferMonitor);
            return l;
        }
        finally {
            if (restorePrevious != null) {
                restorePrevious.restore();
            }
        }
    }

    private static long privateDownloadHandlerDownload(IDownloadContext ctxt, URL url, File file, ITransferMonitor transferMonitor) throws FileNotFoundException, CoreException {
        if (url == null) {
            throw new NullPointerException();
        }
        DownloadHandler handler = TransferManager.INSTANCE.getHandler(url.getProtocol());
        if (handler != null) {
            if (ctxt == null) {
                ctxt = DownloadContextThreadLocalInheritedAndGlobal.CONTEXT;
            }
            long[] outBytesRead = new long[1];
            try {
                handler.download(ctxt, url.toString(), file.getAbsolutePath(), transferMonitor, outBytesRead);
                return outBytesRead[0];
            }
            catch (DownloadCanceledException e) {
                throw TransferUtils.convertDownloadCancelToCoreException(e);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                IStatus status = TransferUtils.createErrorStatusGetStreamForURL(url, e);
                throw new CoreException(status);
            }
        }
        String msg = NLS.bind((String)Messages.TransferUtils_no_download_handler, (Object)url.toString());
        ICicStatus status = Statuses.ERROR.get(5001, msg, new Object[0]);
        throw new CoreException((IStatus)status);
    }

    public static boolean existsURL(URL url, IProgressMonitor monitor) throws IOException, CoreException {
        if (url == null) {
            throw new NullPointerException();
        }
        DownloadHandler handler = TransferManager.INSTANCE.getHandlerNotNull(url.getProtocol());
        DownloadContextThreadLocalInheritedAndGlobal.CancelMonitorRestorePrevious restorePrevious = DownloadContextThreadLocalInheritedAndGlobal.setupDownloadHandlerCancel(monitor);
        try {
            boolean exists;
            boolean bl = exists = handler.exists(DownloadContextThreadLocalInheritedAndGlobal.CONTEXT, url.toExternalForm());
            return bl;
        }
        catch (DownloadCanceledException e) {
            throw TransferUtils.convertDownloadCancelToCoreException(e);
        }
        finally {
            if (restorePrevious != null) {
                restorePrevious.restore();
            }
        }
    }

    public static ICicStatus convertDownloadCancelToStatus(DownloadCanceledException e) {
        if (e.getReasonCode() == 101) {
            return Statuses.ERROR.get(200, Messages.TransferUtils_authenticationCanceled, e.getUrlString());
        }
        return Statuses.CANCEL.get(e, Status.CANCEL_STATUS.getMessage(), new Object[0]);
    }

    public static CoreException convertDownloadCancelToCoreException(DownloadCanceledException e) {
        return new CoreException((IStatus)TransferUtils.convertDownloadCancelToStatus(e));
    }

    public static boolean validURL(URL url, IProgressMonitor progressMonitor) {
        try {
            return TransferUtils.existsURL(url, progressMonitor);
        }
        catch (Exception e) {
            ExceptionUtil.debugLogToReview(e);
            return false;
        }
    }

    public static DownloadProperties queryProperties(URL url, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        DownloadHandler handler = TransferManager.INSTANCE.getHandlerNotNull(url.getProtocol());
        DownloadContextThreadLocalInheritedAndGlobal.CancelMonitorRestorePrevious restorePrevious = DownloadContextThreadLocalInheritedAndGlobal.setupDownloadHandlerCancel(monitor);
        try {
            DownloadProperties downloadProperties = handler.queryProperties(DownloadContextThreadLocalInheritedAndGlobal.CONTEXT, url.toExternalForm());
            return downloadProperties;
        }
        catch (DownloadCanceledException e) {
            throw TransferUtils.convertDownloadCancelToCoreException(e);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.TransferUtils_queryInfoFailedWithException, (Object)url);
            ICicStatus status = Statuses.ERROR.get(e, msg, new Object[0]);
            throw new CoreException((IStatus)status);
        }
        finally {
            if (restorePrevious != null) {
                restorePrevious.restore();
            }
        }
    }

    static class DeleteTempFileOnCloseInputStream
    extends FilterInputStream {
        private final File tempFile;

        protected DeleteTempFileOnCloseInputStream(File tempFile, InputStream in) {
            super(in);
            this.tempFile = tempFile;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.tempFile.delete();
            }
        }
    }

    public static interface IDownloadProgress {
        public void updateMessage(int var1, long var2, long var4, long var6, long var8, String var10);
    }

    public static class SetNoProgressReporting
    implements IRestorePrevious {
        private final IDownloadSession.IDownloadProgressMonitorFormatter previous;
        private final IDownloadSession session;

        public SetNoProgressReporting(IDownloadSession session) {
            this.session = session;
            this.previous = session.getProgressFormatter();
            session.setProgressFormatter(null);
        }

        @Override
        public void restore() {
            this.session.setProgressFormatter(this.previous);
        }
    }
}

