/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.definitions;

import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.icu.util.StringTokenizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProfileLanguageUtils {
    private static Set<LanguageCode> languageCodes = Collections.unmodifiableSet(LanguageCode.getProfileLanguagesSet(true));
    private static final String DEFAULT_LOCALE_LANGUAGE_CODE_SET_MARKER = "^";
    private static final String LOCALE_LANG_DELIMITER = ",";

    public static String[] getLocaleLanguageCodes() {
        Set<String> ids = LanguageCode.toIds(languageCodes);
        return ids.toArray(new String[ids.size()]);
    }

    public static Set<String> getLocaleLanguageCodeSet() {
        return LanguageCode.toIds(languageCodes);
    }

    public static Set<String> getDefaultLocaleLanguageCodeSet() {
        Set<String> localeSet = LanguageCode.toIds(LanguageCode.getProfileLanguagesSet(false));
        localeSet.add(DEFAULT_LOCALE_LANGUAGE_CODE_SET_MARKER);
        return localeSet;
    }

    public static boolean isDefaultLocaleLanguageCodeSet(Set set) {
        return set.contains(DEFAULT_LOCALE_LANGUAGE_CODE_SET_MARKER);
    }

    public static Map<String, String> getLocaleCodeLabelMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (LanguageCode code : languageCodes) {
            map.put(code.getId(), code.getLabel());
        }
        return map;
    }

    public static Map<String, Set<String>> getLabelLocaleCodeMap() {
        LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
        for (LanguageCode code : languageCodes) {
            String label = code.getLabel();
            LinkedHashSet<String> codeSet = (LinkedHashSet<String>)map.get(label);
            if (codeSet == null) {
                codeSet = new LinkedHashSet<String>();
                map.put(label, codeSet);
            }
            codeSet.add(code.getId());
        }
        return map;
    }

    public static String getLabelString(Set<String> codeSet, Map<String, String> map) {
        return ProfileLanguageUtils.getLabelStringWithID(codeSet, map, false);
    }

    public static String getLabelStringWithID(Set<String> codeSet, Map<String, String> map, boolean showID) {
        LinkedHashSet<String> langLabelSet = new LinkedHashSet<String>();
        for (String code : codeSet) {
            String label = map.get(code);
            if (label == null) {
                label = Messages.Environment_language_unknown;
            }
            if (showID) {
                label = String.valueOf(label) + " (" + code + ")";
            }
            langLabelSet.add(label);
        }
        StringBuffer langLabels = new StringBuffer();
        for (String label : langLabelSet) {
            langLabels.append(label);
            langLabels.append(", ");
        }
        String labels = langLabels.substring(0, langLabels.length() - 2);
        return labels;
    }

    public static String getLabelString(String langCodes) {
        return ProfileLanguageUtils.getLabelString(langCodes, true);
    }

    public static String getLabelString(String langCodes, boolean showID) {
        if (langCodes == null) {
            return "";
        }
        LinkedHashSet<String> codesSet = new LinkedHashSet<String>(Arrays.asList(langCodes.split(LOCALE_LANG_DELIMITER)));
        return ProfileLanguageUtils.getLabelStringWithID(codesSet, ProfileLanguageUtils.getLocaleCodeLabelMap(), showID);
    }

    public static Set<String> convertCodeStringToSet(String value) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, LOCALE_LANG_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                result.add(token.trim());
            }
        }
        return result;
    }

    public static String convertCodeSetToString(Set<String> localeSet) {
        StringBuffer sb = new StringBuffer();
        for (String langCode : localeSet) {
            if (sb.length() != 0) {
                sb.append(LOCALE_LANG_DELIMITER);
            }
            sb.append(langCode);
        }
        return sb.toString();
    }
}

