/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.compat;

import com.ibm.cic.common.core.compat.CompatMap;
import com.ibm.cic.common.core.compat.CompatMapXml;
import com.ibm.cic.common.core.compat.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompatMapParser
extends XMLParser {
    private static final Logger log = Logger.getLogger(CompatMapParser.class);
    private int nextStateOrdinal = 0;
    private final List states = new ArrayList();
    private final State STATE_IGNORED = new State("ignored", 0);
    private final State STATE_NO_CONTENT = new State("no-content", 1);
    private final State STATE_INITIAL = new State("initial", 2);
    private final State STATE_COMPATIBILITY = new State("compatibility");
    private final State STATE_OUTER_OFFERING = new State("offering");
    private final State STATE_OUTER_VERSION = new State("version");
    private final State STATE_INFORMATION = new State("information");
    private final State STATE_NAME = new State("name");
    private final State STATE_INNER_OFFERING = new State("offering");
    private final State STATE_INNER_VERSION = new State("version");
    private final State STATE_FEATURES = new State("features");
    private final State STATE_FEATURE = new State("feature");
    private String errorPrefix = null;

    public String[] getStateNames() {
        String[] result = new String[this.states.size()];
        int i = 0;
        while (i < result.length) {
            State state = (State)this.states.get(i);
            if (state != null) {
                result[i] = state.name;
            }
            ++i;
        }
        return result;
    }

    public State getState(int ordinal) {
        return (State)this.states.get(ordinal);
    }

    private void addState(int ordinal, State state) {
        assert (ordinal >= this.nextStateOrdinal);
        this.nextStateOrdinal = ordinal + 1;
        while (this.states.size() <= ordinal) {
            this.states.add(null);
        }
        this.states.set(ordinal, state);
    }

    public CompatMapParser(BundleContext context) {
        super(context, ComIbmCicCommonCorePlugin.getPluginId());
        this.stateStack = new XMLParser.StateStack(this.getStateNames());
    }

    public String toString() {
        return this.stateStack.toString();
    }

    public CompatMap parse(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            CompatMap compatMap = this.parse(file.getPath(), is);
            return compatMap;
        }
    }

    public CompatMap parse(String name, InputStream is) throws IOException {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)is);
        this.status = null;
        this.errorPrefix = String.valueOf(name) + ": ";
        try {
            this.getParser().parse(is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            this.addError(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            this.addError(e.getMessage());
        }
        while (this.peek() != this.STATE_INITIAL) {
            this.pop();
        }
        return (CompatMap)this.peekObject();
    }

    @Override
    protected String getErrorMessage() {
        return Messages.CompatMapParser_Error_Parsing;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected Object getRootObject() {
        return null;
    }

    @Override
    protected String getErrorPrefix() {
        return this.errorPrefix;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        Version version;
        if ("compatibility".equals(target) && !CompatMapXml.PI.TOLERANCE.isIncluded(version = MetaInfo.extractVersion(data))) {
            throw new SAXException(NLS.bind((String)Messages.CompatMapParser_Incompatible_Version, (Object)version, (Object)CompatMapXml.PI.TOLERANCE));
        }
    }

    @Override
    public void startDocument() {
        this.stateStack.clear();
        this.push(this.STATE_INITIAL, (Object)new CompatMap());
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.trace(name, attributes);
        this.finishCharacters();
        State state = this.peek();
        int stackSize = this.stateStack.size();
        if (state == this.STATE_IGNORED) {
            this.push(this.STATE_IGNORED, (Object)("error: " + name));
        } else if (state == this.STATE_NO_CONTENT) {
            this.unexpectedElementError(name);
        } else if (state == this.STATE_INITIAL) {
            this.handleInitialState(name, attributes);
        } else if (state == this.STATE_COMPATIBILITY) {
            this.handleCompatibilityState(name, attributes);
        } else if (state == this.STATE_OUTER_OFFERING) {
            this.handleOuterOfferingState(name, attributes);
        } else if (state == this.STATE_OUTER_VERSION) {
            this.handleOuterVersionState(name, attributes);
        } else if (state == this.STATE_INFORMATION) {
            this.handleInformationState(name, attributes);
        } else if (state == this.STATE_NAME) {
            this.push(this.STATE_NO_CONTENT, (Object)this.STATE_NAME);
        } else if (state == this.STATE_INNER_OFFERING) {
            this.handleInnerOfferingState(name, attributes);
        } else if (state == this.STATE_INNER_VERSION) {
            this.handleInnerVersionState(name, attributes);
        } else if (state == this.STATE_FEATURES) {
            this.handleFeaturesState(name, attributes);
        } else if (state == this.STATE_FEATURE) {
            this.handleFeatureState(name, attributes);
        } else {
            throw new XMLParser.BadStateError(this);
        }
        assert (this.stateStack.size() == stackSize + 1) : "Failed to push element on stack";
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.finishCharacters();
        this.pop();
        this.trace(name, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String processCharacters(String trimmedChars) {
        this.trace(trimmedChars);
        State state = this.peek();
        if (state == this.STATE_NAME) {
            String lang = (String)this.peekObject();
            State parentState = this.peekParent();
            if (parentState == this.STATE_INFORMATION) {
                ((CompatMap.Information)this.peekParentObject()).addName(trimmedChars, lang);
                return trimmedChars;
            } else {
                if (parentState != this.STATE_FEATURE) throw new XMLParser.BadStateError(this);
                ((CompatMap.Feature)this.peekParentObject()).addName(trimmedChars, lang);
            }
            return trimmedChars;
        } else {
            if (state == this.STATE_IGNORED) return trimmedChars;
            this.unexpectedCharacterData(trimmedChars);
        }
        return trimmedChars;
    }

    private void handleInitialState(String name, Attributes attributes) {
        if (name.equals("compatibility")) {
            this.push(this.STATE_COMPATIBILITY, this.peekObject());
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleCompatibilityState(String name, Attributes attributes) {
        CompatMap compatMap = (CompatMap)this.peekObject();
        if (name.equals("offering")) {
            String[] values = this.parseAttributes(name, attributes, new String[]{"id"}, new String[]{"extension"});
            String id = values[0];
            boolean isExtension = this.parseBoolean(values[1], false);
            CompatMap.OuterOffering offering = new CompatMap.OuterOffering(id, isExtension);
            compatMap.addOffering(offering);
            this.push(this.STATE_OUTER_OFFERING, (Object)offering);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleOuterOfferingState(String name, Attributes attributes) {
        CompatMap.OuterOffering offering = (CompatMap.OuterOffering)this.peekObject();
        if (name.equals("information")) {
            CompatMap.Information information = new CompatMap.Information();
            if (offering.getInformation() != CompatMap.Information.NULL) {
                this.addError(Messages.CompatMapParser_One_Information_Allowed);
            }
            offering.setInformation(information);
            this.push(this.STATE_INFORMATION, (Object)information);
        } else if (name.equals("version")) {
            String rangeString = this.parseRequiredAttribute(name, attributes, "range");
            VersionRange range = this.parseVersionRange(rangeString);
            CompatMap.OuterVersion version = new CompatMap.OuterVersion(range);
            VersionRange conflicting = offering.getConflictingRange(range);
            if (conflicting != null) {
                this.addError(NLS.bind((String)Messages.CompatMapParser_Conflicting_Version_Ranges, (Object)conflicting, (Object)range));
            } else {
                offering.addVersion(version);
            }
            this.push(this.STATE_OUTER_VERSION, (Object)version);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleOuterVersionState(String name, Attributes attributes) {
        CompatMap.OuterVersion version = (CompatMap.OuterVersion)this.peekObject();
        if (name.equals("offering")) {
            String[] values = this.parseAttributes(name, attributes, new String[]{"id"}, new String[]{"base"});
            String id = values[0];
            boolean isBase = this.parseBoolean(values[1], false);
            CompatMap.InnerOffering offering = version.getOffering(id);
            if (offering == null) {
                offering = new CompatMap.InnerOffering(id, isBase);
                version.addOffering(offering);
            } else if (offering.isBase() != isBase) {
                this.addError(NLS.bind((String)Messages.CompatMapParser_Inconsistent_IsBase, (Object)id));
            }
            this.push(this.STATE_INNER_OFFERING, (Object)offering);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleInformationState(String name, Attributes attributes) {
        CompatMap.Information information = (CompatMap.Information)this.peekObject();
        if (name.equals("version")) {
            String[] values = this.parseRequiredAttributes(name, attributes, "external", "internal");
            String external = values[0];
            Version internal = this.parseVersion(values[1]);
            information.addVersion(external, internal);
            this.push(this.STATE_NO_CONTENT, (Object)"version");
        } else if (name.equals("name")) {
            String lang = this.parseOptionalAttribute(name, attributes, "lang");
            this.push(this.STATE_NAME, (Object)lang);
        } else if (name.equals("feature")) {
            String id = this.parseRequiredAttribute(name, attributes, "id");
            CompatMap.Feature feature = new CompatMap.Feature(id);
            information.addFeature(feature);
            this.push(this.STATE_FEATURE, (Object)feature);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleInnerOfferingState(String name, Attributes attributes) {
        CompatMap.InnerOffering offering = (CompatMap.InnerOffering)this.peekObject();
        if (name.equals("version")) {
            String rangeString = this.parseRequiredAttribute(name, attributes, "range");
            VersionRange range = this.parseVersionRange(rangeString);
            CompatMap.InnerVersion version = new CompatMap.InnerVersion(range);
            VersionRange conflicting = offering.getConflictingRange(range);
            if (conflicting != null) {
                this.addError(NLS.bind((String)Messages.CompatMapParser_Conflicting_Version_Ranges, (Object)conflicting, (Object)range));
            } else {
                offering.addVersion(version);
            }
            this.push(this.STATE_INNER_VERSION, (Object)version);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleInnerVersionState(String name, Attributes attributes) {
        CompatMap.InnerVersion version = (CompatMap.InnerVersion)this.peekObject();
        if (name.equals("features")) {
            this.checkNoAttributes(name, attributes);
            this.push(this.STATE_FEATURES, (Object)version);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleFeaturesState(String name, Attributes attributes) {
        CompatMap.InnerVersion version = (CompatMap.InnerVersion)this.peekObject();
        if (name.equals("feature")) {
            String id = this.parseRequiredAttribute(name, attributes, "id");
            version.addFeature(id);
            this.push(this.STATE_NO_CONTENT, (Object)"feature");
        } else {
            this.unexpectedElementError(name);
        }
    }

    private void handleFeatureState(String name, Attributes attributes) {
        if (name.equals("name")) {
            String lang = this.parseOptionalAttribute(name, attributes, "lang");
            this.push(this.STATE_NAME, (Object)lang);
        } else {
            this.unexpectedElementError(name);
        }
    }

    private VersionRange parseVersionRange(String rangeString) {
        VersionRange range;
        try {
            range = new VersionRange(rangeString);
        }
        catch (IllegalArgumentException e) {
            this.addError(NLS.bind((String)Messages.CompatMapParser_Invalid_Version_Range, (Object)rangeString));
            return VersionRange.emptyRange;
        }
        if (range.equals((Object)VersionRange.emptyRange)) {
            this.addError(Messages.CompatMapParser_Empty_Version_Range);
            return VersionRange.emptyRange;
        }
        if (!range.getIncludeMinimum() || range.getIncludeMaximum()) {
            this.addError(NLS.bind((String)Messages.CompatMapParser_Version_Range_Bounds, (Object)rangeString));
        }
        return range;
    }

    private State peek() {
        return this.getState(this.peekState());
    }

    private State peekParent() {
        return this.getState(this.peekParentState());
    }

    private void push(State state, Object value) {
        this.push(state.getOrdinal(), value);
    }

    private class State {
        private final int ordinal;
        private final String name;

        private State(String name) {
            this(name, compatMapParser.nextStateOrdinal);
        }

        private State(String name, int ordinal) {
            this.ordinal = ordinal;
            this.name = name;
            CompatMapParser.this.addState(ordinal, this);
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }
    }
}

