/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.compat;

import com.ibm.cic.common.core.compat.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class CompatMap {
    private final Map offerings = new TreeMap();

    CompatMap() {
    }

    public String toString() {
        return CompatMap.addCount("CompatMap", this.offerings.size(), "offerings");
    }

    public OuterOffering getOffering(String id) {
        return (OuterOffering)this.offerings.get(id);
    }

    void addOffering(OuterOffering offering) {
        this.offerings.put(offering.getId(), offering);
    }

    public Information getInformation(String offeringId) {
        OuterOffering offering = this.getOffering(offeringId);
        return offering == null ? Information.NULL : offering.getInformation();
    }

    public boolean isCompatible(String offeringId1, Version version1, String offeringId2, Version version2) {
        OuterOffering offering1 = this.getOffering(offeringId1);
        if (offering1 == null) {
            return false;
        }
        for (OuterVersion outerVersion : offering1.getVersions()) {
            InnerOffering innerOffering;
            if (!outerVersion.getRange().isIncluded(version1) || (innerOffering = outerVersion.getOffering(offeringId2)) == null) continue;
            for (InnerVersion innerVersion : innerOffering.getVersions()) {
                if (!innerVersion.getRange().isIncluded(version2)) continue;
                return true;
            }
        }
        return false;
    }

    public List getCompatible(String offeringId1, Version version1, String offeringId2) {
        OuterOffering offering1 = this.getOffering(offeringId1);
        if (offering1 == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        for (OuterVersion outerVersion : offering1.getVersions()) {
            InnerOffering innerOffering;
            if (!outerVersion.getRange().isIncluded(version1) || (innerOffering = outerVersion.getOffering(offeringId2)) == null) continue;
            result.addAll(innerOffering.getVersions());
        }
        return Collections.unmodifiableList(result);
    }

    public IStatus mergeIn(CompatMap that) {
        Assert.isNotNull((Object)that);
        CicMultiStatus result = Statuses.ST.createMultiStatus(Messages.CompatMap_Inconsistent_Information, new Object[0]);
        for (OuterOffering thatOffering : that.offerings.values()) {
            OuterOffering thisOffering = this.getOffering(thatOffering.getId());
            if (thisOffering == null) {
                this.addOffering(thatOffering);
                continue;
            }
            result.add(thisOffering.mergeIn(thatOffering));
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(this);
        for (OuterOffering o1 : this.offerings.values()) {
            sb.append("\nOffering: ").append(o1.toString());
            Information info = o1.getInformation();
            sb.append("\n Name: ").append(info.getName());
            for (Feature feature : info.getFeatures()) {
                sb.append("\n Feature ").append(feature.getId()).append(' ').append(feature.getName());
                if (feature.getName("es") == null) continue;
                sb.append(" (es: ").append(feature.getName("es")).append(')');
            }
            for (Version internal : info.getInternalVersions()) {
                String external = info.getExternalVersion(internal);
                sb.append("\n  Version: ").append(external).append(' ').append(internal);
            }
            for (OuterVersion v1 : o1.getVersions()) {
                sb.append("\n Version: ").append(v1);
                for (InnerOffering o2 : v1.getOfferings()) {
                    sb.append("\n  ").append(o2);
                    for (InnerVersion v2 : o2.getVersions()) {
                        sb.append("\n   ").append(v2);
                        for (String feature : v2.getFeatures()) {
                            sb.append("\n    ").append(feature);
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    private static String addCount(Object object, int count, String what) {
        return String.valueOf(String.valueOf(object)) + " (" + count + ' ' + what + ')';
    }

    static IStatus mergeInMap(String what, Map thisMap, Map thatMap) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        for (Map.Entry entry : thatMap.entrySet()) {
            Object key = entry.getKey();
            Object thisValue = thisMap.get(key);
            Object thatValue = entry.getValue();
            if (thisValue == null) {
                thisMap.put(key, thatValue);
                continue;
            }
            if (thisValue.equals(thatValue)) continue;
            result.add(Statuses.ERROR.get(Messages.CompatMap_Inconsistent_Something, what, key, thisValue, thatValue));
        }
        return result;
    }

    public static class Feature {
        private final String id;
        private final LocalizedName localizedName = new LocalizedName();

        Feature(String id) {
            Assert.isNotNull((Object)id);
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Feature)) {
                return false;
            }
            Feature that = (Feature)obj;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            String result = this.localizedName.getName();
            return result == null ? this.id : result;
        }

        public String getName(String lang) {
            String result = this.localizedName.getName(lang);
            return result == null ? this.id : result;
        }

        void addName(String name, String lang) {
            this.localizedName.addName(name, lang);
        }

        IStatus mergeIn(Feature that) {
            CicMultiStatus result = Statuses.ST.createMultiStatus(NLS.bind(Messages.CompatMap_For_Feature, (Object)this.id), new Object[0]);
            result.add(this.localizedName.mergeIn(that.localizedName));
            return result;
        }
    }

    public static class Information {
        public static final Information NULL = new Information();
        private final LocalizedName localizedName = new LocalizedName();
        private final Map versions = new TreeMap();
        private final Map features = new TreeMap();

        Information() {
        }

        public String toString() {
            return CompatMap.addCount(CompatMap.addCount(this.localizedName.toString(), this.versions.size(), "versions"), this.features.size(), "features");
        }

        public String getName() {
            return this.localizedName.getName();
        }

        public String getName(String lang) {
            return this.localizedName.getName(lang);
        }

        public Collection getInternalVersions() {
            return Collections.unmodifiableCollection(this.versions.keySet());
        }

        public String getExternalVersion(Version internal) {
            return (String)this.versions.get(internal);
        }

        public Feature getFeature(String id) {
            return (Feature)this.features.get(id);
        }

        public Collection getFeatures() {
            return this.features.values();
        }

        void addName(String name, String lang) {
            this.localizedName.addName(name, lang);
        }

        void addVersion(String external, Version internal) {
            this.versions.put(internal, external);
        }

        void addFeature(Feature feature) {
            this.features.put(feature.getId(), feature);
        }

        IStatus mergeIn(Information that) {
            CicMultiStatus result = Statuses.ST.createMultiStatus();
            result.add(this.localizedName.mergeIn(that.localizedName));
            result.add(CompatMap.mergeInMap("versions", this.versions, that.versions));
            for (String id : that.features.keySet()) {
                Feature thatFeature = that.getFeature(id);
                Feature thisFeature = this.getFeature(id);
                if (thisFeature == null) {
                    this.addFeature(thatFeature);
                    continue;
                }
                result.add(thisFeature.mergeIn(thatFeature));
            }
            return result;
        }
    }

    public static class InnerOffering {
        private final String id;
        private final boolean isBase;
        private final List versions = new ArrayList();

        InnerOffering(String id, boolean isBase) {
            this.id = id;
            this.isBase = isBase;
        }

        InnerOffering(InnerOffering that) {
            this(that.id, that.isBase);
            for (InnerVersion innerVersion : that.versions) {
                this.versions.add(new InnerVersion(innerVersion));
            }
        }

        public String toString() {
            return CompatMap.addCount("offering " + this.getId() + (this.isBase() ? " base" : ""), this.versions.size(), "versions");
        }

        public String getId() {
            return this.id;
        }

        public boolean isBase() {
            return this.isBase;
        }

        public List getVersions() {
            return Collections.unmodifiableList(this.versions);
        }

        void addVersion(InnerVersion version) {
            this.versions.add(version);
        }

        VersionRange getConflictingRange(VersionRange range) {
            if (range == VersionRange.emptyRange) {
                return null;
            }
            for (InnerVersion version : this.versions) {
                VersionRange conflicting = version.getRange();
                if (conflicting == VersionRange.emptyRange || !VersionUtil.hasIntersection(conflicting, range)) continue;
                return conflicting;
            }
            return null;
        }

        IStatus mergeIn(InnerOffering that) {
            assert (this.id.equals(that.id));
            CicMultiStatus result = Statuses.ST.createMultiStatus(NLS.bind(Messages.CompatMap_For_Dependent_Offering, (Object)this.id), new Object[0]);
            if (this.isBase != that.isBase) {
                result.add(Statuses.ERROR.get(Messages.CompatMap_Inconsistent_IsBase, new Object[0]));
            }
            for (InnerVersion version : that.versions) {
                this.addVersion(version);
            }
            return result;
        }
    }

    public static class InnerVersion {
        private final VersionRange range;
        private final List features = new ArrayList();

        InnerVersion(VersionRange range) {
            this.range = range;
        }

        InnerVersion(InnerVersion that) {
            this(that.range);
            this.features.addAll(that.features);
        }

        public String toString() {
            return CompatMap.addCount(this.getRange(), this.getFeatures().size(), "features");
        }

        public VersionRange getRange() {
            return this.range;
        }

        public List getFeatures() {
            return Collections.unmodifiableList(this.features);
        }

        void addFeature(String id) {
            this.features.add(id);
        }
    }

    private static class LocalizedName {
        public static final String DEFAULT_LANG = "en";
        private static final String LOCALE_LANGUAGE;
        private static final String LOCALE_LANGUAGE_COUNTRY;
        private final Map names = new TreeMap();

        static {
            Locale locale = Locale.getDefault();
            LOCALE_LANGUAGE = locale.getLanguage();
            LOCALE_LANGUAGE_COUNTRY = String.valueOf(LOCALE_LANGUAGE) + '_' + locale.getCountry();
        }

        public String toString() {
            return this.getName(DEFAULT_LANG);
        }

        public String getName() {
            String name = this.getName(LOCALE_LANGUAGE_COUNTRY);
            if (name == null && (name = this.getName(LOCALE_LANGUAGE)) == null) {
                name = this.getName(DEFAULT_LANG);
            }
            return name;
        }

        public String getName(String lang) {
            String result = (String)this.names.get(lang);
            return result == null ? (String)this.names.get(DEFAULT_LANG) : result;
        }

        void addName(String name, String lang) {
            Assert.isNotNull((Object)name);
            this.names.put(lang == null ? DEFAULT_LANG : lang, name);
        }

        IStatus mergeIn(LocalizedName that) {
            return CompatMap.mergeInMap("names", this.names, that.names);
        }
    }

    public static class OuterOffering {
        private final String id;
        private final boolean isExtension;
        private Information information = Information.NULL;
        private final Map versions = new TreeMap(Comparators.VERSION_RANGE);

        OuterOffering(String id, boolean isExtension) {
            this.id = id;
            this.isExtension = isExtension;
        }

        public String toString() {
            return CompatMap.addCount("Offering " + this.getId() + (this.isExtension() ? " extension" : ""), this.getVersions().size(), "versions");
        }

        public String getId() {
            return this.id;
        }

        public boolean isExtension() {
            return this.isExtension;
        }

        public Information getInformation() {
            return this.information;
        }

        void setInformation(Information information) {
            this.information = information;
        }

        public Collection getVersions() {
            return Collections.unmodifiableCollection(this.versions.values());
        }

        void addVersion(OuterVersion thatVersion) {
            this.versions.put(thatVersion.getRange(), thatVersion);
        }

        IStatus mergeIn(OuterOffering that) {
            assert (this.id.equals(that.id));
            CicMultiStatus result = Statuses.ST.createMultiStatus(NLS.bind(Messages.CompatMap_For_Offering, (Object)this.id), new Object[0]);
            if (this.isExtension != that.isExtension) {
                result.add(Statuses.ERROR.get(Messages.CompatMap_Inconsistent_IsExtension, new Object[0]));
            }
            if (this.information == Information.NULL) {
                this.setInformation(that.information);
            } else {
                result.add(this.information.mergeIn(that.information));
            }
            for (OuterVersion version : that.getVersions()) {
                result.add(this.mergeIn(version));
            }
            return result;
        }

        private IStatus mergeIn(OuterVersion thatVersion) {
            VersionRange thatRange = thatVersion.getRange();
            Iterator i = this.versions.values().iterator();
            while (i.hasNext()) {
                OuterVersion newVersion;
                OuterVersion thisVersion = (OuterVersion)i.next();
                VersionRange thisRange = thisVersion.getRange();
                if (thisRange.equals((Object)thatRange)) {
                    return thisVersion.mergeIn(thatVersion);
                }
                VersionRange intersection = VersionUtil.computeIntersection(thisRange, thatRange);
                if (intersection == null) continue;
                CicMultiStatus result = Statuses.ST.createMultiStatus();
                VersionRange lower = VersionUtil.lowerComplement(thisRange, thatRange);
                VersionRange upper = VersionUtil.upperComplement(thisRange, thatRange);
                if (thisRange.equals((Object)intersection)) {
                    result.add(thisVersion.mergeIn(thatVersion));
                } else {
                    i.remove();
                    newVersion = new OuterVersion(intersection);
                    result.add(newVersion.mergeIn(thisVersion));
                    result.add(newVersion.mergeIn(thatVersion));
                    this.addVersion(newVersion);
                }
                if (lower != null) {
                    newVersion = new OuterVersion(lower);
                    result.add(newVersion.mergeIn(thatVersion));
                    this.addVersion(newVersion);
                }
                if (upper != null) {
                    newVersion = new OuterVersion(upper);
                    result.add(newVersion.mergeIn(thatVersion));
                    this.addVersion(newVersion);
                }
                return result;
            }
            this.addVersion(thatVersion);
            return Status.OK_STATUS;
        }

        VersionRange getConflictingRange(VersionRange range) {
            if (range == VersionRange.emptyRange) {
                return null;
            }
            for (OuterVersion version : this.getVersions()) {
                VersionRange conflicting = version.getRange();
                if (conflicting == VersionRange.emptyRange || !VersionUtil.hasIntersection(conflicting, range)) continue;
                return conflicting;
            }
            return null;
        }
    }

    public static class OuterVersion {
        private final VersionRange range;
        private final Map offerings = new TreeMap();

        OuterVersion(VersionRange range) {
            this.range = range;
        }

        OuterVersion(OuterVersion that) {
            this(that.range);
            for (Map.Entry entry : that.offerings.entrySet()) {
                InnerOffering innerOffering = (InnerOffering)entry.getValue();
                this.offerings.put(entry.getKey(), new InnerOffering(innerOffering));
            }
        }

        public String toString() {
            return CompatMap.addCount(this.getRange(), this.getOfferings().size(), "offerings");
        }

        public VersionRange getRange() {
            return this.range;
        }

        public InnerOffering getOffering(String id) {
            return (InnerOffering)this.offerings.get(id);
        }

        public Collection getOfferings() {
            return Collections.unmodifiableCollection(this.offerings.values());
        }

        void addOffering(InnerOffering offering) {
            this.offerings.put(offering.getId(), offering);
        }

        IStatus mergeIn(OuterVersion that) {
            CicMultiStatus result = Statuses.ST.createMultiStatus();
            for (String id : that.offerings.keySet()) {
                InnerOffering thatOffering = that.getOffering(id);
                InnerOffering thisOffering = this.getOffering(id);
                if (thisOffering == null) {
                    this.addOffering(thatOffering);
                    continue;
                }
                result.add(thisOffering.mergeIn(thatOffering));
            }
            return result;
        }
    }
}

