/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.ANetworkCmdOp;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.cmd.CmdRepositoryUtils;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.internal.IdAndVersion;
import com.ibm.cic.common.core.model.proxy.OfferingReference;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Version;

public class ListPackagesUtil {
    private static <T extends IOfferingOrFix> Collection<T> sort(Collection<T> pkgs) {
        TreeSet<IContent> result = new TreeSet<IContent>(Comparators.CONTENT_COMPARATOR);
        result.addAll(pkgs);
        return result;
    }

    private static List<IOffering> collectOfferingsAndUpdates(IRepository repo, SubMonitor sm) {
        String msg = NLS.bind(Messages.ListPackagesUtil_taskCollectingAllOfferingsAndUpdatesInRepo, (Object)repo.getLocation());
        sm.beginTask(msg, 1);
        try {
            List<IOffering> list = CmdRepositoryUtils.getAllOfferingsAndUpdates(repo, (IProgressMonitor)sm.newChild(1));
            return list;
        }
        finally {
            sm.done();
        }
    }

    private static Collection<IFix> collectFixes(IRepository repo, SubMonitor sm) {
        sm.beginTask("", 1);
        try {
            List fixes = Collections.EMPTY_LIST;
            List list = fixes = repo.getAllFixes((IProgressMonitor)sm.newChild(1));
            return list;
        }
        finally {
            sm.done();
        }
    }

    public static IStatus listPackagesCheckUseServiceRepositories(PackagesLister packageLister, String verbosePrefix, Collection<IOffering> offerings, Collection<IFix> fixes, IProgressMonitor monitor) {
        boolean listFixesInServiceRepo = false;
        return ListPackagesUtil.listPackagesCheckUseServiceRepositories(new CmdRepositoryUtils.IOpenServiceRepoHandler(){

            @Override
            public IStatus onOpenServiceRepository(IStatus status) {
                return status;
            }
        }, packageLister, verbosePrefix, offerings, fixes, listFixesInServiceRepo, monitor);
    }

    public static IStatus listPackagesCheckUseServiceRepositories(CmdRepositoryUtils.IOpenServiceRepoHandler openServiceRepoHandler, PackagesLister packageLister, String verbosePrefix, Collection<IOffering> offerings, Collection<IFix> fixes, boolean listFixesInServiceRepo, IProgressMonitor monitor) {
        ACmdLine cl = packageLister.getCommandLine();
        boolean useServiceRepository = CmdRepositoryUtils.useServiceRepositoryCmd(cl);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)((useServiceRepository ? 2 : 0) * offerings.size()));
        packageLister.outputPackages(verbosePrefix, offerings, fixes);
        if (useServiceRepository) {
            RepositoryGroup serviceGroup = new RepositoryGroup("ListPackagesUtil.service");
            try {
                IOffering[] array = offerings.toArray(new IOffering[offerings.size()]);
                IStatus status = CmdRepositoryUtils.openServiceRepositories(openServiceRepoHandler, cl, serviceGroup, array, (IProgressMonitor)sm.newChild(1, 0));
                if (status.matches(6)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                Collection repos = serviceGroup.getRepositories();
                sm.setWorkRemaining(2 * repos.size());
                for (IRepository repo : repos) {
                    List<IOffering> offeringsInRepo = ListPackagesUtil.collectOfferingsAndUpdates(repo, sm.newChild(1, 0));
                    List fixesInRepo = listFixesInServiceRepo ? ListPackagesUtil.collectFixes(repo, sm.newChild(1, 0)) : Collections.EMPTY_LIST;
                    packageLister.outputPackages(repo.getLocationStr(), offeringsInRepo, fixesInRepo);
                }
            }
            finally {
                ServiceRepositoryUtils.unloadServiceRepositories(serviceGroup);
            }
        }
        return Status.OK_STATUS;
    }

    private static void outputPlatforms(OutputFormatter output, IFix fix) {
        MapSet<String, String> supportedPlatforms = FixUtil.getSupportedPlatforms(fix);
        output.appendNT(" : ", supportedPlatforms == null ? "SAME_AS_PACKAGE" : Util.toPlatformString(supportedPlatforms));
    }

    private static void outputFixes(ACmdLine cl, OutputFormatter output, String verbosePrefix, Collection<IFix> fixes) {
        boolean longListing = cl.containsCommand("-long");
        boolean showPlatforms = cl.containsCommand("-showPlatforms");
        ArrayList<IFix> pkgs = new ArrayList<IFix>(fixes.size());
        pkgs.addAll(ListPackagesUtil.sort(fixes));
        for (IFix fix : pkgs) {
            if (longListing) {
                output.appendNT(verbosePrefix, " : ");
            }
            output.appendNT(fix.getIdentity().getId(), "_", fix.getVersion().toString());
            if (longListing) {
                output.appendNT(" : ", "recommended", "=", Boolean.toString(FixProperty.isRecommended(fix)));
            }
            if (showPlatforms) {
                ListPackagesUtil.outputPlatforms(output, fix);
            }
            output.nl();
        }
    }

    public static abstract class ListAvailableCmdOp
    extends ANetworkCmdOp {
        public ListAvailableCmdOp(ACmdLine cl) {
            super(cl);
        }

        @Override
        protected IStatus execute(IRepositoryGroup group, IProgressMonitor opMonitor) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)os, new XMLWriter.ProcessingInstruction("repositories", MetaInfo.formatVersion(new Version(1, 0, 0))));
            writer.start("repositories");
            ListAvailableLister packageLister = new ListAvailableLister(this.cl, writer);
            Collection repos = group.getRepositories();
            IProgressMonitor monitor = CmdUtils.consoleMonitorWithUnknownWork(this.cl);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ListPackagesUtil_taskSearchingForPackages, (int)(3 * repos.size()));
            try {
                for (IRepository repo : repos) {
                    Collection fixes = ListPackagesUtil.collectFixes(repo, sm.newChild(1, 0));
                    IStatus status = ListPackagesUtil.listPackagesCheckUseServiceRepositories(this, packageLister, repo.getLocationStr(), ListPackagesUtil.collectOfferingsAndUpdates(repo, sm.newChild(1, 0)), fixes, true, (IProgressMonitor)sm.newChild(1));
                    if (status.isOK()) continue;
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            writer.end("repositories");
            writer.close();
            this.reportFailedOpenRepositories();
            CmdUtils.output(this.cl, this.out, Encodings.UTF8.toString(os));
            return this.done(Status.OK_STATUS);
        }

        @Override
        public boolean isQuery() {
            return true;
        }
    }

    public static abstract class ListAvailableFixesCmdOp
    extends ANetworkCmdOp {
        public ListAvailableFixesCmdOp(ACmdLine cl) {
            super(cl);
        }

        @Override
        protected IStatus execute(IRepositoryGroup group, IProgressMonitor opMonitor) {
            OutputFormatter output = new OutputFormatter();
            IProgressMonitor monitor = CmdUtils.consoleMonitorWithUnknownWork(this.cl);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ListPackagesUtil_taskSearchingForFixes, (int)(2 + group.getRepositories().size()));
            try {
                CmdCommand cmd = this.cl.getCommand("listAvailableFixes");
                IdAndVersion iav = CmdRepositoryUtils.splitPackageIdVersion(cmd.getParamStrVal(0));
                if (iav.getVersion() == null) {
                    IStatus iStatus = this.done(Statuses.ERROR.get(Messages.Cmd_listAvailableFixes_Error_MissingVersion, new Object[0]));
                    return iStatus;
                }
                if (CmdRepositoryUtils.useServiceRepositoryCmd(this.cl)) {
                    IOffering[] offerings = new IOffering[]{CmdRepositoryUtils.resolveOffering(group, iav.getIdentity(), iav.getVersion(), (IProgressMonitor)sm.newChild(1, 0))};
                    if (offerings[0] == null) {
                        IStatus iStatus = this.done(CmdRepositoryUtils.getFailedToFindPackageError(iav.getIdentity(), iav.getVersion()));
                        return iStatus;
                    }
                    IStatus status = CmdRepositoryUtils.openServiceRepositories(this, this.cl, group, offerings, (IProgressMonitor)sm.newChild(1, 0));
                    if (status.matches(12)) {
                        IStatus iStatus = this.done(status);
                        return iStatus;
                    }
                }
                Collection repos = group.getRepositories();
                sm.setWorkRemaining(repos.size());
                for (IRepository repo : repos) {
                    ArrayList<IFix> applicableFixes = this.searchApplicableFixes(repo, iav, sm.newChild(1, 0));
                    ListPackagesUtil.outputFixes(this.cl, output, repo.getLocationStr(), applicableFixes);
                }
            }
            finally {
                monitor.done();
            }
            this.reportFailedOpenRepositories();
            CmdUtils.output(this.cl, this.out, output.toString());
            return this.done(Status.OK_STATUS);
        }

        private ArrayList<IFix> searchApplicableFixes(IRepository repo, IdAndVersion iav, SubMonitor sm) {
            String msg = NLS.bind(Messages.ListPackagesUtil_taskCollectingFixesApplicableToInRepo, iav.getIdentity(), iav.getVersion(), repo.getLocation());
            sm.beginTask(msg, 3);
            List fixes = repo.getAllFixes((IProgressMonitor)sm.newChild(1, 0));
            sm.setWorkRemaining(fixes.size());
            ArrayList<IFix> applicableFixes = new ArrayList<IFix>(fixes.size());
            for (IFix fix : fixes) {
                if (!FixUtil.isFixApplicable(fix, iav.getIdentity(), iav.getVersion())) continue;
                applicableFixes.add(fix);
                sm.worked(1);
            }
            sm.done();
            return applicableFixes;
        }

        @Override
        public boolean isQuery() {
            return true;
        }
    }

    public static class ListAvailableLister
    extends PackagesLister {
        public static final String REPOSITORIES = "repositories";
        public static final String REPOSITORY = "repository";
        public static final String LOCATION = "location";
        public static final String PACKAGE = "package";
        public static final String UPDATE_FROM = "updateFrom";
        public static final String INFORMATION = "information";
        public static final String ID = "id";
        public static final String VERSION = "version";
        public static final String FIX = "fix";
        public static final String RECOMMENDED = "recommended";
        public static final String FIX_APPLICABLE_OFFERING_TOLERANCE = "tolerance";
        public static final String APPLICABILITY = "applicability";
        public static final String NAME = "name";
        public static final String DISPLAYVERSION = "displayVersion";
        public static final String PLATFORMS = "platforms";
        public static final String PLATFORM = "platform";
        public static final String OS = "os";
        public static final String ARCH = "arch";
        XMLWriter writer;

        ListAvailableLister(ACmdLine cl, XMLWriter writer) {
            super(cl, null);
            this.writer = writer;
        }

        @Override
        public ACmdLine getCommandLine() {
            return super.getCommandLine();
        }

        @Override
        public void outputPackages(String verbosePrefix, Collection<IOffering> offerings, Collection<IFix> fixes) {
            this.writer.start(REPOSITORY);
            this.writer.attribute(LOCATION, verbosePrefix);
            for (IOffering o : ListPackagesUtil.sort(offerings)) {
                this.outputPackage(verbosePrefix, o);
            }
            for (IFix f : ListPackagesUtil.sort(fixes)) {
                this.outputFix(verbosePrefix, f);
            }
            this.writer.end(REPOSITORY);
        }

        @Override
        protected void outputPackage(String longPrefix, IOfferingOrFix pkg) {
            assert (pkg instanceof IOffering);
            IOffering offering = (IOffering)pkg;
            this.writer.start(PACKAGE);
            this.writer.attribute(ID, offering.getIdentity().getId());
            this.writer.attribute(VERSION, offering.getVersion().toString());
            this.outputInformation(offering);
            this.outputPlatformsForOfferingOrFix(offering);
            this.outputUpdateFrom(offering);
            this.writer.end(PACKAGE);
        }

        private void outputUpdateFrom(IOffering offering) {
            Version version = UpdateOfferingUtils.getBaseOfferingVersion(offering);
            if (version == null || version.equals((Object)Version.emptyVersion)) {
                return;
            }
            String displayableVersion = UpdateOfferingUtils.getBaseOfferingDisplayVersion(offering);
            this.writer.start(UPDATE_FROM);
            this.writer.attribute(VERSION, version);
            this.writer.attribute(DISPLAYVERSION, displayableVersion);
            this.writer.end(UPDATE_FROM);
        }

        private void outputFix(String longPrefix, IFix fix) {
            this.writer.start(FIX);
            this.writer.attribute(ID, fix.getIdentity().getId());
            this.writer.attribute(VERSION, fix.getVersion().toString());
            boolean recommended = FixProperty.isRecommended(fix);
            this.writer.attribute(RECOMMENDED, Boolean.toString(recommended));
            this.outputInformation(fix);
            this.outputPlatformsForOfferingOrFix(fix);
            this.outputApplicability(fix);
            this.writer.end(FIX);
        }

        private void outputApplicability(IFix fix) {
            this.writer.start(APPLICABILITY);
            for (Object object : fix.getApplicableOfferings()) {
                IFixApplicableOffering applicableOffering = (IFixApplicableOffering)object;
                this.writer.start(PACKAGE);
                this.writer.attribute(ID, applicableOffering.getIdentity().getId());
                this.writer.attribute(FIX_APPLICABLE_OFFERING_TOLERANCE, applicableOffering.getTolerance().toString());
                this.writer.end(PACKAGE);
            }
            this.writer.end(APPLICABILITY);
        }

        private void outputInformation(IOfferingOrFix offeringOrFix) {
            Information information = offeringOrFix.getInformation();
            if (information == null) {
                return;
            }
            this.writer.start(INFORMATION);
            this.writer.attribute(NAME, information.getName());
            this.writer.attribute(VERSION, information.getVersion());
            this.writer.cdata(information.getDescription());
            this.writer.end(INFORMATION);
        }

        @Override
        protected void outputFeatures(IOffering offering) {
            assert (false);
        }

        private boolean repositoryIsSliced(IOfferingOrFix offeringOrFix) {
            if (offeringOrFix instanceof OfferingReference) {
                OfferingReference offeringReference = (OfferingReference)offeringOrFix;
                List<String> slices = offeringReference.getListOfPlatformSlices();
                return !slices.isEmpty();
            }
            return false;
        }

        @Override
        protected void outputPlatforms(IOffering offering) {
            assert (false);
        }

        private void outputPlatformsForOfferingOrFix(IOfferingOrFix offerinOrFix) {
            boolean explicitSpecificationOfSupportedPlatform = OfferingUtil.explicitSpecificationOfSupportedPlatform(offerinOrFix);
            boolean repositoryIsSliced = this.repositoryIsSliced(offerinOrFix);
            if (repositoryIsSliced || explicitSpecificationOfSupportedPlatform) {
                this.writer.start(PLATFORMS);
                MapSet<String, String> supportedPlatformsInRepository = OfferingUtil.getAllSupportedPlatforms(offerinOrFix);
                for (String os : supportedPlatformsInRepository.keySet()) {
                    for (String arch : supportedPlatformsInRepository.get(os)) {
                        this.writer.start(PLATFORM);
                        this.writer.attribute(OS, os);
                        this.writer.attribute(ARCH, arch);
                        this.writer.end(PLATFORM);
                    }
                }
                this.writer.end(PLATFORMS);
            }
        }

        @Override
        protected void outputUpdateInfo(IOffering offering) {
            assert (false);
        }

        @Override
        protected void outputRollbackVersions(IOffering offering) {
            assert (false);
        }
    }

    public static abstract class ListAvailablePackagesCmdOp
    extends ANetworkCmdOp {
        private static final boolean listFixes = false;

        public ListAvailablePackagesCmdOp(ACmdLine cl) {
            super(cl);
        }

        @Override
        protected IStatus execute(IRepositoryGroup group, IProgressMonitor opMonitor) {
            OutputFormatter output = new OutputFormatter();
            PackagesLister packageLister = new PackagesLister(this.cl, output);
            Collection repos = group.getRepositories();
            IProgressMonitor monitor = CmdUtils.consoleMonitorWithUnknownWork(this.cl);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ListPackagesUtil_taskSearchingForPackages, (int)(2 * repos.size()));
            try {
                for (IRepository repo : repos) {
                    List fixes = Collections.EMPTY_LIST;
                    IStatus status = ListPackagesUtil.listPackagesCheckUseServiceRepositories(this, packageLister, repo.getLocationStr(), ListPackagesUtil.collectOfferingsAndUpdates(repo, sm.newChild(1, 0)), fixes, false, (IProgressMonitor)sm.newChild(1));
                    if (status.isOK()) continue;
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            if (output.isEmpty() && !this.hasFailedRepositories()) {
                output.appendNT(Messages.Cmd_listAvailablePackages_NoPackagesFound);
            }
            this.reportFailedOpenRepositories();
            CmdUtils.output(this.cl, this.out, output.toString());
            return this.done(Status.OK_STATUS);
        }

        @Override
        public boolean isQuery() {
            return true;
        }
    }

    public static class PackagesLister {
        private final ACmdLine cl;
        protected final OutputFormatter output;

        public PackagesLister(ACmdLine cl, OutputFormatter output) {
            this.cl = cl;
            this.output = output;
        }

        public ACmdLine getCommandLine() {
            return this.cl;
        }

        public void outputPackages(String verbosePrefix, Collection<IOffering> offerings, Collection<IFix> fixes) {
            ArrayList pkgs = new ArrayList(offerings.size() + fixes.size());
            pkgs.addAll(ListPackagesUtil.sort(offerings));
            pkgs.addAll(ListPackagesUtil.sort(fixes));
            for (IOfferingOrFix pkg : pkgs) {
                this.outputPackage(verbosePrefix, pkg);
            }
        }

        protected void outputPackage(String longPrefix, IOfferingOrFix pkg) {
            boolean longListing = this.cl.containsCommand("-long");
            boolean showFeatures = this.cl.containsCommand("-features");
            boolean showRollbackVersions = this.cl.containsCommand("-rollbackVersions");
            boolean showPlatforms = this.cl.containsCommand("-showPlatforms");
            boolean showUpdateFromVersion = this.cl.containsCommand("-showUpdateFromVersion");
            if (longListing) {
                this.output.appendNT(longPrefix, " : ");
            }
            this.output.appendNT(pkg.getIdentity().getId(), "_", pkg.getVersion().toString());
            if (longListing) {
                this.output.appendNT(" : ", pkg.getName(), " : ", OfferingUtil.getDisplayableVersion(pkg));
            }
            if (showFeatures && pkg instanceof IOffering) {
                this.outputFeatures((IOffering)pkg);
            }
            if (showPlatforms && pkg instanceof IOffering) {
                this.outputPlatforms((IOffering)pkg);
            }
            if (showUpdateFromVersion && pkg instanceof IOffering) {
                this.outputUpdateInfo((IOffering)pkg);
            }
            if (showRollbackVersions && pkg instanceof IOffering) {
                this.outputRollbackVersions((IOffering)pkg);
            }
            this.output.nl();
        }

        protected void outputFeatures(IOffering offering) {
            List<IFeature> features = offering.getFilteredFeatures(null);
            this.output.appendNT(" : ", Util.toFeatureIdString(features));
        }

        protected void outputPlatforms(IOffering offering) {
            MapSet<String, String> supportedPlatforms = OfferingUtil.getAllSupportedPlatforms(offering);
            this.output.appendNT(" : ", Util.toPlatformString(supportedPlatforms));
        }

        protected void outputUpdateInfo(IOffering offering) {
            Version version = UpdateOfferingUtils.getBaseOfferingVersion(offering);
            if (version == null) {
                version = Version.emptyVersion;
            }
            this.output.appendNT(" : ", version.toString());
        }

        protected void outputRollbackVersions(IOffering offering) {
            this.output.appendNT(" : ", "");
        }
    }
}

