/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.ConsolePromptRepositoryUtils;
import com.ibm.cic.common.core.cmd.SilentRepositoryUtils;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.internal.IdAndVersion;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class CmdRepositoryUtils {
    static List<IOffering> getAllOfferingsAndUpdates(IRepository repo, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            List offerings = repo.getAllOfferings((IProgressMonitor)sm.newChild(1, 0));
            ArrayList<IOffering> list = new ArrayList<IOffering>(offerings);
            list.addAll(repo.getAllUpdates(null, null, (IProgressMonitor)sm.newChild(1, 0)));
            ArrayList<IOffering> arrayList = list;
            return arrayList;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    static IRepository openSourceRepository(ACmdLine cl, IRepositoryGroup group, String location, IProgressMonitor monitor) throws CoreException {
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository(group, location);
        return CmdRepositoryUtils.openExistingRepository(cl, group, repInfo, monitor);
    }

    static IRepository openPPA(ACmdLine cl, IRepositoryGroup group, IProgressMonitor monitor) throws CoreException {
        String location = CommonDef.Urls.EntitledRepositoryUrl;
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository(group, Messages.CmdRepositoryUtils_PassportAdvantageName, "CompositeRepository", "0.0.0.1", location, null);
        return CmdRepositoryUtils.openExistingRepository(cl, group, repInfo, monitor);
    }

    private static IRepository openExistingRepository(ACmdLine cl, IRepositoryGroup group, IRepositoryInfo repInfo, IProgressMonitor monitor) throws CoreException {
        String msg = NLS.bind((String)Messages.CmdRepositoryUtils_progressOpeningRepo, (Object)repInfo.getLocation());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)1);
        try {
            boolean shouldPrompt = cl.containsCommand("-prompt");
            if (shouldPrompt) {
                IRepository iRepository = ConsolePromptRepositoryUtils.openExistingRepository(group, repInfo, (IProgressMonitor)sm.newChild(1, 0));
                return iRepository;
            }
            boolean staySecure = true;
            try {
                IRepository iRepository = SilentRepositoryUtils.silentOpenExistingRepository(staySecure, group, repInfo, (IProgressMonitor)sm.newChild(1, 0));
                return iRepository;
            }
            catch (CoreException e) {
                IStatus status = CmdRepositoryUtils.modifyKeyringTipOffToPromptAsNeeded(cl, e.getStatus());
                if (status != e.getStatus()) {
                    throw new CoreException(status);
                }
                throw e;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean supportsArg(ACmdLine cl, String arg) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cl.getCommandLineData()));
        args.add(arg);
        IStatus status = cl.canLoadCommandLine(args.toArray(new String[args.size()]));
        return status.isOK();
    }

    private static IStatus modifyKeyringTipOffToPromptAsNeeded(ACmdLine cl, IStatus status) {
        if (CmdRepositoryUtils.supportsArg(cl, "-prompt")) {
            status = StatusCodes.replaceKeyringTipOffWhenPromptParameterAvailable(status);
        }
        return status;
    }

    public static boolean useServiceRepositoryCmd(ACmdLine cl) {
        return cl.containsCommand("-useServiceRepository");
    }

    static boolean usePassportAdvantageCmdOrPref(ACmdLine cl) {
        return cl.containsCommand("-connectPassportAdvantage") || CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED.key());
    }

    static IStatus openServiceRepositories(IOpenServiceRepoHandler openServiceRepoHandler, ACmdLine cl, IRepositoryGroup group, IOffering[] offerings, IProgressMonitor monitor) {
        IStatus status = CmdRepositoryUtils.openServiceRepositories(cl, group, offerings, monitor);
        return openServiceRepoHandler.onOpenServiceRepository(status);
    }

    private static IStatus openServiceRepositories(ACmdLine cl, IRepositoryGroup group, IOffering[] offerings, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CmdRepositoryUtils_progressOpeningServiceRepos, (int)1);
        try {
            boolean shouldPrompt = cl.containsCommand("-prompt");
            if (shouldPrompt) {
                IStatus iStatus = ConsolePromptRepositoryUtils.openServiceRepositories(group, offerings, (IProgressMonitor)sm.newChild(1, 0));
                return iStatus;
            }
            boolean staySecure = true;
            CicMultiStatus status = SilentRepositoryUtils.openServiceRepositories(staySecure, group, offerings, (IProgressMonitor)sm.newChild(1, 0));
            if (!status.isOK()) {
                status = StatusCodes.replaceKeyringTipOffWhenPromptParameterAvailable(status);
            }
            CicMultiStatus cicMultiStatus = status;
            return cicMultiStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static IStatus openServiceRepositories(ACmdLine cl, IRepositoryGroup group, IIdentity offeringId, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            List<IOffering> offerings = CmdRepositoryUtils.getOfferingsWithId(group, offeringId, (IProgressMonitor)sm.newChild(1, 0));
            if (offerings.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IOffering[] array = offerings.toArray(new IOffering[offerings.size()]);
            IStatus iStatus = CmdRepositoryUtils.openServiceRepositories(cl, group, array, (IProgressMonitor)sm.newChild(1, 0));
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static List<IOffering> getOfferingsWithId(IRepositoryGroup repoGroup, IIdentity id, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            List offerings = repoGroup.getAllOfferings((IProgressMonitor)sm.newChild(1, 0));
            ArrayList<IOffering> result = new ArrayList<IOffering>();
            ArrayList<IOffering> list = new ArrayList<IOffering>(offerings.size());
            for (IOffering offering : offerings) {
                if (!id.equals(offering.getIdentity())) continue;
                list.add(offering);
            }
            result.addAll(list);
            List updateOfferings = repoGroup.getAllUpdates(id, null, (IProgressMonitor)sm.newChild(1, 0));
            result.addAll(updateOfferings);
            ArrayList<IOffering> arrayList = result;
            return arrayList;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IdAndVersion splitPackageIdVersion(String paramStrVal) {
        Object[] idAndVer = SplitIdVersionUtil.splitIdUnderscoreVersion(paramStrVal);
        String idString = (String)idAndVer[0];
        Version version = null;
        if (idAndVer[1] != null) {
            version = (Version)idAndVer[1];
        }
        IdAndVersion iav = new IdAndVersion(new SimpleIdentity(idString), version);
        return iav;
    }

    public static List<IOfferingOrFix> resolveAllContentWithServiceRepo(IOpenServiceRepoHandler openServiceRepoHandler, ACmdLine cl, IRepositoryGroup repoGroup, IIdentity id, Version version, IProgressMonitor monitor) throws CoreException {
        String msg = CmdRepositoryUtils.getResolveProgressMessage(id, version, true);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)2);
        try {
            boolean useServiceRepo = CmdRepositoryUtils.useServiceRepositoryCmd(cl);
            if (useServiceRepo) {
                IStatus status = CmdRepositoryUtils.openServiceRepositories(cl, repoGroup, id, (IProgressMonitor)sm.newChild(1, 0));
                if ((status = openServiceRepoHandler.onOpenServiceRepository(status)).matches(12)) {
                    throw new CoreException(status);
                }
                if (!status.isOK() && version == null) {
                    List<IOfferingOrFix> list = Collections.emptyList();
                    return list;
                }
            } else {
                sm.worked(1);
            }
            ArrayList allContentList = new ArrayList();
            Collection repositories = repoGroup.getRepositories();
            sm.setWorkRemaining(repositories.size());
            for (IRepository repo : repositories) {
                allContentList.addAll(UpdateOfferingUtils.getAllOfferingsUpdatesAndFixes(repo, (IProgressMonitor)sm.newChild(1, 0)));
            }
            if (version == null) {
                Object latestVerOof = CmdRepositoryUtils.getLatestVersion(id, allContentList);
                if (latestVerOof == null) {
                    List<IOfferingOrFix> list = Collections.emptyList();
                    return list;
                }
                version = latestVerOof.getVersion();
            }
            ArrayList<IOfferingOrFix> matchingContentList = new ArrayList<IOfferingOrFix>();
            for (IOfferingOrFix oof : allContentList) {
                if (!id.equals(oof.getIdentity()) || !version.equals((Object)oof.getVersion())) continue;
                matchingContentList.add(oof);
            }
            ArrayList<IOfferingOrFix> arrayList = matchingContentList;
            return arrayList;
        }
        finally {
            sm.done();
        }
    }

    public static IOfferingOrFix resolveContent(IRepositoryGroup repoGroup, IIdentity id, Version version, IProgressMonitor monitor) {
        boolean includeFixes = true;
        String msg = CmdRepositoryUtils.getResolveProgressMessage(id, version, includeFixes);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)1);
        try {
            IOfferingOrFix iOfferingOrFix = CmdRepositoryUtils.resolveContent(repoGroup, id, version, includeFixes, (IProgressMonitor)sm.newChild(1, 0));
            return iOfferingOrFix;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    static IOffering resolveOffering(IRepositoryGroup repoGroup, IIdentity id, Version version, IProgressMonitor monitor) {
        boolean includeFixes = false;
        String msg = CmdRepositoryUtils.getResolveProgressMessage(id, version, includeFixes);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)1);
        return (IOffering)CmdRepositoryUtils.resolveContent(repoGroup, id, version, includeFixes, (IProgressMonitor)sm);
    }

    private static IOfferingOrFix resolveContent(IRepositoryGroup repoGroup, IIdentity id, Version version, boolean includeFixes, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (version != null) {
            return includeFixes ? UpdateOfferingUtils.findOfferingOrUpdateOrFix(repoGroup, id, version, (IProgressMonitor)sm.newChild(1, 0)) : UpdateOfferingUtils.findOfferingOrUpdate(repoGroup, id, version, (IProgressMonitor)sm.newChild(1, 0));
        }
        sm.setWorkRemaining(includeFixes ? 3 : 2);
        List offerings = repoGroup.getAllOfferings((IProgressMonitor)sm.newChild(1, 0));
        Object latestOfferingOrFix = CmdRepositoryUtils.getLatestVersion(id, offerings);
        List updateOfferings = repoGroup.getAllUpdates(null, null, (IProgressMonitor)sm.newChild(1, 0));
        IOffering latestUpdate = (IOffering)CmdRepositoryUtils.getLatestVersion(id, updateOfferings);
        if (latestUpdate != null && latestUpdate.compareVersion((IContent)latestOfferingOrFix) > 0) {
            latestOfferingOrFix = latestUpdate;
        }
        if (latestOfferingOrFix == null && includeFixes) {
            List fixes = repoGroup.getAllFixes((IProgressMonitor)sm.newChild(1, 0));
            latestOfferingOrFix = CmdRepositoryUtils.getLatestVersion(id, fixes);
        }
        return latestOfferingOrFix;
    }

    private static <T extends IOfferingOrFix> T getLatestVersion(IIdentity id, List<T> list) {
        IOfferingOrFix result = null;
        for (IOfferingOrFix oof : list) {
            if (!id.equals(oof.getIdentity()) || oof.compareVersion(result) <= 0) continue;
            result = oof;
        }
        return (T)result;
    }

    public static IOfferingOrFix resolveOfferingOrFixWithServiceRepo(IOpenServiceRepoHandler openServiceRepoHandler, ACmdLine cl, IRepositoryGroup repoGroup, IIdentity id, Version version, IProgressMonitor monitor) throws CoreException {
        boolean includeFixes = true;
        return CmdRepositoryUtils.resolveWithServiceRepo(openServiceRepoHandler, cl, repoGroup, id, version, includeFixes, monitor);
    }

    private static String getResolveProgressMessage(IIdentity id, Version version, boolean includeFixes) {
        if (version == null) {
            return NLS.bind((String)(includeFixes ? Messages.CmdRepositoryUtils_progressSearchingLatestPackageOrFix : Messages.CmdRepositoryUtils_progressSearchingLatestPackage), (Object)id);
        }
        return NLS.bind((String)(includeFixes ? Messages.CmdRepositoryUtils_progressSearchingPackageOrFix : Messages.CmdRepositoryUtils_progressSearchingPackage), (Object)id, (Object)version);
    }

    private static IOfferingOrFix resolveWithServiceRepo(IOpenServiceRepoHandler openServiceRepoHandler, ACmdLine cl, IRepositoryGroup repoGroup, IIdentity id, Version version, boolean includeFixes, IProgressMonitor monitor) throws CoreException {
        String msg = CmdRepositoryUtils.getResolveProgressMessage(id, version, includeFixes);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)3);
        try {
            IOfferingOrFix content = null;
            boolean useServiceRepo = CmdRepositoryUtils.useServiceRepositoryCmd(cl);
            if (version != null || !useServiceRepo) {
                content = CmdRepositoryUtils.resolveContent(repoGroup, id, version, includeFixes, (IProgressMonitor)sm.newChild(1, 0));
            } else {
                sm.worked(1);
            }
            if (content == null && useServiceRepo) {
                IStatus status = CmdRepositoryUtils.openServiceRepositories(cl, repoGroup, id, (IProgressMonitor)sm.newChild(1, 0));
                if ((status = openServiceRepoHandler.onOpenServiceRepository(status)).matches(12)) {
                    throw new CoreException(status);
                }
                if (status.isOK()) {
                    content = CmdRepositoryUtils.resolveContent(repoGroup, id, version, includeFixes, (IProgressMonitor)sm.newChild(1, 0));
                } else {
                    sm.worked(1);
                }
            } else {
                sm.worked(2);
            }
            if (content == null) {
                throw new CoreException(CmdRepositoryUtils.getFailedToFindPackageError(id, version));
            }
            IOfferingOrFix iOfferingOrFix = content;
            return iOfferingOrFix;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IStatus getFailedToFindPackageError(IIdentity id, Version version) {
        ICicStatus status = version == null ? Statuses.ERROR.get(Messages.CmdRepositoryUtils_failFindPackage, id) : Statuses.ERROR.get(Messages.CmdRepositoryUtils_failFindPackage1, id, version);
        return status;
    }

    public static interface IOpenServiceRepoHandler {
        public IStatus onOpenServiceRepository(IStatus var1);
    }
}

