/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdManager;
import com.ibm.cic.common.core.cmd.ACmdParam;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdParameters {
    private final ACmdParam templateParam;
    private final List<ACmdParam> parameters;
    private final int minParams;
    private final int maxParams;

    public CmdParameters(ACmdParam parameter) {
        this(parameter, 1, 1);
    }

    public CmdParameters(ACmdParam parameter, int minParams) {
        this(parameter, minParams, Integer.MAX_VALUE);
    }

    public CmdParameters(ACmdParam templateParam, int minParams, int maxParams) {
        this.minParams = minParams;
        this.maxParams = maxParams;
        this.templateParam = templateParam;
        this.parameters = this.maxParams == 0 ? Collections.emptyList() : new ArrayList(Math.min(maxParams, 8));
    }

    CmdParameters(CmdParameters original) {
        this(original.templateParam, original.minParams, original.maxParams);
    }

    void reset() {
        this.parameters.clear();
    }

    IStatus loadCommandLineData(ACmdManager cm, CmdIterator cmdData) {
        this.parameters.clear();
        while (cmdData.hasMoreArgs() && this.parameters.size() < this.maxParams && (this.maxParams <= 1 || cm.getRegisteredCommand(cmdData.getCurrentArg()) == null)) {
            ACmdParam param = this.templateParam.makeCopy();
            IStatus status = param.loadCommandLineData(cm, cmdData);
            if (!status.isOK()) {
                return status;
            }
            this.parameters.add(param);
        }
        if (this.parameters.size() < this.minParams) {
            return new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 8005, NLS.bind(Messages.Cmd_Error_Incorrect_Parameter_Nr, (Object)this.minParams, (Object)this.parameters.size()), null);
        }
        return Status.OK_STATUS;
    }

    String getParamStrVal(int i) {
        assert (i == 0);
        assert (this.maxParams == 1);
        return this.parameters.isEmpty() ? null : this.parameters.get(0).getStrVal();
    }

    Object getParamObjVal(int i) {
        assert (i == 0);
        if (this.maxParams > 1) {
            ArrayList<Object> result = new ArrayList<Object>(this.parameters.size());
            for (ACmdParam param : this.parameters) {
                result.add(param.getObjVal());
            }
            return result;
        }
        assert (this.maxParams == 1);
        return this.parameters.isEmpty() ? null : this.parameters.get(0).getObjVal();
    }

    boolean setParamVal(int i, String val) {
        assert (i == 0);
        assert (this.maxParams == 1);
        if (!this.parameters.isEmpty()) {
            this.parameters.get(0).setStrValue(val);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    String getId() {
        return this.templateParam.id();
    }

    String getHeaderInfo() {
        return this.templateParam.getHeaderInfo();
    }
}

