/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdParam;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdParamEnum
extends ACmdParam {
    private final String[] allowedValues;

    public CmdParamEnum(String id, String ... allowedValues) {
        super(id, null);
        this.allowedValues = allowedValues;
    }

    @Override
    protected IStatus loadCommandLineData(CmdIterator cmdData, boolean testOnly) {
        String allowedValue;
        String arg = cmdData.getCurrentArg();
        if (!testOnly) {
            cmdData.consumeCurrentArg();
        }
        if ((allowedValue = this.checkAllowedValue(arg)) == null) {
            return Statuses.ERROR.get(8002, Messages.Cmd_Error_Unmatching_parameter_value, this.id(), arg, this.allowedValuesString());
        }
        this.setStrValue(allowedValue);
        return Status.OK_STATUS;
    }

    @Override
    public CmdParamEnum makeCopy() {
        return new CmdParamEnum(this.id(), this.allowedValues);
    }

    @Override
    public String getHeaderInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id()).append("    ").append(Messages.Cmd_CommandArgAllowedValues).append(this.allowedValuesString());
        if (this.getHeader() != null) {
            sb.append("\n").append("            ").append(this.getHeader());
        }
        return sb.toString();
    }

    private String allowedValuesString() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.allowedValues;
        int n = this.allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedValue = stringArray[n2];
            sb.append("  ").append(allowedValue);
            ++n2;
        }
        return sb.toString();
    }

    private String checkAllowedValue(String arg) {
        String[] stringArray = this.allowedValues;
        int n = this.allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedValue = stringArray[n2];
            if (allowedValue.equalsIgnoreCase(arg)) {
                return allowedValue;
            }
            ++n2;
        }
        return null;
    }
}

