/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.utils.IndentWriter;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ElementHolder {
    private Object errorObject;
    private ElementHolder parentHolder;
    private final Map<IHasHREF, ElementHolder> resolvedReferenced = new HashMap<IHasHREF, ElementHolder>();
    private final Map<ElementHolder, Update> holderUpdates = new LinkedHashMap<ElementHolder, Update>();

    protected ElementHolder(ElementHolder parentHolder) {
        this.parentHolder = parentHolder;
    }

    public ElementHolder getParentHolder() {
        return this.parentHolder;
    }

    private ElementHolder releaseParentHolder() {
        ElementHolder ph = this.parentHolder;
        this.parentHolder = null;
        return ph;
    }

    public abstract String getHolderUserString();

    Object getErrorObject() {
        return this.errorObject;
    }

    void setErrorObject(Object errorObject) {
        this.errorObject = errorObject;
    }

    public abstract String getLocation();

    protected ElementHolder getOpenHolder(IHasHREF ref) {
        return this.resolvedReferenced.get(ref);
    }

    void closeHolder() {
        IHasHREF href;
        ElementHolder ph = this.getParentHolder();
        if (ph != null && (href = ph.getReferenceTo(this)) != null) {
            ph.resolvedReferenced.remove(href);
            this.releaseParentHolder();
        }
    }

    private IHasHREF getReferenceTo(ElementHolder eh) {
        for (Map.Entry<IHasHREF, ElementHolder> me : this.resolvedReferenced.entrySet()) {
            if (me.getValue() != eh) continue;
            return me.getKey();
        }
        return null;
    }

    protected ElementHolder resolveRef(IDownloadSession session, IHasHREF ref, IProgressMonitor monitor) throws IOException, CoreException {
        if (ref == null) {
            throw new NullPointerException();
        }
        ElementHolder eh = this.getOpenHolder(ref);
        if (eh == null) {
            eh = this.doResolveRef(session, ref, monitor);
            this.resolvedReferenced.put(ref, eh);
        }
        return eh;
    }

    protected abstract ElementHolder doResolveRef(IDownloadSession var1, IHasHREF var2, IProgressMonitor var3) throws IOException, CoreException;

    protected static String getLocation(Object holder) {
        URLElementHolder urlHolder;
        URL url;
        if (holder instanceof URLElementHolder && (url = (urlHolder = (URLElementHolder)holder).getURL()) != null) {
            return url.toString();
        }
        if (holder instanceof PathElementHolder) {
            PathElementHolder pathHolder = (PathElementHolder)holder;
            return pathHolder.getPath().toString();
        }
        throw new AssertionError();
    }

    static Object getRootObject(IElementHasContainer hasContainer) {
        IElementHasContainer current = hasContainer;
        while (current.getContainerObject() != null) {
            Object objContainer = current.getContainerObject();
            if (objContainer instanceof ElementHolder) {
                ElementHolder holder = (ElementHolder)objContainer;
                return holder;
            }
            if (objContainer instanceof IElementHasContainer) {
                current = (IElementHasContainer)objContainer;
                continue;
            }
            return objContainer;
        }
        return current;
    }

    private static ElementHolder getRootHolder(ElementHolder holder) {
        while (holder.getParentHolder() != null) {
            holder = holder.getParentHolder();
        }
        return holder;
    }

    static ElementHolder getRootHolder(IElementHasContainer element) {
        ElementHolder holder = ElementHolder.getHolder(element);
        if (holder != null) {
            return ElementHolder.getRootHolder(holder);
        }
        return null;
    }

    static ElementHolder getHolder(IElementHasContainer hasContainer) {
        Object rootObject = ElementHolder.getRootObject(hasContainer);
        if (rootObject instanceof ElementHolder) {
            ElementHolder holder = (ElementHolder)rootObject;
            return holder;
        }
        return null;
    }

    private static IElementHasContainer asElementHasContainer(Object obj) {
        if (obj instanceof IElementHasContainer) {
            return (IElementHasContainer)obj;
        }
        return null;
    }

    static IElementHasContainer getContainer(Object obj, boolean resolve, boolean gotoRefsContainer) {
        IElementHasContainer hasContainer = ElementHolder.asElementHasContainer(obj);
        Object container = obj;
        if (hasContainer != null) {
            container = hasContainer.getContainerObject();
        }
        if (container instanceof ElementHolder) {
            ElementHolder holder = (ElementHolder)container;
            ElementHolder parentHolder = holder.getParentHolder();
            if (parentHolder == null) {
                return null;
            }
            IHasHREF ref = parentHolder.getReferenceTo(holder);
            if (ref != null) {
                if (gotoRefsContainer) {
                    return ElementHolder.asElementHasContainer(ref.getContainerObject());
                }
                return ref;
            }
        }
        return ElementHolder.asElementHasContainer(container);
    }

    private static void recordUpdate(ElementHolder updateHolder, ElementHolder holder, int flags) {
        Update update = updateHolder.holderUpdates.get(holder);
        if (update == null) {
            update = new Update(flags | 0x10);
            updateHolder.holderUpdates.put(holder, update);
        } else {
            update.addFlags(flags);
        }
        ElementHolder grandParent = updateHolder.getParentHolder();
        if (grandParent != null) {
            ElementHolder.recordUpdate(grandParent, updateHolder, 32);
        } else if (updateHolder != holder) {
            ElementHolder.recordUpdate(updateHolder, updateHolder, 32);
        }
    }

    static void recordRemoveElements(ElementHolder holder) {
        ElementHolder.recordUpdate(holder, holder, 2);
    }

    static void recordAddElements(ElementHolder holder) {
        ElementHolder.recordUpdate(holder, holder, 1);
    }

    static void recordModifiedElements(ElementHolder holder) {
        ElementHolder.recordUpdate(holder, holder, 4);
    }

    Update getHolderUpdate(ElementHolder holder) {
        return this.holderUpdates.get(holder);
    }

    public abstract void dump(IndentWriter var1, boolean var2);

    static interface IElementHasContainer {
        public Object getContainerObject();

        public Object releaseContainer();
    }

    public static interface IHasHREF
    extends IElementHasContainer {
        public String getHREF();

        public IContentInfo getContentInfo();
    }

    static interface PathElementHolder {
        public IPath getPath();
    }

    static interface URLElementHolder {
        public URL getURL();
    }

    static class Update {
        public static final int FLAG_ADDED_ELEMENTS = 1;
        public static final int FLAG_REMOVED_ELEMENTS = 2;
        public static final int FLAG_MODIFIED_ELEMENTS = 4;
        public static final int FLAG_CHANGED_ELEMENTS = 7;
        public static final int FLAG_NEW_HOLDER = 16;
        public static final int FLAG_SUB_HOLDER_MODIFIED = 32;
        int flags;

        Update(int flags) {
            this.flags = flags;
        }

        public int addFlags(int orCombinedFlags) {
            this.flags |= orCombinedFlags;
            return this.flags;
        }

        private boolean matches(int orCombinedFlags) {
            return (this.flags & orCombinedFlags) != 0;
        }

        public boolean hasChanges() {
            return this.matches(55);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.matches(1)) {
                sb.append("ADDED ");
            }
            if (this.matches(2)) {
                sb.append("REMOVED ");
            }
            if (this.matches(4)) {
                sb.append("MODIFIED ");
            }
            if (this.matches(16)) {
                sb.append("NEW_HOLDER ");
            }
            if (this.matches(32)) {
                sb.append("SUB_HOLDER_MODIFIED ");
            }
            if (sb.length() == 0) {
                sb.append("NO CHANGES");
            }
            return sb.toString();
        }
    }
}

