/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.internal.volrepo.VolumeArtifactRepository;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import java.util.List;

public class DiskSet
implements IVolumeAccessByDisk.IDiskSet {
    private final String id;
    private String label;
    private int diskCount;

    public DiskSet(String id, String label, int diskCount) {
        this.id = id;
        this.label = label;
        this.diskCount = diskCount;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDiskCount(int diskCount) {
        this.diskCount = diskCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DiskSet) {
            DiskSet other = (DiskSet)o;
            return other.id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getDiskCount() {
        return this.diskCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("diskSet ");
        sb.append(this.id);
        sb.append(" diskCount=");
        sb.append(this.diskCount);
        if (this.label != null && this.label.length() > 0) {
            sb.append(" diskLabel is known");
        } else {
            sb.append(" diskLabel is unknown");
        }
        return sb.toString();
    }

    @Override
    public IVolumeAccessByDisk.IDiskSetDisks useDisks(int[] usedDisks) {
        VolumeAtocUtil.OrderedDisks used = new VolumeAtocUtil.OrderedDisks();
        int[] nArray = usedDisks;
        int n = usedDisks.length;
        int n2 = 0;
        while (n2 < n) {
            int diskIndex = nArray[n2];
            used.addDisk(this, diskIndex);
            ++n2;
        }
        return new VolumeArtifactRepository.DiskSetDisks(this, used);
    }

    @Override
    public IVolumeAccessByDisk.IDiskSetDisks useDisks(Integer[] usedDisks) {
        VolumeAtocUtil.OrderedDisks used = new VolumeAtocUtil.OrderedDisks();
        Integer[] integerArray = usedDisks;
        int n = usedDisks.length;
        int n2 = 0;
        while (n2 < n) {
            Integer diskIndex = integerArray[n2];
            used.addDisk(this, diskIndex);
            ++n2;
        }
        return new VolumeArtifactRepository.DiskSetDisks(this, used);
    }

    public IVolumeAccessByDisk.IDiskSetDisks useDisks(List usedDisks) {
        VolumeAtocUtil.OrderedDisks used = new VolumeAtocUtil.OrderedDisks();
        for (IVolumeAccessByDisk.IDisk disk : usedDisks) {
            assert (disk.getDiskSet().equals(this));
            used.addDisk(disk);
        }
        return new VolumeArtifactRepository.DiskSetDisks(this, used);
    }

    @Override
    public IVolumeAccessByDisk.IDiskSetDisks useDisks() {
        VolumeAtocUtil.OrderedDisks used = new VolumeAtocUtil.OrderedDisks();
        return new VolumeArtifactRepository.DiskSetDisks(this, used);
    }

    @Override
    public IVolumeAccessByDisk.IDiskSetDisks useAllDisks() {
        VolumeAtocUtil.OrderedDisks used = new VolumeAtocUtil.OrderedDisks();
        int i = 0;
        while (i < this.diskCount) {
            used.addDisk(this, i);
            ++i;
        }
        return new VolumeArtifactRepository.DiskSetDisks(this, used);
    }
}

