/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ContentInfoUtil {
    public static boolean equalDigests(IContentInfo a, IContentInfo b) {
        Set<DigestValue> digestsA = a.getDigestSet();
        Set<DigestValue> digestsB = b.getDigestSet();
        return digestsA.equals(digestsB);
    }

    public static boolean isEqual(byte[] d1, byte[] d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        if (d1.length != d2.length) {
            return false;
        }
        int i = 0;
        while (i < d1.length) {
            if (d1[i] != d2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validate(boolean okForMissingDigests, IContentInfo expected, IContentInfo actual, SimpleContentInfo validated) {
        if (expected == null) {
            throw new NullPointerException();
        }
        if (actual == null) {
            throw new NullPointerException();
        }
        List<String> expectedAlgorithms = expected.getDigestAlgorithms();
        ArrayList<MessageDigestComparison> list = new ArrayList<MessageDigestComparison>(expectedAlgorithms.size());
        int i = 0;
        while (i < expectedAlgorithms.size()) {
            String expectedAlg = expectedAlgorithms.get(i);
            DigestValue actualDigest = actual.getDigestValue(expectedAlg);
            if (actualDigest != null) {
                MessageDigestComparison cmp = new MessageDigestComparison(expectedAlg, expected.getDigestValue(expectedAlg), actualDigest);
                if (!cmp.isEqual()) {
                    return new DigestMismatchStatus(cmp);
                }
                list.add(cmp);
            }
            ++i;
        }
        if (list.isEmpty()) {
            if (okForMissingDigests) {
                return IStatusCodes.STATUS_OK_VALIDATION_NO_DIGESTS_AVAILABLE;
            }
            String msg = Messages.digest_validation_no_digest_available;
            return Statuses.WARNING.get(IStatusCodes.STATUS_OK_VALIDATION_NO_DIGESTS_AVAILABLE.getCode(), msg, new Object[0]);
        }
        if (validated != null) {
            for (MessageDigestComparison cmp : list) {
                validated.setDigestValue(cmp.getDigest1());
            }
        }
        return IStatusCodes.STATUS_OK_VALIDATION_DIGESTS_VALIDATED;
    }

    public static IContentInfo union(IContentInfo expectedContentInfo, IContentInfo contentInfo) {
        if (expectedContentInfo.getAvailableDigestsCount() == 0) {
            return contentInfo;
        }
        if (contentInfo.getAvailableDigestsCount() == 0) {
            return expectedContentInfo;
        }
        SimpleContentInfo sci = new SimpleContentInfo(expectedContentInfo);
        Iterator<DigestValue> iterator = contentInfo.getDigests().iterator();
        while (iterator.hasNext()) {
            DigestValue element;
            DigestValue dv = element = iterator.next();
            sci.setDigestValue(dv);
        }
        return sci;
    }

    public static int add(IMutableContentInfo a, IContentInfo b) {
        List<String> algs = b.getDigestAlgorithms();
        int count = 0;
        int i = 0;
        while (i < algs.size()) {
            String alg = algs.get(i);
            DigestValue lhs = a.getDigestValue(alg);
            if (lhs == null) {
                DigestValue digest = b.getDigestValue(alg);
                a.setDigestValue(digest);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static class DigestMismatchStatus
    extends Status
    implements IStatus {
        private final MessageDigestComparison mdc;

        public DigestMismatchStatus(MessageDigestComparison cmp) {
            super(4, Statuses.pluginId, 26, NLS.bind(Messages.digests_unequal, cmp.getAlgorithm(), cmp.getDigest1().getDigestAsString(), cmp.getDigest2().getDigestAsString()), null);
            this.mdc = cmp;
        }

        public MessageDigestComparison getMessageDigestComparison() {
            return this.mdc;
        }
    }

    public static class MessageDigestComparison {
        private final String algorithm;
        private final DigestValue d1;
        private final DigestValue d2;

        public MessageDigestComparison(String algorithm, DigestValue d1, DigestValue d2) {
            this.algorithm = algorithm;
            this.d1 = d1;
            this.d2 = d2;
            assert (d1 != null);
            assert (d2 != null);
        }

        public boolean isEqual() {
            return this.d1.equals(this.d2);
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public DigestValue getDigest1() {
            return this.d1;
        }

        public DigestValue getDigest2() {
            return this.d2;
        }
    }
}

