/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractWriteArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.FileArtifactLocator;
import com.ibm.cic.common.core.internal.repository.DigestTableOfContents;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public abstract class AbstractPathReadArtifactRepository
extends AbstractReadArtifactRepo {
    @Override
    public abstract IRepository getRepository();

    protected abstract IPath getRepositoryPath(IArtifactKey var1) throws CoreException;

    protected abstract IPath getRepositoryPath() throws CoreException;

    @Override
    public IStatus initializeArtifactRepository(IRepositoryInfo repInfo) {
        return super.initializeArtifactRepository(repInfo);
    }

    @Override
    public IStatus doGetArtifactLocator(IArtifactSession session, IArtifact artifact, IContentInfo tocContentInfo, IProgressMonitor monitor, IArtifactLocator[] result) {
        monitor.beginTask("", 1);
        try {
            FileArtifactLocator locator;
            try {
                IPath targetPath = this.getRepositoryPath(artifact.getKey());
                File file = targetPath.toFile();
                SimpleContentInfo contentInfo = tocContentInfo != null ? new SimpleContentInfo(tocContentInfo) : new SimpleContentInfo();
                if (contentInfo.getSize() == Long.MIN_VALUE) {
                    if (tocContentInfo == null) {
                        contentInfo.setSize(file.length());
                    } else {
                        log.status(Statuses.WARNING.get(Messages.AbstractPathReadArtifactRepository_NoSizeRecordedInAtocFor, targetPath));
                    }
                }
                IArtifact locatorArtifact = AbstractWriteArtifactRepo.getArtifactForToc(artifact, contentInfo);
                locator = new FileArtifactLocator(this.getRepository(), locatorArtifact, artifact.getContentInfo(), file);
            }
            catch (CoreException e) {
                IStatus iStatus = AbstractPathReadArtifactRepository.createGetArtifactLocatorError(artifact, e.getStatus(), null);
                monitor.done();
                return iStatus;
            }
            result[0] = locator;
            monitor.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return AbstractPathReadArtifactRepository.readArtifactToc(session, this.getRepository().getRepositoryInfo(), monitor);
    }

    public static IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IRepositoryInfo repoInfo, IProgressMonitor monitor) throws CoreException {
        ArtifactTableOfContents.TocHolder tocHolder;
        Path basepath = new Path(repoInfo.getLocationStr());
        try {
            SplitProgressMonitor spm;
            IContentInfo contentInfo = ContentInfo.EMPTY_CONTENT_INFO;
            ArtifactTableOfContents.Parameters atocParams = AbstractPathReadArtifactRepository.getAtocParameters(repoInfo);
            if (atocParams.supportDigests()) {
                String atocRelativeName;
                TableOfContents.TocEntry tocEntry;
                spm = new SplitProgressMonitor(monitor, 2);
                ICicLocation digestTocLocation = repoInfo.getLocation().append("");
                TableOfContents.Toc toc = DigestTableOfContents.getDigestToc(digestTocLocation, spm.next());
                if (toc != null && (tocEntry = toc.getEntry(atocRelativeName = atocParams.getAtocFilePathAsString())) != null) {
                    contentInfo = tocEntry.getContentInfo();
                }
            } else {
                spm = new SplitProgressMonitor(monitor, 1);
            }
            tocHolder = ArtifactTableOfContents.getToc((IDownloadSession)session, atocParams, (IPath)basepath, contentInfo, spm.next());
        }
        catch (CoreException e) {
            if (e.getStatus().matches(8)) {
                throw e;
            }
            ICicStatus status = Statuses.ERROR.get(120, e, Messages.read_artifact_toc_failed, basepath);
            throw new CoreException((IStatus)status);
        }
        catch (Exception e) {
            ICicStatus status = Statuses.ERROR.get(120, e, Messages.read_artifact_toc_failed, basepath);
            throw new CoreException((IStatus)status);
        }
        return tocHolder;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        throw new AssertionError((Object)"NYI");
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return new IReadArtifactRepo.IArtifactTocCapabilities(){

            @Override
            public boolean isTocSupported() {
                return true;
            }

            @Override
            public String getPreferredDigestAlgorithm() {
                return this.getDigestAlgorithms()[0];
            }

            @Override
            public String[] getDigestAlgorithms() {
                return ContentInfoComputation.getPreferredAlgorithms();
            }
        };
    }
}

