/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.SingleArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.repository.IRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiArtifactOperationOptions
implements IArtifactOperation.IArtifactOperationOptions {
    private final boolean continueOnError;
    private final ArgumentProcessingOrder processingOrder;
    private final OperationFlags operationFlags;
    private final List<ProcessRecordListener> processRecordListeners = Collections.synchronizedList(new ArrayList());
    private ProcessRecordListener fireProcessRecordEvents;

    public static MultiArtifactOperationOptions newContinueOnErrorOptions() {
        return new MultiArtifactOperationOptions(true, null, OperationFlags.DEFAULT);
    }

    static MultiArtifactOperationOptions newBreakOnErrorOptions() {
        return new MultiArtifactOperationOptions(false, null, OperationFlags.DEFAULT);
    }

    public MultiArtifactOperationOptions(boolean continueOnError, ArgumentProcessingOrder processingOrder, OperationFlags operationFlags) {
        this.continueOnError = continueOnError;
        this.processingOrder = processingOrder;
        this.operationFlags = operationFlags;
    }

    public boolean getContinueOnError() {
        return this.continueOnError;
    }

    public void addListener(ProcessRecordListener callback) {
        this.processRecordListeners.add(callback);
    }

    public void removeListener(ProcessRecordListener callback) {
        this.processRecordListeners.remove(callback);
    }

    ProcessRecordListener getFireEvents() {
        if (this.fireProcessRecordEvents == null) {
            this.fireProcessRecordEvents = new ProcessRecordListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBeforeUseDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
                    List list = MultiArtifactOperationOptions.this.processRecordListeners;
                    synchronized (list) {
                        for (ProcessRecordListener cb : MultiArtifactOperationOptions.this.processRecordListeners) {
                            cb.onBeforeUseDisk(repo, disk, allUsedDisks, diskArgs);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onUsedDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
                    List list = MultiArtifactOperationOptions.this.processRecordListeners;
                    synchronized (list) {
                        for (ProcessRecordListener cb : MultiArtifactOperationOptions.this.processRecordListeners) {
                            cb.onUsedDisk(repo, disk, allUsedDisks, diskArgs);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBeforeRecord(MultiArtifactOperationOptions options, IArtifactOperation.IArtifactOperationRecord record) {
                    List list = MultiArtifactOperationOptions.this.processRecordListeners;
                    synchronized (list) {
                        for (ProcessRecordListener cb : MultiArtifactOperationOptions.this.processRecordListeners) {
                            cb.onBeforeRecord(options, record);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onProcessedRecord(MultiArtifactOperationOptions options, IMultiArtifactOperationArguments multiArgs, IArtifactOperation.IArtifactOperationRecord record, boolean processed) {
                    List list = MultiArtifactOperationOptions.this.processRecordListeners;
                    synchronized (list) {
                        for (ProcessRecordListener cb : MultiArtifactOperationOptions.this.processRecordListeners) {
                            cb.onProcessedRecord(options, multiArgs, record, processed);
                        }
                    }
                }
            };
        }
        return this.fireProcessRecordEvents;
    }

    ArgumentProcessingOrder getProcessingOrder() {
        return this.processingOrder;
    }

    public OperationFlags getOperationFlags() {
        return this.operationFlags;
    }

    public SingleArtifactOperationOptions getSingleArtifactOptions() {
        return null;
    }

    public static class ArgumentProcessingOrder {
        private final String name;
        public static final ArgumentProcessingOrder NATURAL_ORDER = new ArgumentProcessingOrder("NATURAL_ORDER");
        public static final ArgumentProcessingOrder OPTIMIZE_TIME = new ArgumentProcessingOrder("OPTIMIZE_TIME");

        private ArgumentProcessingOrder(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class OperationFlags {
        public static final int FLAG_UPDATE_FILES = 1;
        public static final int FLAG_UPDATE_ATOC = 2;
        public static final int DEFAULT_FLAGS = 3;
        public static final OperationFlags DEFAULT = new OperationFlags(3);
        public static final OperationFlags UPDATE_FILES = new OperationFlags(1);
        public static final OperationFlags UPDATE_ATOC = new OperationFlags(2);
        private final int flags;

        private OperationFlags(int flags) {
            this.flags = flags;
        }

        boolean matches(int orCombinedFlags) {
            return (this.flags & orCombinedFlags) != 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.matches(1)) {
                sb.append("UPDATE_FILES|");
            }
            if (this.matches(2)) {
                sb.append("UPDATE_ATOC");
            }
            return sb.toString();
        }
    }

    public static abstract class ProcessRecordListener {
        public void onBeforeUseDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
        }

        public void onUsedDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
        }

        public void onBeforeRecord(MultiArtifactOperationOptions options, IArtifactOperation.IArtifactOperationRecord record) {
        }

        public void onProcessedRecord(MultiArtifactOperationOptions options, IMultiArtifactOperationArguments multiArgs, IArtifactOperation.IArtifactOperationRecord record, boolean processed) {
        }
    }
}

