/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SystemConfig
extends Hashtable {
    public static final int RAW = 10;
    public static final int ASN1 = 11;
    public static final int UNCOMPRESSED = 4;
    public static final int COMPRESSED = 2;
    public static final int HYBRID = 6;
    public static final int SB = 16;
    public static final int ANSI = 32;
    public static final int EXPAND = 1;
    public static final int HASH = 17;
    public static final int NOHASH = 18;
    public static final String ECDSA = "ECDSA";
    public static final String ECDH = "ECDH";
    public static final String ECMQV = "ECMQV";
    public static final String ECES = "ECES";
    public static final String ECAES = "ECAES";
    private static final String a = "format.";
    private static final String new = "conformance.";
    private static final String do = "curve.";
    private static final String if = "compression.";
    private static final String int = "hash.";
    private static SystemConfig for = new SystemConfig();

    private SystemConfig() {
        this.put("format.global", new Integer(10));
        this.put("conformance.global", new Integer(16));
        this.put("compression.global", new Integer(2));
        this.put("hash.global", new Integer(17));
        this.put("curve.global", "sect163k1");
    }

    public static SystemConfig getConfig() {
        return for;
    }

    public static SystemConfig getConfig(InputStream inputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        if (!(object instanceof SystemConfig)) {
            throw new IOException("not a system config file.");
        }
        for = (SystemConfig)object;
        return for;
    }

    public int getConformance() {
        Object v = this.get("conformance.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global conformance.");
    }

    public int getConformance(String string) {
        Object v = this.get(new + string);
        if (v != null) {
            return (Integer)v;
        }
        return this.getConformance();
    }

    public String getCurve() {
        Object v = this.get("curve.global");
        if (v != null) {
            return new String((String)v);
        }
        throw new IllegalStateException("no global curve.");
    }

    public String getCurve(String string) {
        Object v = this.get(do + string);
        if (v != null) {
            return new String((String)v);
        }
        return this.getCurve();
    }

    public int getFormat() {
        Object v = this.get("format.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global format.");
    }

    public int getFormat(String string) {
        Object v = this.get(a + string);
        if (v != null) {
            return (Integer)v;
        }
        return this.getFormat();
    }

    public int getHashType() {
        Object v = this.get("hash.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global hash-type.");
    }

    public int getPtCompression() {
        Object v = this.get("compression.global");
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalStateException("no global compression.");
    }

    public int getPtCompression(String string) {
        Object v = this.get(if + string);
        if (v != null) {
            return (Integer)v;
        }
        return this.getPtCompression();
    }

    public void setConformance(int n) {
        switch (n) {
            case 16: 
            case 32: {
                this.put("conformance.global", new Integer(n));
                break;
            }
            default: {
                throw new IllegalStateException("conformance unknown.");
            }
        }
    }

    public void setCurve(String string) {
        if (string == null) {
            throw new IllegalArgumentException("curve is null.");
        }
        this.put("curve.global", new String(string));
    }

    public void setFormat(int n) {
        switch (n) {
            case 10: 
            case 11: {
                this.put("format.global", new Integer(n));
                break;
            }
            default: {
                throw new IllegalStateException("format unknown.");
            }
        }
    }

    public void setHashType(int n) {
        switch (n) {
            case 17: 
            case 18: {
                this.put("hash.global", new Integer(n));
                break;
            }
            default: {
                throw new IllegalStateException("conformance unknown.");
            }
        }
    }

    public void setPtCompression(int n) {
        switch (n) {
            case 2: 
            case 4: 
            case 6: {
                this.put("compression.global", new Integer(n));
                break;
            }
            default: {
                throw new IllegalStateException("compression unknown.");
            }
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
    }
}

