/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.spec.PointSpec;

public abstract class FFParameterSpec
implements ECParams {
    protected int size;
    protected byte[] a;
    protected byte[] b;
    protected byte[] seed;
    protected byte[] GPatX;
    protected byte[] GPatY;
    protected byte[] po;
    protected int cf;
    protected String curveName;
    protected String curveOID;

    protected FFParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n, int n2, String string, String string2) {
        if (byArray == null || byArray2 == null || byArray4 == null || byArray5 == null || byArray6 == null) {
            throw new NullPointerException("parameter(s) cannot be null!");
        }
        this.size = n2;
        n2 = (n2 + 7) / 8;
        this.a = this.copy(byArray, 0, byArray.length, n2);
        this.b = this.copy(byArray2, 0, byArray2.length, n2);
        if (byArray3 != null) {
            this.seed = this.copy(byArray3, 0, byArray3.length, -1);
        }
        this.GPatX = this.copy(byArray4, 0, byArray4.length, n2);
        this.GPatY = this.copy(byArray5, 0, byArray5.length, n2);
        this.po = this.copy(byArray6, 0, byArray6.length, -1);
        this.cf = n;
        this.curveName = string;
        this.curveOID = string2;
    }

    protected final byte[] copy(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null || byArray.length - n < n2) {
            throw new IllegalArgumentException("parameter(s) relating to input buffer invalid");
        }
        int n4 = n2;
        while (n2 > 0 && byArray[n] == 0) {
            ++n;
            --n2;
        }
        if (n2 == 0) {
            return new byte[n4];
        }
        if (n3 == -1) {
            n3 = n2;
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("output buffer is too small.");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, n3 - n2, n2);
        return byArray2;
    }

    public boolean equals(Object object) {
        if (object instanceof FFParameterSpec) {
            FFParameterSpec fFParameterSpec = (FFParameterSpec)object;
            return this.size == fFParameterSpec.size && this.cf == fFParameterSpec.cf && this.same(this.a, fFParameterSpec.a) && this.same(this.b, fFParameterSpec.b) && this.same(this.GPatX, fFParameterSpec.GPatX) && this.same(this.GPatY, fFParameterSpec.GPatY) && this.same(this.po, fFParameterSpec.po);
        }
        return false;
    }

    public byte[] getA() {
        return this.copy(this.a, 0, this.a.length, -1);
    }

    public byte[] getB() {
        return this.copy(this.b, 0, this.b.length, -1);
    }

    public int getCofactor() {
        return this.cf;
    }

    public String getName() {
        String string;
        if (this.curveName == null) {
            string = this.getOID();
            if (string == null) {
                string = "ImplicitlyCA";
            }
        } else {
            string = new String(this.curveName);
        }
        return string;
    }

    public String getOID() {
        if (this.curveOID == null) {
            return null;
        }
        return new String(this.curveOID);
    }

    public PointParams getPoint() {
        return new PointSpec(this.GPatX, this.GPatY, this);
    }

    public byte[] getPointOrder() {
        return this.copy(this.po, 0, this.po.length, -1);
    }

    public byte[] getSeed() {
        if (this.seed != null) {
            return this.copy(this.seed, 0, this.seed.length, -1);
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    protected final boolean same(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null array(s)");
        }
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray2.length && byArray2[n2] == 0) {
            ++n2;
        }
        if (byArray.length - n != byArray2.length - n2) {
            return false;
        }
        n = byArray.length - n2;
        n2 = 0;
        while (n-- > 0) {
            if (byArray[byArray.length - ++n2] == byArray2[byArray2.length - n2]) continue;
            return false;
        }
        return true;
    }
}

