/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.util.Random;

public final class HMAC
extends CryptoTransform {
    private CryptoTransform aP;
    private byte[] aO;
    private byte[] aQ;
    private boolean aN;

    public HMAC() {
        super("HMAC");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        try {
            super.init(n, objectArray, random);
            this.aP = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, (String)objectArray[0]);
            this.aP.init(5, null, random);
            int n2 = this.aP.inputSize();
            byte[] byArray = (byte[])objectArray[1];
            if (byArray.length > n2) {
                byArray = this.aP.transform(byArray, 0, byArray.length, true);
                this.aP.init(5, null, random);
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.aO = new byte[n2];
            this.aQ = new byte[n2];
            int n3 = 0;
            while (n3 < this.aO.length) {
                this.aO[n3] = (byte)(0x36 ^ byArray2[n3]);
                this.aQ[n3] = (byte)(0x5C ^ byArray2[n3]);
                ++n3;
            }
        }
        catch (Exception exception) {
            this.reset();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode != 5) {
            throw new IllegalStateException("wrong mode");
        }
        return this.aP.outputSize(n, bl);
    }

    public void reset() {
        super.reset();
        this.aP = null;
        this.aO = null;
        this.aQ = null;
        this.aN = false;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 5) {
            throw new IllegalStateException("wrong mode");
        }
        if (!this.aN) {
            this.aP.transform(this.aO, 0, this.aO.length, false);
            this.aN = true;
        }
        if (byArray != null) {
            this.aP.transform(byArray, n, n2, false);
        }
        if (bl) {
            byte[] byArray3 = this.aP.transform(null, 0, 0, true);
            this.aP.init(5, null, this.rnd);
            this.aP.transform(this.aQ, 0, this.aQ.length, false);
            int n4 = this.aP.transform(byArray3, 0, byArray3.length, byArray2, n3, true);
            this.aP.reset();
            this.aP.init(5, null, this.rnd);
            this.aN = false;
            return n4;
        }
        return 0;
    }
}

