/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DSA
extends CryptoTransform {
    private BigInteger a9;
    private BigInteger a8;
    private CryptoTransform a7;
    private int bc;
    private byte[] bb;
    private byte[][] ba = new byte[4][];
    private CryptoCodec a6;
    private int bd;
    private int a5;

    public DSA() {
        super("DSA");
        this.bc = SystemConfig.getConfig().getHashType();
        this.bd = SystemConfig.getConfig().getFormat();
        this.a5 = SystemConfig.getConfig().getConformance();
        this.a7 = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "SHA-1");
        this.a6 = CryptoCodec.getInstance("DSA", this.bd);
    }

    private static int try(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        if (n == byArray.length) {
            return 0;
        }
        int n2 = (byArray.length - n - 1) * 8;
        int n3 = 7;
        do {
            if ((byArray[n] >>> n3 & 1) != 1) continue;
            n2 += n3 + 1;
            break;
        } while (--n3 >= 0);
        return n2;
    }

    private byte[] char() {
        if (this.bc == 17) {
            this.bb = this.a7.transform(null, 0, 0, true);
        }
        return this.bb;
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n, objectArray, random);
        if (objectArray != null && (n == 1 && random != null || n == 2)) {
            bl = true;
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        this.a7.init(5, null, random);
        this.ba[0] = (byte[])objectArray[0];
        this.ba[1] = (byte[])objectArray[1];
        this.ba[2] = (byte[])objectArray[2];
        this.ba[3] = (byte[])objectArray[3];
        try {
            this.a9 = new BigInteger(1, this.ba[0]);
            this.a8 = new BigInteger(1, this.ba[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("cannot calculate signature.");
        }
    }

    public boolean isVerifiable() {
        return true;
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (!bl || bl && this.mode == 2) {
            return 0;
        }
        if (this.bd == 10) {
            return 40;
        }
        if (this.bd == 11) {
            return 49;
        }
        return 0;
    }

    public void reset() {
        int n;
        super.reset();
        this.a7.reset();
        if (this.bb != null) {
            n = 0;
            while (n < this.bb.length) {
                this.bb[n++] = 0;
            }
            this.bb = null;
        }
        n = 0;
        while (n < this.ba.length) {
            if (this.ba[n] != null) {
                this.ba[n] = null;
            }
            ++n;
        }
        this.a9 = null;
        this.a8 = null;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray != null) {
            if (this.bc == 18) {
                this.bb = new byte[n2];
                System.arraycopy(byArray, n, this.bb, 0, n2);
            } else {
                this.a7.transform(byArray, n, n2, false);
            }
        }
        if (!bl || bl && this.mode == 2) {
            return 0;
        }
        BigInteger bigInteger = new BigInteger(1, this.char()).mod(this.a8);
        CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "DSAKEYGEN");
        cryptoTransform.init(5, new Object[]{this.ba[0], this.ba[1], this.ba[2]}, this.rnd);
        Object[] objectArray = (Object[])cryptoTransform.transformToObject(null, 0, 0, true);
        BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[0]).mod(this.a8);
        BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[1]).mod(this.a9).mod(this.a8);
        BigInteger bigInteger4 = new BigInteger(1, this.ba[3]).mod(this.a8);
        BigInteger bigInteger5 = bigInteger2.modInverse(this.a8).multiply(bigInteger4.multiply(bigInteger3).add(bigInteger)).mod(this.a8);
        byte[] byArray3 = bigInteger3.toByteArray();
        byte[] byArray4 = new byte[20];
        if (byArray3.length == 21) {
            System.arraycopy(byArray3, 1, byArray4, 0, 20);
        } else if (byArray3.length < 20) {
            System.arraycopy(byArray3, 0, byArray4, 20 - byArray3.length, byArray3.length);
        } else if (byArray3.length == 20) {
            byArray4 = byArray3;
        }
        byte[] byArray5 = bigInteger5.toByteArray();
        byte[] byArray6 = new byte[20];
        if (byArray5.length == 21) {
            System.arraycopy(byArray5, 1, byArray6, 0, 20);
        } else if (byArray5.length < 20) {
            System.arraycopy(byArray5, 0, byArray6, 20 - byArray5.length, byArray5.length);
        } else if (byArray5.length == 20) {
            byArray6 = byArray5;
        }
        this.a6.init(1, null);
        this.a6.codecToObject(byArray4, 0, byArray4.length, false);
        Object[] objectArray2 = this.a6.codecToObject(byArray6, 0, byArray6.length, true);
        byte[] byArray7 = (byte[])objectArray2[1];
        if (byArray2.length - n3 < byArray7.length) {
            throw new IllegalArgumentException("output buffer too short.");
        }
        System.arraycopy(byArray7, 0, byArray2, n3, byArray7.length);
        return byArray7.length;
    }

    public boolean verify(byte[] byArray, int n, int n2) {
        if (this.mode != 2) {
            throw new IllegalStateException("wrong mode.");
        }
        this.a6.init(2, null);
        Object[] objectArray = this.a6.codecToObject(byArray, n, byArray.length, true);
        BigInteger bigInteger = new BigInteger(1, this.char()).mod(this.a8);
        BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[1]).mod(this.a8);
        BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[2]).mod(this.a8);
        BigInteger bigInteger4 = bigInteger3.modInverse(this.a8);
        BigInteger bigInteger5 = bigInteger.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger7 = new BigInteger(1, this.ba[2]).mod(this.a9).modPow(bigInteger5, this.a9).multiply(new BigInteger(1, this.ba[3]).mod(this.a9).modPow(bigInteger6, this.a9)).mod(this.a9);
        BigInteger bigInteger8 = bigInteger7.mod(this.a8);
        return bigInteger8.equals(bigInteger2);
    }
}

