/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.asn1;

import com.certicom.ecc.asn1.CharacteristicTwo;
import com.certicom.ecc.asn1.Curve;
import com.certicom.ecc.asn1.ECParameters;
import com.certicom.ecc.asn1.FieldId;
import com.certicom.ecc.asn1.Parameters;
import com.certicom.ecc.asn1.Pentanomial;
import com.certicom.ecc.util.Conversion;
import com.trustpoint.asn.AsnBitString;
import com.trustpoint.asn.AsnInteger;
import com.trustpoint.asn.AsnNull;
import com.trustpoint.asn.AsnObject;
import com.trustpoint.asn.AsnObjectId;
import com.trustpoint.asn.AsnOctetString;

class ECConverter {
    ECConverter() {
    }

    public static Parameters toParameters(Object[] objectArray) {
        Parameters parameters = null;
        if (objectArray == null) {
            parameters = new Parameters(new AsnNull());
        } else if (objectArray[0] instanceof String) {
            parameters = new Parameters((String)objectArray[0]);
        } else {
            ECParameters eCParameters = null;
            if ((Integer)objectArray[0] == 1) {
                eCParameters = new ECParameters(1, (byte[])objectArray[1], (byte[])objectArray[2], (byte[])objectArray[3], (byte[])objectArray[4], (byte[])objectArray[5], (Integer)objectArray[6], (byte[])objectArray[7]);
            } else {
                int n = (Integer)objectArray[8];
                Integer[] integerArray = null;
                if (n == 3) {
                    integerArray = new Integer[]{(Integer)objectArray[9], (Integer)objectArray[10], (Integer)objectArray[11]};
                } else if (n == 2) {
                    integerArray = new Integer[]{(Integer)objectArray[9]};
                }
                eCParameters = new ECParameters(1, (byte[])objectArray[1], (byte[])objectArray[2], (byte[])objectArray[3], (byte[])objectArray[4], (byte[])objectArray[5], (Integer)objectArray[6], (Integer)objectArray[7], integerArray);
            }
            parameters = new Parameters(eCParameters);
        }
        return parameters;
    }

    public static Object[] toValues(Parameters parameters) {
        Object[] objectArray = null;
        AsnObject asnObject = parameters.getChoice();
        if (asnObject instanceof AsnNull) {
            return objectArray;
        }
        if (asnObject instanceof AsnObjectId) {
            objectArray = new Object[]{((AsnObjectId)asnObject).getValue()};
        } else {
            CharacteristicTwo characteristicTwo;
            ECParameters eCParameters = (ECParameters)asnObject;
            FieldId fieldId = (FieldId)eCParameters.getValue(1);
            Curve curve = (Curve)eCParameters.getValue(2);
            AsnOctetString asnOctetString = (AsnOctetString)eCParameters.getValue(3);
            AsnInteger asnInteger = (AsnInteger)eCParameters.getValue(4);
            AsnInteger asnInteger2 = (AsnInteger)eCParameters.getValue(5);
            if (fieldId.getValue(0).equals(FieldId.PRIME)) {
                objectArray = new Object[8];
                objectArray[0] = new Integer(1);
                objectArray[7] = Conversion.I2OSP(((AsnInteger)fieldId.getValue(1)).getBigInteger(), -1);
            } else {
                characteristicTwo = (CharacteristicTwo)fieldId.getValue(1);
                asnObject = characteristicTwo.getValue(1);
                if (asnObject.equals(CharacteristicTwo.PPBASIS)) {
                    objectArray = new Object[12];
                    Pentanomial pentanomial = (Pentanomial)characteristicTwo.getValue(2);
                    objectArray[8] = new Integer(3);
                    objectArray[9] = new Integer(((AsnInteger)pentanomial.getValue(0)).getInt());
                    objectArray[10] = new Integer(((AsnInteger)pentanomial.getValue(1)).getInt());
                    objectArray[11] = new Integer(((AsnInteger)pentanomial.getValue(2)).getInt());
                } else if (asnObject.equals(CharacteristicTwo.TPBASIS)) {
                    objectArray = new Object[10];
                    objectArray[8] = new Integer(2);
                    objectArray[9] = new Integer(((AsnInteger)characteristicTwo.getValue(2)).getInt());
                } else {
                    objectArray = new Object[9];
                    objectArray[8] = new Integer(1);
                }
                objectArray[0] = new Integer(2);
                objectArray[7] = new Integer(((AsnInteger)characteristicTwo.getValue(0)).getInt());
            }
            characteristicTwo = curve.getValue(2);
            objectArray[1] = ((AsnOctetString)curve.getValue(0)).getValue();
            objectArray[2] = ((AsnOctetString)curve.getValue(1)).getValue();
            objectArray[3] = characteristicTwo == null ? null : ((AsnBitString)characteristicTwo).getRawValue();
            objectArray[4] = asnOctetString.getValue();
            objectArray[5] = Conversion.I2OSP(asnInteger.getBigInteger(), -1);
            objectArray[6] = new Integer(asnInteger2.getInt());
        }
        return objectArray;
    }
}

