/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core;

import com.ibm.ws.pak.core.IPakDataFactory;
import com.ibm.ws.pak.core.PakData;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PakDataFactory
implements IPakDataFactory {
    private String m_sPakFileName = null;
    private String m_sMetadataLocation = null;
    private String m_sPakLocation = null;
    private String m_sLogLocation = null;
    private String m_sInstallLocation = null;
    private String m_sNifRegistryInstallType = null;
    private String m_sBackupPakLocation = null;
    private String m_sAllowBackup = null;
    private String m_sProductId = null;
    private String m_sOperation = null;
    private String m_sGaversion = null;
    private String m_sPathToProductProvidersXML = null;
    private Properties m_pOptionalProperties = null;

    @Override
    public PakData createPakData() throws Exception {
        try {
            PakData pakData = new PakData();
            pakData.initialize(this.getPakFileName(), this.getPakLocation(), this.getMetadataLocation(), this.getInstallLocation(), this.getLogLocation(), this.getBackupPakLocation(), this.getAllowBackup(), this.getProductId(), this.getNifRegistryInstallType(), this.getOperation(), this.getProductGAversion(), this.getProductProvidersXMLPath(), this.getOptionalProperties());
            return pakData;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public String getPakFileName() {
        return this.m_sPakFileName;
    }

    @Override
    public void setPakFileName(String pakFileName) {
        this.m_sPakFileName = pakFileName;
    }

    public String getPakLocation() {
        return this.m_sPakLocation;
    }

    @Override
    public void setPakLocation(String pakLocation) {
        this.m_sPakLocation = pakLocation;
    }

    public String getInstallLocation() {
        return this.m_sInstallLocation;
    }

    @Override
    public void setInstallLocation(String installLocation) {
        this.m_sInstallLocation = installLocation;
    }

    public String getBackupPakLocation() {
        return this.m_sBackupPakLocation;
    }

    @Override
    public void setBackupPakLocation(String backupPakLocation) {
        if (this.m_sBackupPakLocation == null || this.m_sBackupPakLocation.equals("")) {
            this.m_sBackupPakLocation = backupPakLocation;
        }
    }

    public String getAllowBackup() {
        return this.m_sAllowBackup;
    }

    @Override
    public void setAllowBackup(String allowBackup) {
        this.m_sAllowBackup = allowBackup;
    }

    public String getProductId() {
        return this.m_sProductId;
    }

    @Override
    public void setProductId(String productId) {
        if (this.m_sProductId == null || this.m_sProductId.equals("")) {
            this.m_sProductId = productId;
        }
    }

    public Properties getOptionalProperties() {
        return this.m_pOptionalProperties;
    }

    @Override
    public void setOptionalProperties(Properties optionalProperties) {
        this.m_pOptionalProperties = optionalProperties;
    }

    @Override
    public void setOperation(String operation) {
        this.m_sOperation = operation;
    }

    public String getOperation() {
        return this.m_sOperation;
    }

    public String getMetadataLocation() {
        return this.m_sMetadataLocation;
    }

    @Override
    public void setMetadataLocation(String metadataLocation) {
        this.m_sMetadataLocation = metadataLocation;
    }

    public String getNifRegistryInstallType() {
        return this.m_sNifRegistryInstallType;
    }

    @Override
    public void setNifRegistryInstallType(String nifRegistryInstallType) {
        if (this.m_sNifRegistryInstallType == null || this.m_sNifRegistryInstallType.equals("")) {
            this.m_sNifRegistryInstallType = nifRegistryInstallType;
        }
    }

    @Override
    public void setLogLocation(String logLocation) {
        this.m_sLogLocation = logLocation;
    }

    public String getLogLocation() {
        return this.m_sLogLocation;
    }

    @Override
    public String getProductGAversion() {
        return this.m_sGaversion;
    }

    @Override
    public void setProductGAversion(String gaversion) {
        this.m_sGaversion = gaversion;
    }

    @Override
    public String getProductProvidersXMLPath() {
        return this.m_sPathToProductProvidersXML;
    }

    @Override
    public void setProductProvidersXMLPath(String pathToProductProvidersXML) {
        this.m_sPathToProductProvidersXML = pathToProductProvidersXML;
        this.initializePropertiesFromProductProviderXML(pathToProductProvidersXML);
    }

    private SimpleXMLParser getPakContributedProductProviderXML(String sPahToProductProviderXML) {
        SimpleXMLParser parser = null;
        try {
            File file = new File(sPahToProductProviderXML);
            if (file.exists()) {
                parser = new SimpleXMLParser(file);
                return parser;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parser;
    }

    private String getParamValueFromProductProviderXML(SimpleXMLParser parser, String sPath, String sParam) {
        Vector vnodes = parser.getNodes(sPath);
        int i = 0;
        while (i < vnodes.size()) {
            Node nodeCompAction = (Node)vnodes.elementAt(i);
            Vector vCompAction = SimpleXMLParser.getAllNamedChildNodes((Node)nodeCompAction, (String)"param");
            int j = 0;
            while (j < vCompAction.size()) {
                Node nodeParam = (Node)vCompAction.elementAt(j);
                String sName = SimpleXMLParser.getNodeAttributeValue((Node)nodeParam, (String)"name");
                if (sName.equalsIgnoreCase(sParam)) {
                    return SimpleXMLParser.getNodeAttributeValue((Node)nodeParam, (String)"value");
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void initializePropertiesFromProductProviderXML(String sPathToProductProviderXML) {
        SimpleXMLParser pakContributedProductProviderXML = this.getPakContributedProductProviderXML(sPathToProductProviderXML);
        if (pakContributedProductProviderXML != null) {
            String sBackupRelativePath;
            String sProductId;
            this.m_sProductId = sProductId = this.getParamValueFromProductProviderXML(pakContributedProductProviderXML, "products/supported-products/product-plugin", "offering");
            String sIsMaintenance = this.getParamValueFromProductProviderXML(pakContributedProductProviderXML, "products/supported-products/product-plugin", "ismaintenance");
            if (sIsMaintenance != null && new Boolean(sIsMaintenance).booleanValue()) {
                this.m_sNifRegistryInstallType = "maintenance";
            }
            this.m_sBackupPakLocation = sBackupRelativePath = this.getParamValueFromProductProviderXML(pakContributedProductProviderXML, "products/supported-products/product-plugin", "backuppakrelativepath");
        }
    }
}

