/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.views.AConView;
import com.ibm.cic.common.core.utils.OutputFormatter;

public class ConViewText
extends AConView {
    public static final ConViewText NEW_LINE = new ConViewText("");
    private String m_text;
    private int m_appendNL = 0;
    private int m_indent = 0;

    public ConViewText(String a_text) {
        this(a_text, true);
    }

    public ConViewText(String a_text, boolean a_addNewLine) {
        this(a_text, a_addNewLine, 0);
    }

    public ConViewText(String a_text, int a_indent) {
        this(a_text, true, a_indent);
    }

    public ConViewText(String a_text, boolean a_addNewLine, int a_indent) {
        this.m_text = a_text;
        if (a_addNewLine) {
            this.m_appendNL = 1;
        }
        this.m_indent = a_indent;
    }

    @Override
    public void present(OutputFormatter output) {
        if (this.m_text != null) {
            int i = this.m_indent;
            while (i > 0) {
                output.incTab();
                --i;
            }
            output.appendT(new String[]{this.m_text});
            output.nl(this.m_appendNL);
            i = this.m_indent;
            while (i > 0) {
                output.decTab();
                --i;
            }
        }
    }

    @Override
    public IConAction getAction(IConIO a_input) {
        return null;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String m_text) {
        this.m_text = m_text;
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        return null;
    }

    public void setTrailingNewLineNr(int a_nrOfNL) {
        this.m_appendNL = a_nrOfNL;
    }

    public int getTrailingNewLineNr() {
        return this.m_appendNL;
    }
}

