/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.pages.licensePanel;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageData;
import com.ibm.cic.common.core.console.shared.pages.licensePanel.ConPager;
import com.ibm.cic.common.core.console.shared.pages.licensePanel.Messages;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class ConLicenseViewPage
extends AConPage {
    private static final String CMD_ALTERNATIVE_LANGUAGE = "L";
    private final LicensePageData.ILicenseNode licenseNode;
    private final LicensePageData.LanguageChoice currentLanguageChoice = new LicensePageData.LanguageChoice();
    private Locale textLocale = null;
    private String text;
    private String alternativeLanguage;
    private ConPager pager;
    private int currentPage;
    private boolean pageMode;
    private LicensePageData.LanguageChoicesForLicense langChoices;
    private final AConActionEntry cancelAction;

    public ConLicenseViewPage(IConManager manager, AConActionEntry cancelAction, LicensePageData.ILicenseNode licenseNode) {
        super(manager);
        this.cancelAction = cancelAction;
        this.licenseNode = licenseNode;
    }

    @Override
    public void init() {
        this.initTextAndAlternativeLanguage();
        this.setHeaderView(Messages.ConLicenseViewPage_readLicenseBanner);
        this.pager = new ConPager();
        this.pager.setText(this.textLocale, this.text);
        this.currentPage = 1;
        this.pageMode = true;
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.clear();
        this.createContents(this);
        super.present(a_output);
    }

    protected void createContents(ConViewGroup contents) {
        if (this.pageMode) {
            this.createContentsPageMode(contents);
        } else {
            this.createContentsNoPageMode(contents);
        }
    }

    protected void createContentsPageMode(ConViewGroup contents) {
        List<String> lines = this.pager.getLinesOfPage(this.currentPage);
        for (String line : lines) {
            contents.addView(new ConViewText(line));
        }
        ConViewList list = new ConViewList(null, false);
        list.addEntry(NLS.bind((String)Messages.ConLicenseViewPage_pageXofN, (Object)this.currentPage, (Object)this.pager.getPageCount()), new String[0], null);
        if (this.currentPage < this.pager.getPageCount()) {
            list.addEntry(Messages.ConLicenseViewPage_pageDown, ConCommonCommandKeys.keys_Page_Down, (AConActionEntry)new ConActionNextPage());
        }
        if (this.currentPage > 1) {
            list.addEntry(Messages.ConLicenseViewPage_pageUp, ConCommonCommandKeys.keys_Page_Up, (AConActionEntry)new ConActionPrevPage());
        }
        if (this.pager.getPageCount() > 1) {
            list.addEntry(Messages.ConLicenseViewPage_allPages, ConCommonCommandKeys.keys_All, (AConActionEntry)new ConActionTogglePageMode());
        }
        contents.addView(list);
        list = new ConViewList(null, false);
        list.addEntry(Messages.ConLicenseViewPage_return, "R", (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
        list.addEntry(Messages.ConLicenseViewPage_Cancel, "C", this.cancelAction);
        if (this.alternativeLanguage != null) {
            list.addEntry(this.alternativeLanguage, CMD_ALTERNATIVE_LANGUAGE, (AConActionEntry)new ConActionLanguage());
        }
        contents.addView(list);
    }

    protected void createContentsNoPageMode(ConViewGroup contents) {
        int i = 1;
        while (i <= this.pager.getPageCount()) {
            List<String> lines = this.pager.getLinesOfPage(i);
            for (String line : lines) {
                contents.addView(new ConViewText(line));
            }
            ++i;
        }
        ConViewList list = new ConViewList(null, false);
        list.addEntry(Messages.ConLicenseViewPage_showPages, "P", (AConActionEntry)new ConActionTogglePageMode());
        contents.addView(list);
        list = new ConViewList(null, false);
        list.addEntry(Messages.ConLicenseViewPage_return, "R", (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
        list.addEntry(Messages.ConLicenseViewPage_Cancel, "C", this.cancelAction);
        if (this.alternativeLanguage != null) {
            list.addEntry(this.alternativeLanguage, CMD_ALTERNATIVE_LANGUAGE, (AConActionEntry)new ConActionLanguage());
        }
        contents.addView(list);
    }

    private void initTextAndAlternativeLanguage() {
        this.text = null;
        this.textLocale = null;
        this.alternativeLanguage = null;
        try {
            String[] choices;
            this.langChoices = LicensePageData.LanguageChoicesForLicense.create(this.licenseNode.getLicense());
            String chosenText = this.langChoices.getLicenseText(this.currentLanguageChoice);
            if (chosenText != null) {
                this.text = chosenText;
                this.textLocale = this.currentLanguageChoice.isEnglish() ? Locale.ENGLISH : Locale.getDefault();
            } else {
                this.text = this.langChoices.getEnglishLicenseText();
                this.textLocale = Locale.ENGLISH;
            }
            if (ConLicenseViewPage.canHaveLanguageChoice() && (choices = this.langChoices.getLanguageChoices()).length > 1) {
                this.alternativeLanguage = this.currentLanguageChoice.isEnglish() ? this.langChoices.getNonEnglishLanguageName() : this.langChoices.getEnglishLanguageName();
            }
        }
        catch (IOException e) {
            this.text = LicensePageData.getLicensePageProblems();
            Logger.getGlobalLogger().error((Throwable)e);
        }
    }

    private static boolean canHaveLanguageChoice() {
        return !LicensePageData.defaultLocaleIsEnglish();
    }

    private class ConActionLanguage
    extends AConActionEntry<ConViewListEntry> {
        private ConActionLanguage() {
        }

        @Override
        public void run(IConManager manager) {
            ConLicenseViewPage.this.currentLanguageChoice.setEnglish(!ConLicenseViewPage.this.currentLanguageChoice.isEnglish());
            ConLicenseViewPage.this.init();
        }
    }

    private class ConActionNextPage
    extends AConActionEntry<ConViewListEntry> {
        private ConActionNextPage() {
        }

        @Override
        public void run(IConManager manager) {
            ConLicenseViewPage conLicenseViewPage = ConLicenseViewPage.this;
            conLicenseViewPage.currentPage = conLicenseViewPage.currentPage + 1;
        }
    }

    private class ConActionPrevPage
    extends AConActionEntry<ConViewListEntry> {
        private ConActionPrevPage() {
        }

        @Override
        public void run(IConManager manager) {
            ConLicenseViewPage conLicenseViewPage = ConLicenseViewPage.this;
            conLicenseViewPage.currentPage = conLicenseViewPage.currentPage - 1;
        }
    }

    private class ConActionTogglePageMode
    extends AConActionEntry<ConViewListEntry> {
        private ConActionTogglePageMode() {
        }

        @Override
        public void run(IConManager manager) {
            ConLicenseViewPage.this.pageMode = !ConLicenseViewPage.this.pageMode;
            if (ConLicenseViewPage.this.pageMode) {
                ConLicenseViewPage.this.currentPage = 1;
            }
        }
    }
}

