/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.pages;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewFooter;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewHeader;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.ArrayList;
import java.util.List;

public abstract class AConPageWizard
extends AConPage {
    private final List<Integer> m_previousPageIndexes = new ArrayList<Integer>();
    private int m_currentPageIndex = -1;
    ConViewList m_navigationListView;
    private String m_finishButtonName;
    private String[] m_finishButtonKeys;
    ConActPageWizardPrevious actionFlipToPrevious = new ConActPageWizardPrevious();
    ConActPageWizardNext actionFlipToNext = new ConActPageWizardNext();

    protected abstract AConActionEntry getFinishAction();

    protected abstract AConActionEntry getCancelAction();

    public AConPageWizard(IConManager manager) {
        super(manager);
    }

    protected boolean canFinish() {
        return this.getCurrentPage().isPageComplete() && this.m_currentPageIndex == this.size() - 1;
    }

    protected void addPage(AConPage a_page) {
        a_page.setFooterView(null);
        this.addView(a_page);
    }

    protected void setFinishButtonKeyName(String[] keys, String a_finishButtonName) {
        this.m_finishButtonKeys = keys;
        this.m_finishButtonName = a_finishButtonName;
    }

    protected String getFinishButtonName() {
        return this.m_finishButtonName;
    }

    @Override
    public void init() {
        this.flipToNext();
        ConViewGroup footer = new ConViewGroup();
        this.m_navigationListView = new ConViewList(null, false);
        footer.addView(this.m_navigationListView);
        footer.addView(new ConViewFooter());
        this.setFooterView(footer);
        super.init();
    }

    private int getNextValidPageIndex() {
        int i = this.m_currentPageIndex + 1;
        while (i < this.size()) {
            AConPage page;
            IConView v = this.get(i);
            if (v instanceof AConPage && !(page = (AConPage)v).skipPage()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.setSuggestedInput(null);
        a_output.nl();
        AConPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.setSuggestedInput(null);
            currentPage.present(a_output);
            if (currentPage.isSuggestedInputSet()) {
                this.setSuggestedInput(currentPage.getSuggestedInput());
            }
            this.presentFooter(currentPage, a_output);
        }
    }

    protected AConPage getCurrentPage() {
        IConView v;
        int size = this.size();
        if (size > 0 && this.m_currentPageIndex >= 0 && this.m_currentPageIndex < size && (v = this.get(this.m_currentPageIndex)) instanceof AConPage) {
            AConPage page = (AConPage)v;
            return page;
        }
        return null;
    }

    AConPage getPreviousPage() {
        IConView v;
        if (this.canFlipToPrevious() && (v = this.get(this.m_previousPageIndexes.get(this.m_previousPageIndexes.size() - 1))) instanceof AConPage) {
            return (AConPage)v;
        }
        return null;
    }

    private boolean canFlipToPrevious() {
        return !this.m_previousPageIndexes.isEmpty();
    }

    private void flipToPrevious() {
        if (this.canFlipToPrevious()) {
            this.getCurrentPage().setVisible(false);
            this.m_currentPageIndex = this.m_previousPageIndexes.get(this.m_previousPageIndexes.size() - 1);
            this.m_previousPageIndexes.remove(this.m_previousPageIndexes.size() - 1);
            this.getCurrentPage().setVisible(true);
        }
    }

    private boolean canFlipToNext(int a_nextValidPageIndex) {
        if (a_nextValidPageIndex >= 0) {
            AConPage currentPage = this.getCurrentPage();
            if (currentPage != null) {
                return currentPage.isPageComplete();
            }
            return true;
        }
        return false;
    }

    public void flipToNext() {
        int nextValidPageIndex = this.getNextValidPageIndex();
        if (this.canFlipToNext(nextValidPageIndex)) {
            if (this.m_currentPageIndex >= 0) {
                this.getCurrentPage().setVisible(false);
                this.m_previousPageIndexes.add(this.m_currentPageIndex);
            }
            this.m_currentPageIndex = nextValidPageIndex;
            this.getCurrentPage().initialize();
            this.getCurrentPage().setVisible(true);
        }
    }

    public void setCurrentPageToNextPage() {
        this.conManager().returnToWizardPage();
        int nextValidPageIndex = this.getNextValidPageIndex();
        assert (this.canFlipToNext(nextValidPageIndex));
        assert (this.m_currentPageIndex >= 0);
        AConPage currentPage = this.getCurrentPage();
        currentPage.setVisible(false);
        this.removeView(currentPage);
        this.m_currentPageIndex = --nextValidPageIndex;
        currentPage = this.getCurrentPage();
        currentPage.initialize();
        currentPage.setVisible(true);
    }

    private void presentFooter(AConPage currentPage, OutputFormatter a_output) {
        if (this.getFooterView() != null) {
            this.m_navigationListView.clearList();
            if (this.canFlipToPrevious()) {
                this.m_navigationListView.addEntry(Messages.WizardPage_Back, ConCommonCommandKeys.keys_Back, (AConActionEntry)this.actionFlipToPrevious);
            }
            if (currentPage.hasNext() || this.canFlipToNext(this.getNextValidPageIndex())) {
                if (!this.isSuggestedInputSet()) {
                    this.setSuggestedInput(ConCommonCommandKeys.keys_Next[0]);
                }
                this.m_navigationListView.addEntry(Messages.WizardPage_Next, ConCommonCommandKeys.keys_Next, this.getFlipToNextAction());
            }
            if (this.canFinish()) {
                if (!this.isSuggestedInputSet()) {
                    this.setSuggestedInput(this.m_finishButtonKeys[0]);
                }
                this.m_navigationListView.addEntry(this.m_finishButtonName, this.m_finishButtonKeys, this.getFinishAction());
            }
            this.m_navigationListView.addEntry(Messages.WizardPage_Cancel, ConCommonCommandKeys.keys_Cancel, this.getCancelAction());
            if (!this.isSuggestedInputSet()) {
                this.setSuggestedInput(ConCommonCommandKeys.keys_Cancel[0]);
            }
            this.getFooterView().present(a_output);
        }
    }

    @Override
    public IConAction getAction(IConIO a_input) {
        AConPage currentPage;
        IConAction return_value = null;
        if (this.getFooterView() != null) {
            return_value = this.getFooterView().getAction(a_input);
        }
        if (return_value == null && (currentPage = this.getCurrentPage()) != null) {
            return_value = currentPage.getAction(a_input);
        }
        return return_value;
    }

    @Override
    public void initialize() {
        if (!this.m_initialized) {
            AConPage cp;
            this.init();
            this.m_initialized = true;
            if (this.getHeaderView() != null) {
                this.getHeaderView().initialize();
            }
            if ((cp = this.getCurrentPage()) != null) {
                cp.initialize();
            }
            if (this.getFooterView() != null) {
                this.getFooterView().initialize();
            }
        }
    }

    private String getHeaderText(AConPage page) {
        IConView header;
        String return_value = null;
        if (page != null && (header = page.getHeaderView()) instanceof ConViewHeader) {
            return_value = ((ConViewHeader)header).getText();
        }
        return return_value;
    }

    @Override
    protected String calculatePreviousHeader(AConPage page) {
        String return_value = null;
        return_value = page.getParent() == this ? this.getHeaderText(this.getPreviousPage()) : this.getHeaderText(this.getCurrentPage());
        if (return_value == null) {
            return super.calculatePreviousHeader(page);
        }
        return return_value;
    }

    protected AConActionEntry getFlipToNextAction() {
        return this.actionFlipToNext;
    }

    class ConActPageWizardNext
    extends AConActionEntry {
        ConActPageWizardNext() {
        }

        @Override
        public void run(IConManager a_conManager) {
            AConPageWizard.this.flipToNext();
            super.run(a_conManager);
        }
    }

    class ConActPageWizardPrevious
    extends AConActionEntry {
        ConActPageWizardPrevious() {
        }

        @Override
        public void run(IConManager a_conManager) {
            AConPageWizard.this.flipToPrevious();
            super.run(a_conManager);
        }
    }
}

