/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.pages;

import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.pages.AConPageWizard;
import com.ibm.cic.common.core.console.views.ConViewFooter;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewHeader;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.OutputFormatter;

public abstract class AConPage
extends ConViewGroup {
    private final IConManager m_conManager;
    private IConView m_headerView;
    private IConView m_footerView;
    private String m_suggestedInput = "";

    public AConPage(IConManager a_conManager) {
        this.m_conManager = a_conManager;
        this.setFooterView(new ConViewFooter());
    }

    @Override
    public IConManager conManager() {
        return this.m_conManager;
    }

    public IConView getHeaderView() {
        return this.m_headerView;
    }

    protected void setHeaderView(IConView a_headerView) {
        this.m_headerView = a_headerView;
        if (this.m_headerView != null) {
            this.m_headerView.setParent(this);
        }
    }

    protected void setHeaderView(String a_headerView) {
        String prevHeader = this.calculatePreviousHeader(this);
        if (prevHeader != null) {
            this.setHeaderView(new ConViewHeader(String.valueOf(prevHeader) + "> " + a_headerView));
        } else {
            this.setHeaderView(new ConViewHeader(a_headerView));
        }
    }

    public void setFooterView(IConView a_footerView) {
        this.m_footerView = a_footerView;
        if (this.m_footerView != null) {
            this.m_footerView.setParent(this);
        }
    }

    protected IConView getFooterView() {
        return this.m_footerView;
    }

    @Override
    public void present(OutputFormatter a_output) {
        a_output.nl();
        if (this.m_headerView != null) {
            this.m_headerView.present(a_output);
        }
        super.present(a_output);
        if (this.m_footerView != null) {
            this.m_footerView.present(a_output);
        }
    }

    public boolean isPageComplete() {
        return false;
    }

    public boolean isPageSecure() {
        return false;
    }

    public boolean skipPage() {
        return false;
    }

    @Override
    public void initialize() {
        if (this.m_headerView != null) {
            this.m_headerView.initialize();
        }
        super.initialize();
        if (this.m_footerView != null) {
            this.m_footerView.initialize();
        }
    }

    protected String calculatePreviousHeader(AConPage page) {
        AConPage prevPage;
        String return_value = null;
        if (this.getParent() instanceof AConPage) {
            return_value = ((AConPage)this.getParent()).calculatePreviousHeader(page);
        } else if (this.conManager() != null && (prevPage = this.conManager().getPreviousPage()) != null) {
            if (prevPage instanceof AConPageWizard) {
                return_value = prevPage.calculatePreviousHeader(page);
            } else {
                IConView header = prevPage.getHeaderView();
                if (header instanceof ConViewHeader) {
                    return_value = ((ConViewHeader)header).getText();
                }
            }
        }
        return return_value;
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        String return_value = null;
        if (this.m_headerView != null) {
            return_value = this.m_headerView.findKey(a_matcher);
        }
        if (return_value == null) {
            return_value = super.findKey(a_matcher);
        }
        if (return_value == null && this.m_footerView != null) {
            return_value = this.m_footerView.findKey(a_matcher);
        }
        return return_value;
    }

    public void dispose() {
    }

    public String getSuggestedInput() {
        return this.m_suggestedInput;
    }

    protected boolean isSuggestedInputSet() {
        return this.m_suggestedInput != null && this.m_suggestedInput.length() > 0;
    }

    public void setSuggestedInput(String a_suggestedInput) {
        this.m_suggestedInput = a_suggestedInput == null ? "" : a_suggestedInput;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getHeaderView() != null) {
            sb.append(this.getHeaderView().toString());
        }
        if (this.getFooterView() != null) {
            sb.append(this.getFooterView().toString());
        }
        sb.append("Suggested Input:'");
        sb.append(this.m_suggestedInput);
        sb.append("'\n");
        return sb.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.setSuggestedInput(null);
    }

    public void setVisible(boolean a_visible) {
    }

    protected boolean hasNext() {
        return false;
    }
}

