/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.FlexlmDate;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.PackageComponent;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

public class PackageLine
extends LicenseElement
implements FlexlmConstants,
FlexlmInternalConstants {
    public PackageLine(TokenizedLicenseLine tokenizedLicenseLine, LicenseCertificate licenseCertificate, VendorInfo vendorInfo) throws FlexlmException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, "Keyword");
        arrayList.add(1, "Name");
        arrayList.add(2, "Vendor");
        int n = 3;
        arrayList.add(3, "Version");
        arrayList.add(4, "Code");
        String[] stringArray = new String[]{"COMPONENTS", "OPTIONS", "SUPERSEDE", "ISSUED", "SIGN", "SIGN2"};
        this.assignTokensToFields(tokenizedLicenseLine, licenseCertificate, vendorInfo, n, arrayList, stringArray);
        this.expirationDate = new FlexlmDate("1-jan-0");
        if (this.version == null) {
            this.version = new FlexlmVersion("ANYVER");
        }
        this.isDirty = false;
    }

    public void authenticate() throws FlexlmException {
        this.doAuthenticate();
    }

    public boolean isAuthentic() {
        return this.authentic;
    }

    public static void applyPackages(LinkedList linkedList, LinkedList linkedList2) throws FlexlmException {
        if (linkedList == null || linkedList.size() < 1) {
            return;
        }
        if (linkedList2 == null || linkedList2.size() < 1) {
            return;
        }
        ListIterator listIterator = linkedList2.listIterator(0);
        while (listIterator.hasNext()) {
            PackageLine packageLine = null;
            packageLine = (PackageLine)listIterator.next();
            String string = packageLine.name;
            String string2 = packageLine.vendor;
            FlexlmVersion flexlmVersion = packageLine.version;
            LinkedList linkedList3 = null;
            ListIterator listIterator2 = linkedList.listIterator(0);
            while (listIterator2.hasNext()) {
                int n;
                FeatureLine featureLine = (FeatureLine)listIterator2.next();
                if (!string.equalsIgnoreCase(featureLine.name) || !string2.equalsIgnoreCase(featureLine.vendor) || flexlmVersion != null && (n = flexlmVersion.compareTo(featureLine.version)) != 0) continue;
                linkedList3 = PackageLine.expand(packageLine, featureLine);
                linkedList.remove(featureLine);
                break;
            }
            if (linkedList3 == null) continue;
            linkedList.addAll(linkedList3);
            linkedList3 = null;
        }
    }

    private static LinkedList expand(PackageLine packageLine, FeatureLine featureLine) throws FlexlmException {
        LinkedList<FeatureLine> linkedList = new LinkedList<FeatureLine>();
        PackageComponent[] packageComponentArray = packageLine.components;
        for (int i = 0; i < packageComponentArray.length; ++i) {
            int n;
            FeatureLine featureLine2 = featureLine.cloner();
            featureLine2.authentic = true;
            featureLine2.name = packageComponentArray[i].getName();
            FlexlmVersion flexlmVersion = packageComponentArray[i].getVersion();
            if (flexlmVersion != null) {
                featureLine2.version = flexlmVersion;
            }
            if ((n = packageComponentArray[i].getCount()) != 0) {
                featureLine2.count *= n;
            }
            featureLine2.expandedFrom = packageLine;
            linkedList.add(featureLine2);
        }
        return linkedList;
    }

    public String getComponentString() {
        return this.componentString;
    }

    public PackageComponent[] getComponentArray() {
        return this.components;
    }

    public String getOptionsString() {
        return this.options;
    }

    public String toString() {
        return "PACKAGE " + this.getName() + " " + this.getVendorName() + " " + this.getVersion() + " " + (this.getCode() == null ? "" : this.getCode() + " ") + "COMPONENTS=\"" + this.getComponentString() + "\" " + (this.getOptionsString() == null ? "" : "OPTIONS=" + this.getOptionsString() + " ") + (this.supersedePresent ? "SUPERSEDE" : "") + (this.getSupersedeListString() == null ? "" : "=" + this.getSupersedeListString()) + " " + (this.getIssuedDate() == null ? "" : "ISSUED=" + this.getIssuedDate() + " ") + (this.getSignature() == null ? "" : "SIGN=\"" + this.getSignature() + "\" ") + (this.getSignature2() == null ? "" : "SIGN2=\"" + this.getSignature2() + "\" ");
    }
}

