/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.internal.installAdaptors.BundleEntry;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.util.NLS;

public abstract class BundleFile {
    protected File basefile;

    public BundleFile() {
    }

    public BundleFile(File basefile) {
        this.basefile = basefile;
    }

    public abstract File getFile(String var1);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public File getBaseFile() {
        return this.basefile;
    }

    public static class DirBundleFile
    extends BundleFile {
        public DirBundleFile(File basefile) throws IOException {
            super(basefile);
            if (!basefile.exists() || !basefile.isDirectory()) {
                throw new IOException(NLS.bind((String)Messages.BundleFile_file_is_not_a_directory, (Object)basefile));
            }
        }

        public File getFile(String path) {
            File filePath = new File(this.basefile, path);
            if (filePath.exists()) {
                return filePath;
            }
            return null;
        }

        public BundleEntry getEntry(String path) {
            File filePath = new File(this.basefile, path);
            if (!filePath.exists()) {
                return null;
            }
            return new BundleEntry.FileBundleEntry(filePath, path);
        }

        public boolean containsDir(String dir) {
            File dirPath = new File(this.basefile, dir);
            return dirPath.exists() && dirPath.isDirectory();
        }

        public Enumeration getEntryPaths(final String path) {
            final File pathFile = new File(this.basefile, path);
            if (!pathFile.exists()) {
                return null;
            }
            if (pathFile.isDirectory()) {
                final String[] fileList = pathFile.list();
                if (fileList == null || fileList.length == 0) {
                    return null;
                }
                final String dirPath = path.length() == 0 || path.charAt(path.length() - 1) == '/' ? path : String.valueOf(path) + '/';
                return new Enumeration(){
                    int cur = 0;

                    public boolean hasMoreElements() {
                        return this.cur < fileList.length;
                    }

                    public Object nextElement() {
                        if (!this.hasMoreElements()) {
                            throw new NoSuchElementException();
                        }
                        File childFile = new File(pathFile, fileList[this.cur]);
                        StringBuffer sb = new StringBuffer(dirPath).append(fileList[this.cur++]);
                        if (childFile.isDirectory()) {
                            sb.append("/");
                        }
                        return sb.toString();
                    }
                };
            }
            return new Enumeration(){
                int cur = 0;

                public boolean hasMoreElements() {
                    return this.cur < 1;
                }

                public Object nextElement() {
                    if (this.cur == 0) {
                        this.cur = 1;
                        return path;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        public void close() {
        }

        public void open() {
        }
    }

    public static class NestedDirBundleFile
    extends BundleFile {
        BundleFile baseBundleFile;
        String cp;

        public NestedDirBundleFile(BundleFile baseBundlefile, String cp) {
            super(baseBundlefile.basefile);
            this.baseBundleFile = baseBundlefile;
            this.cp = cp;
            if (cp.charAt(cp.length() - 1) != '/') {
                this.cp = String.valueOf(this.cp) + '/';
            }
        }

        public void close() {
        }

        public BundleEntry getEntry(String path) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            String newpath = new StringBuffer(this.cp).append(path).toString();
            return this.baseBundleFile.getEntry(newpath);
        }

        public boolean containsDir(String dir) {
            if (dir == null) {
                return false;
            }
            if (dir.length() > 0 && dir.charAt(0) == '/') {
                dir = dir.substring(1);
            }
            String newdir = new StringBuffer(this.cp).append(dir).toString();
            return this.baseBundleFile.containsDir(newdir);
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public File getFile(String entry) {
            return null;
        }

        public void open() {
        }
    }

    public static class ZipBundleFile
    extends BundleFile {
        protected ZipFile zipFile;
        protected boolean closed = true;

        public ZipBundleFile(File basefile) throws IOException {
            super(basefile);
            if (!basefile.exists()) {
                throw new IOException(basefile.toString());
            }
            this.closed = true;
        }

        protected boolean checkedOpen() {
            try {
                return this.getZipFile() != null;
            }
            catch (IOException e) {
                return false;
            }
        }

        protected ZipFile basicOpen() throws IOException {
            return new ZipFile(this.basefile);
        }

        protected ZipFile getZipFile() throws IOException {
            if (this.closed) {
                this.zipFile = this.basicOpen();
                this.closed = false;
            }
            return this.zipFile;
        }

        private ZipEntry getZipEntry(String path) {
            ZipEntry dirEntry;
            ZipEntry entry;
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if ((entry = this.zipFile.getEntry(path)) != null && entry.getSize() == 0L && !entry.isDirectory() && (dirEntry = this.zipFile.getEntry(String.valueOf(path) + '/')) != null) {
                entry = dirEntry;
            }
            return entry;
        }

        protected File extractDirectory(String dirName) {
            if (!this.checkedOpen()) {
                return null;
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(dirName) || entryPath.endsWith("/")) continue;
                this.getFile(entryPath);
            }
            return this.getExtractFile(dirName);
        }

        private File getExtractFile(String entryName) {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public File getFile(String entry) {
            File nested;
            block7: {
                if (!this.checkedOpen()) {
                    return null;
                }
                ZipEntry zipEntry = this.getZipEntry(entry);
                if (zipEntry == null) {
                    return null;
                }
                nested = this.getExtractFile(zipEntry.getName());
                if (nested == null) return null;
                if (nested.exists()) return nested;
                if (zipEntry.getName().endsWith("/")) {
                    if (!nested.mkdirs()) {
                        throw new IOException(NLS.bind((String)Messages.BundleFile_directory_could_not_be_created, (Object)nested.getAbsolutePath()));
                    }
                    this.extractDirectory(zipEntry.getName());
                    return nested;
                }
                InputStream in = this.zipFile.getInputStream(zipEntry);
                if (in != null) break block7;
                return null;
            }
            try {
                File dir = new File(nested.getParent());
                if (dir.exists() || dir.mkdirs()) return nested;
                throw new IOException(NLS.bind((String)Messages.BundleFile_directory_could_not_be_created, (Object)dir.getAbsolutePath()));
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
            return null;
        }

        public boolean containsDir(String dir) {
            if (!this.checkedOpen()) {
                return false;
            }
            if (dir == null) {
                return false;
            }
            if (dir.length() == 0) {
                return true;
            }
            if (dir.charAt(0) == '/') {
                if (dir.length() == 1) {
                    return true;
                }
                dir = dir.substring(1);
            }
            if (dir.length() > 0 && dir.charAt(dir.length() - 1) != '/') {
                dir = String.valueOf(dir) + '/';
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(dir)) continue;
                return true;
            }
            return false;
        }

        public BundleEntry getEntry(String path) {
            if (!this.checkedOpen()) {
                return null;
            }
            ZipEntry zipEntry = this.getZipEntry(path);
            if (zipEntry == null) {
                if ((path.length() == 0 || path.charAt(path.length() - 1) == '/') && this.containsDir(path)) {
                    return new BundleEntry.DirZipBundleEntry(this, path);
                }
                return null;
            }
            return new BundleEntry.ZipBundleEntry(zipEntry, this);
        }

        public Enumeration getEntryPaths(String path) {
            if (!this.checkedOpen()) {
                return null;
            }
            if (path == null) {
                throw new NullPointerException();
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                path = new StringBuffer(path).append("/").toString();
            }
            Vector<String> vEntries = new Vector<String>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
                if (entryPath.lastIndexOf(47) < path.length()) {
                    vEntries.add(entryPath);
                    continue;
                }
                entryPath = entryPath.substring(path.length());
                int slash = entryPath.indexOf(47);
                entryPath = String.valueOf(path) + entryPath.substring(0, slash + 1);
                if (vEntries.contains(entryPath)) continue;
                vEntries.add(entryPath);
            }
            return vEntries.size() == 0 ? null : vEntries.elements();
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.zipFile.close();
            }
        }

        public void open() {
        }
    }
}

