/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.VersionUtil;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class ShareableEntityRef {
    public IShareableEntity shareableEntity = null;
    public String id;
    public VersionRange minTolerance = VersionRange.emptyRange;
    public String minReferencer = "";

    public ShareableEntityRef(String id) {
        this.id = id;
    }

    public void setShareableEntity(IShareableEntity shareableEntity) {
        this.shareableEntity = shareableEntity;
    }

    public IShareableEntity getShareableEntity() {
        return this.shareableEntity;
    }

    public String getId() {
        return this.id;
    }

    public VersionRange getMinTolerance() {
        return this.minTolerance;
    }

    public String getMinReferencer() {
        return this.minReferencer;
    }

    public void updateTolerance(VersionRange tolerance, String referencer) {
        Version min = tolerance.getMinimum();
        assert (min != null);
        Version max = tolerance.getRight();
        int incmin = tolerance.getIncludeMinimum() ? 1 : 0;
        int incmax = tolerance.getIncludeMaximum() ? 1 : 0;
        Version curmin = this.minTolerance.getMinimum();
        Version curmax = this.minTolerance.getRight();
        int curincmin = this.minTolerance.getIncludeMinimum() ? 1 : 0;
        int curincmax = this.minTolerance.getIncludeMaximum() ? 1 : 0;
        Version newmin = null;
        Version newmax = Version.emptyVersion;
        int newincmin = 0;
        int newincmax = 1;
        int cmp = min.compareTo(curmin) - incmin + curincmin;
        if (cmp > 0) {
            newmin = min;
            newincmin = incmin;
        }
        if ((cmp = Comparators.compare((Version)max, (Version)curmax) + incmax - curincmax) < 0) {
            newmax = max;
            newincmax = incmax;
        }
        if (newmin != null) {
            if (newmax != Version.emptyVersion) {
                this.minTolerance = tolerance;
                this.minReferencer = referencer;
                return;
            }
            newmax = curmax;
            newincmax = curincmax;
        } else {
            if (newmax == Version.emptyVersion) {
                return;
            }
            newmin = curmin;
            newincmin = curincmin;
        }
        this.minTolerance = new VersionRange(newmin, newincmin == 1, newmax, newincmax == 1);
        this.minReferencer = referencer;
    }

    public void updateTolerance(Version seVersion) {
        if (VersionUtil.compareToIgnoreQualifier((Version)this.minTolerance.getMinimum(), (Version)seVersion) != 0 || !this.minTolerance.getIncludeMinimum()) {
            Version seVersionSansQualifier = new Version(seVersion.getMajor(), seVersion.getMinor(), seVersion.getMicro(), null);
            this.minTolerance = new VersionRange(seVersionSansQualifier, true, this.minTolerance.getRight(), this.minTolerance.getIncludeMaximum());
        }
    }

    public VersionRange getToleranceDelta() {
        Version min = this.minTolerance.getMinimum();
        Version max = this.minTolerance.getRight();
        Version deltaMax = ShareableEntityRef.computeDelta(min, max);
        return new VersionRange(Version.emptyVersion, this.minTolerance.getIncludeMinimum(), deltaMax, this.minTolerance.getIncludeMaximum());
    }

    public static Version computeAbsoluteDelta(Version v1, Version v2) {
        Version max;
        Version min;
        if (v1.compareTo(v2) <= 0) {
            min = v1;
            max = v2;
        } else {
            min = v2;
            max = v1;
        }
        return ShareableEntityRef.computeDelta(min, max);
    }

    public static Version computeDelta(Version min, Version max) {
        Version delta;
        if (max == null) {
            delta = null;
        } else {
            int[] maxParts = new int[]{max.getMicro(), max.getMinor(), max.getMajor()};
            int[] minParts = new int[]{min.getMicro(), min.getMinor(), min.getMajor()};
            int[] result = new int[minParts.length];
            int i = 0;
            while (i < result.length) {
                int maxPart = maxParts[i];
                int minPart = minParts[i];
                result[i] = maxPart < minPart ? 0 : maxPart - minPart;
                ++i;
            }
            delta = new Version(result[2], result[1], result[0], null);
        }
        return delta;
    }
}

