/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.LUMClient;

import com.ibm.LUMClient.CurrentUsers;
import com.ibm.LUMClient.LicenseConstants;
import com.ibm.LUMClient.LicenseTransaction;
import com.ibm.LUMClient.LumCoreClient;
import com.ibm.LUMClient.LumDirectBinding;
import com.ibm.LUMClient.LumOffLine;
import com.ibm.LUMClient.ProductInfo;
import com.ibm.LUMClient.ServerInfo;
import com.ibm.LUMClient.trybuyTransaction;
import java.io.File;

public class LumClient
implements LicenseConstants {
    private String vendorID = "";
    protected static String path = null;
    private static LumClient lumCLient = null;
    private boolean useOpenTargetTryAndBuy = false;

    private LumClient() {
    }

    private LumClient(String string) {
        path = string;
    }

    public LicenseTransaction initSession(String string) throws IllegalArgumentException {
        LicenseTransaction licenseTransaction = new LicenseTransaction();
        if (string == null) {
            throw new IllegalArgumentException("the Vendor id is null");
        }
        LumCoreClient.getLumCoreClient().initSession(string, licenseTransaction);
        return licenseTransaction;
    }

    public static synchronized LumClient getLumClient() {
        if (lumCLient == null) {
            lumCLient = new LumClient();
        }
        return lumCLient;
    }

    public static synchronized LumClient getLumClient(String string) {
        if (lumCLient == null) {
            lumCLient = new LumClient(string);
        }
        return lumCLient;
    }

    public LicenseTransaction requestLicense(int n, int n2, String string, int n3, int n4, boolean bl, String string2, String string3, byte[] byArray) throws IllegalArgumentException {
        return this.requestLicense(n, n2, string, n3, n4, bl, string2, string3, byArray, "", "", "");
    }

    public LicenseTransaction requestLicense(int n, int n2, String string, int n3, int n4, boolean bl, String string2, String string3, byte[] byArray, String string4, String string5, String string6) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("the product version is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("the acid is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("the serial number is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("the advanced options array is null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("the user id is null");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("the group id is null");
        }
        if (string6 == null) {
            throw new IllegalArgumentException("the node id is null");
        }
        LicenseTransaction licenseTransaction = new LicenseTransaction(this.vendorID, n2, string, n, n3, bl, n4, string2, string3, byArray, string4, string5, string6);
        LumCoreClient.getLumCoreClient().requestLicense(licenseTransaction);
        return licenseTransaction;
    }

    public LicenseTransaction releaseLicense(int n) {
        LicenseTransaction licenseTransaction = new LicenseTransaction();
        licenseTransaction.setTransactionID(n);
        LumCoreClient.getLumCoreClient().releaseLicense(licenseTransaction);
        return licenseTransaction;
    }

    public long setOption(String string, int n, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("the VendorID is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("the Value option is null");
        }
        LicenseTransaction licenseTransaction = new LicenseTransaction();
        licenseTransaction.setVendorID(string);
        licenseTransaction.setIntOption(n);
        licenseTransaction.setValue(string2);
        LumCoreClient.getLumCoreClient().setOption(licenseTransaction);
        return licenseTransaction.getServerStatus();
    }

    public long addTryBuy(int n, String string, String string2, long l) throws IllegalArgumentException, SecurityException {
        long l2;
        if (string == null) {
            throw new IllegalArgumentException("the product version is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("the trybuyFile is null");
        }
        File file = new File(string2);
        if (!file.canRead()) {
            throw new SecurityException("Can't find the try & buy certificate file ");
        }
        trybuyTransaction trybuyTransaction2 = new trybuyTransaction();
        LumCoreClient.getLumCoreClient().getTarget(trybuyTransaction2);
        if (this.useOpenTargetTryAndBuy) {
            trybuyTransaction2.targetType = 1;
            trybuyTransaction2.targetID = -1;
        }
        if ((l2 = trybuyTransaction2.getStatus()) != 0L) {
            return l2;
        }
        trybuyTransaction2.setstartDate(l);
        trybuyTransaction2.setproductVersion(string);
        trybuyTransaction2.setproductID(n);
        trybuyTransaction2.setfileName(string2);
        LumCoreClient.getLumCoreClient().requestCompound(trybuyTransaction2);
        l2 = trybuyTransaction2.getStatus();
        if (l2 != 0L) {
            return l2;
        }
        LumCoreClient.getLumCoreClient().addNodelocked(trybuyTransaction2);
        l2 = trybuyTransaction2.getStatus();
        if (l2 != 0L) {
            return l2;
        }
        return l2;
    }

    public String getErrMsg(long l) {
        return LumCoreClient.getLumCoreClient().getErrMsg(l);
    }

    public LicenseTransaction checkIn(int n) {
        LicenseTransaction licenseTransaction = new LicenseTransaction();
        licenseTransaction.setTransactionID(n);
        LumCoreClient.getLumCoreClient().checkIn(licenseTransaction);
        return licenseTransaction;
    }

    public LicenseTransaction cleanUp() {
        LicenseTransaction licenseTransaction = new LicenseTransaction();
        LumCoreClient.getLumCoreClient().cleanUp(licenseTransaction);
        return licenseTransaction;
    }

    public LicenseTransaction getAddLicenseData(int n, int n2) {
        LicenseTransaction licenseTransaction = new LicenseTransaction();
        licenseTransaction.setTransactionID(n);
        licenseTransaction.setLicenseDataLen(n2);
        LumCoreClient.getLumCoreClient().getAddLicData(licenseTransaction);
        return licenseTransaction;
    }

    public LumDirectBinding configureClient(int n, int n2, int n3, String string, String[] stringArray, String[] stringArray2, int[] nArray) throws IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("the ServerNames array is null");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("the ServerTypes array is null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("the ServerPorts array is null");
        }
        LumDirectBinding lumDirectBinding = new LumDirectBinding(n, n2, n3, string, stringArray, stringArray2, nArray);
        LumCoreClient.getLumCoreClient().configureClient(lumDirectBinding);
        return lumDirectBinding;
    }

    public long reserveOffLine(int n, String string, String string2, char c, char c2, String string3, byte[] byArray) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("the product version is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("the user password is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("the serial number is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("AdvancedOptions == null");
        }
        LumOffLine lumOffLine = new LumOffLine(n, string, string2, byArray);
        lumOffLine.setResPeriod(c);
        lumOffLine.setFlag(c2);
        lumOffLine.setUserPassword(string3);
        LumCoreClient.getLumCoreClient().reserveOffLine(lumOffLine);
        return lumOffLine.getStatus();
    }

    public long handbackOffLine(int n, String string, String string2, byte[] byArray) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("the product version is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("the serial number is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("AdvancedOptions == null");
        }
        LumOffLine lumOffLine = new LumOffLine(n, string, string2, byArray);
        LumCoreClient.getLumCoreClient().handbackOffLine(lumOffLine);
        return lumOffLine.getStatus();
    }

    public ServerInfo getServerInfo(int n, int n2) throws IllegalArgumentException {
        if (n < -1) {
            throw new IllegalArgumentException("Incorrect Transaction ID");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Incorrect number of servers");
        }
        ServerInfo serverInfo = new ServerInfo(n, n2);
        LumCoreClient.getLumCoreClient().getServerInfo(serverInfo);
        return serverInfo;
    }

    public CurrentUsers getCurrentUsers(int n, String string, int n2) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Incorrect size");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Incorrect product ID");
        }
        CurrentUsers currentUsers = new CurrentUsers(n, string, n2);
        LumCoreClient.getLumCoreClient().getCurrentUsers(currentUsers);
        return currentUsers;
    }

    public ProductInfo getProductInfo(int n, int n2, int n3, int[] nArray) throws IllegalArgumentException {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("illegal server location (must be between 0 and 3)");
        }
        if (n2 <= -2) {
            throw new IllegalArgumentException("Incorrect product ID");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Incorrect size");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("AdvancedOptions == null");
        }
        ProductInfo productInfo = new ProductInfo(n, n2, n3, nArray);
        LumCoreClient.getLumCoreClient().getProductInfo(productInfo);
        return productInfo;
    }

    public boolean isUseOpenTargetTryAndBuy() {
        return this.useOpenTargetTryAndBuy;
    }

    public void setUseOpenTargetTryAndBuy(boolean bl) {
        this.useOpenTargetTryAndBuy = bl;
    }
}

