/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.utils.WASDirectoryHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASSystem {
    public static final int N_UNKNOWN = 0;
    public static final int N_AIX = 1;
    public static final int N_HPUX = 2;
    public static final int N_SOLARIS = 3;
    public static final int N_LINUX = 4;
    public static final int N_WINDOWS = 5;
    public static final int N_Z_OS = 6;
    public static final int N_OS400 = 7;
    private String m_sWASRegistryFile = null;
    private static WASSystem instance = null;
    private String m_sNIFRegistryFile = null;
    private Set m_setAllFileLocations = new HashSet();
    private Vector m_vAllLocations = new Vector();
    private String[] m_saAllLocations = null;
    private Vector m_vWasLocations = new Vector();
    private String[] m_saWasLocations = null;
    private Vector m_vBaseLocations = new Vector();
    private String[] m_saBaseLocations = null;
    private Vector m_vExpressLocations = new Vector();
    private String[] m_saExpressLocations = null;
    private Vector m_vNDLocations = new Vector();
    private String[] m_saNDLocations = null;
    private Vector m_vNDDMZLocations = new Vector();
    private String[] m_saNDDMZLocations = null;
    private Vector m_vEmbeddedExpressLocations = new Vector();
    private String[] m_saEmbeddedExpressLocations = null;
    private Vector m_vWBILocations = new Vector();
    private String[] m_saWBILocations = null;
    private Vector m_vJDKLocations = new Vector();
    private String[] m_saJDKLocations = null;
    private Vector m_vCLTLocations = new Vector();
    private String[] m_saCLTLocations = null;
    private Vector m_vPLGLocations = new Vector();
    private String[] m_saPLGLocations = null;
    private Vector m_vIHSLocations = new Vector();
    private String[] m_saIHSLocations = null;
    private Vector m_vXDLocations = new Vector();
    private String[] m_saXDLocations = null;
    private Vector m_vWXDLocations = new Vector();
    private String[] m_saWXDLocations = null;
    private Vector m_vPMELocations = new Vector();
    private String[] m_saPMELocations = null;
    private static String m_sSystemDriveOnWindows = null;
    private static String m_sSystemRootOnWindows = null;
    private static final String ID_AllProduct = "AllProduct";
    private static final String S_REGISTRY_FILE_NAME = ".WASRegistry";
    private static final String S_USER_HOME = "user.home";
    private static final String S_EMPTY = "";
    private static final String S_RALATIVE_PROPERTIES_VERSION_DIR = File.separator + "properties" + File.separator + "version";
    private static final String S_DOT_PRODUCT = ".product";
    private static final String S_NIFREGISTRY_FILE_NAME = ".nifregistry";
    private static final String S_NIFREGISTRY_PARENT_OS400 = "/QIBM/WAS/.ibm/.nif";
    private static final String S_NIFREGISTRY_RELATIVEPATH = "/.ibm/.nif";
    private static final String S_NIFREGISTRY_PARENT_UNIX_FORROOT = "/opt";
    private static final String S_NIFREGISTRY_PARENT_AIX_FORROOT = "/usr";
    private static final String S_PATH_SEPARATOR = "/";
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String S_NIFREGISTRY_ROOT_PATTERN = "<nifregistry.*";
    private static final String S_PRODUCT_ELEMENT_PATTERN = "\\s*<product.*?installrooturi=\"(.*?)\".*?productid=\"(.*?)\".*?version=.*";
    private static final String S_DRIVE_A = "A";
    private static final String S_DRIVE_B = "B";
    private static final String S_UTF8_ENCODING = "UTF-8";

    public static WASSystem getWASSystemInstance() {
        if (instance == null) {
            instance = new WASSystem();
        }
        return instance;
    }

    public static WASSystem getWASSystemInstance(String string) {
        File file = new File(string);
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        if (instance == null) {
            instance = new WASSystem(string);
        }
        return instance;
    }

    public String getNIFRegistryFile() {
        return this.m_sNIFRegistryFile;
    }

    public void setNIFRegistryFile(String string) {
        this.m_sNIFRegistryFile = string;
    }

    public String getWASRegistryFile() {
        return this.m_sWASRegistryFile;
    }

    public void setWASRegistryFile(String string) {
        this.m_sWASRegistryFile = string;
    }

    public String[] getWASLocations() {
        return this.getInstallPackageLocationsByProductID(null);
    }

    public void setWASLocations(String[] stringArray) {
    }

    public String[] getAllInstallPackageLocations() {
        return this.getInstallPackageLocationsByProductID(ID_AllProduct);
    }

    public String[] getInstallPackageLocationsByProductID(String string) {
        if (this.m_saWasLocations == null) {
            return this.getNonCachedInstallPackageLocationsByProductID(string);
        }
        return this.getLocationsByProductID(string);
    }

    public String[] getNonCachedAllInstallPackageLocations() {
        return this.getNonCachedInstallPackageLocationsByProductID(ID_AllProduct);
    }

    public String[] getNonCachedInstallPackageLocationsByProductID(String string) {
        this.clearLocationVectors();
        this.parseNIFRegistry(this.m_sNIFRegistryFile);
        this.parseWASRegistry(this.m_sWASRegistryFile);
        this.convertLocationVectorsToStringArray();
        return this.getLocationsByProductID(string);
    }

    public String[] getNonCachedWASLocations() {
        return this.getNonCachedInstallPackageLocationsByProductID(null);
    }

    public void print() {
        String[] stringArray = this.getLocationsByProductID(null);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("location[" + i + "]=" + stringArray[i]);
        }
    }

    private WASSystem() {
        this.m_sNIFRegistryFile = this.getNIFRegistryPath(S_NIFREGISTRY_FILE_NAME);
        String string = System.getProperty(S_USER_HOME);
        this.m_sWASRegistryFile = string + File.separator + S_REGISTRY_FILE_NAME;
    }

    private WASSystem(String string) {
        if (!this.isThisRegistryNIFRegistry(string)) {
            this.m_sWASRegistryFile = string;
        } else {
            this.m_sNIFRegistryFile = string;
        }
    }

    private void addInstallPackageLocationsByProductID(String string, File file) {
        String string2 = file.getAbsolutePath();
        if (!this.m_setAllFileLocations.contains(file)) {
            this.m_setAllFileLocations.add(file);
            this.m_vAllLocations.add(string2);
        }
        if ((string = WASDirectoryHelper.normalizedProductID(string)) == null) {
            this.m_vWasLocations.add(string2);
        } else if (string.equalsIgnoreCase("BASE")) {
            this.m_vWasLocations.add(string2);
            this.m_vBaseLocations.add(string2);
        } else if (string.equalsIgnoreCase("EXPRESS")) {
            this.m_vWasLocations.add(string2);
            this.m_vExpressLocations.add(string2);
        } else if (string.equalsIgnoreCase("BASETRIAL")) {
            this.m_vWasLocations.add(string2);
            this.m_vBaseLocations.add(string2);
        } else if (string.equalsIgnoreCase("EXPRESSTRIAL")) {
            this.m_vWasLocations.add(string2);
            this.m_vExpressLocations.add(string2);
        } else if (string.equalsIgnoreCase("ND")) {
            this.m_vWasLocations.add(string2);
            this.m_vNDLocations.add(string2);
        } else if (string.equalsIgnoreCase("NDDMZ")) {
            this.m_vWasLocations.add(string2);
            this.m_vNDDMZLocations.add(string2);
        } else if (string.equalsIgnoreCase("embeddedEXPRESS")) {
            this.m_vWasLocations.add(string2);
            this.m_vEmbeddedExpressLocations.add(string2);
        } else if (string.equalsIgnoreCase("XD")) {
            this.m_vXDLocations.add(string2);
        } else if (string.equalsIgnoreCase("WXD")) {
            this.m_vWXDLocations.add(string2);
        } else if (string.equalsIgnoreCase("CLIENT")) {
            this.m_vCLTLocations.add(string2);
        } else if (string.equalsIgnoreCase("PLG")) {
            this.m_vPLGLocations.add(string2);
        } else if (string.equalsIgnoreCase("IHS")) {
            this.m_vIHSLocations.add(string2);
        } else if (string.equalsIgnoreCase("JDK")) {
            this.m_vJDKLocations.add(string2);
        } else if (string.equalsIgnoreCase("PME")) {
            this.m_vPMELocations.add(string2);
        } else if (string.equalsIgnoreCase("WBI")) {
            this.m_vWBILocations.add(string2);
        }
    }

    private boolean canCurrentUserAccessRootNIFRegistry(String string) {
        String string2 = this.getNIFRegistryPathForRootUser(string);
        try {
            File file = new File(string2);
            return file.canWrite();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void clearLocationVectors() {
        this.m_vAllLocations.clear();
        this.m_vBaseLocations.clear();
        this.m_vCLTLocations.clear();
        this.m_vEmbeddedExpressLocations.clear();
        this.m_vExpressLocations.clear();
        this.m_vIHSLocations.clear();
        this.m_vJDKLocations.clear();
        this.m_vNDLocations.clear();
        this.m_vNDDMZLocations.clear();
        this.m_vPLGLocations.clear();
        this.m_vPMELocations.clear();
        this.m_vWasLocations.clear();
        this.m_vWBILocations.clear();
        this.m_vXDLocations.clear();
    }

    private void convertLocationVectorsToStringArray() {
        int n;
        int n2 = this.m_vAllLocations.size();
        this.m_saAllLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saAllLocations[n] = (String)this.m_vAllLocations.elementAt(n);
        }
        n2 = this.m_vBaseLocations.size();
        this.m_saBaseLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saBaseLocations[n] = (String)this.m_vBaseLocations.elementAt(n);
        }
        n2 = this.m_vCLTLocations.size();
        this.m_saCLTLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saCLTLocations[n] = (String)this.m_vCLTLocations.elementAt(n);
        }
        n2 = this.m_vEmbeddedExpressLocations.size();
        this.m_saEmbeddedExpressLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saEmbeddedExpressLocations[n] = (String)this.m_vEmbeddedExpressLocations.elementAt(n);
        }
        n2 = this.m_vExpressLocations.size();
        this.m_saExpressLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saExpressLocations[n] = (String)this.m_vExpressLocations.elementAt(n);
        }
        n2 = this.m_vIHSLocations.size();
        this.m_saIHSLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saIHSLocations[n] = (String)this.m_vIHSLocations.elementAt(n);
        }
        n2 = this.m_vJDKLocations.size();
        this.m_saJDKLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saJDKLocations[n] = (String)this.m_vJDKLocations.elementAt(n);
        }
        n2 = this.m_vNDLocations.size();
        this.m_saNDLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saNDLocations[n] = (String)this.m_vNDLocations.elementAt(n);
        }
        n2 = this.m_vNDDMZLocations.size();
        this.m_saNDDMZLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saNDDMZLocations[n] = (String)this.m_vNDDMZLocations.elementAt(n);
        }
        n2 = this.m_vPLGLocations.size();
        this.m_saPLGLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saPLGLocations[n] = (String)this.m_vPLGLocations.elementAt(n);
        }
        n2 = this.m_vPMELocations.size();
        this.m_saPMELocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saPMELocations[n] = (String)this.m_vPMELocations.elementAt(n);
        }
        n2 = this.m_vWasLocations.size();
        this.m_saWasLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saWasLocations[n] = (String)this.m_vWasLocations.elementAt(n);
        }
        n2 = this.m_vWBILocations.size();
        this.m_saWBILocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saWBILocations[n] = (String)this.m_vWBILocations.elementAt(n);
        }
        n2 = this.m_vXDLocations.size();
        this.m_saXDLocations = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.m_saXDLocations[n] = (String)this.m_vXDLocations.elementAt(n);
        }
    }

    private int getCurrentPlatform() {
        String string = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, string)) {
            return 1;
        }
        if (Pattern.matches(S_HPUX_PATTERN, string)) {
            return 2;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, string)) {
            return 3;
        }
        if (Pattern.matches(S_LINUX_PATTERN, string)) {
            return 4;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, string)) {
            return 5;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, string)) {
            return 6;
        }
        if (Pattern.matches(S_OS400_PATTERN, string)) {
            return 7;
        }
        return 0;
    }

    private String[] getLocationsByProductID(String string) {
        if ((string = WASDirectoryHelper.normalizedProductID(string)) == null) {
            return this.m_saWasLocations;
        }
        if (string.equalsIgnoreCase("BASE")) {
            return this.m_saBaseLocations;
        }
        if (string.equalsIgnoreCase("EXPRESS")) {
            return this.m_saExpressLocations;
        }
        if (string.equalsIgnoreCase("BASETRIAL")) {
            return this.m_saBaseLocations;
        }
        if (string.equalsIgnoreCase("EXPRESSTRIAL")) {
            return this.m_saExpressLocations;
        }
        if (string.equalsIgnoreCase("ND")) {
            return this.m_saNDLocations;
        }
        if (string.equalsIgnoreCase("NDDMZ")) {
            return this.m_saNDDMZLocations;
        }
        if (string.equalsIgnoreCase("embeddedEXPRESS")) {
            return this.m_saEmbeddedExpressLocations;
        }
        if (string.equalsIgnoreCase("CLIENT")) {
            return this.m_saCLTLocations;
        }
        if (string.equalsIgnoreCase("PLG")) {
            return this.m_saPLGLocations;
        }
        if (string.equalsIgnoreCase("IHS")) {
            return this.m_saIHSLocations;
        }
        if (string.equalsIgnoreCase("JDK")) {
            return this.m_saJDKLocations;
        }
        if (string.equalsIgnoreCase("PME")) {
            return this.m_saPMELocations;
        }
        if (string.equalsIgnoreCase("WBI")) {
            return this.m_saWBILocations;
        }
        if (string.equalsIgnoreCase("XD")) {
            return this.m_saXDLocations;
        }
        if (string.equalsIgnoreCase("WXD")) {
            return this.m_saWXDLocations;
        }
        if (string.equalsIgnoreCase(ID_AllProduct)) {
            return this.m_saAllLocations;
        }
        return new String[0];
    }

    private String getNIFRegistryPath(String string) {
        if (this.getCurrentPlatform() == 7) {
            return "/QIBM/WAS/.ibm/.nif/" + string;
        }
        if (this.canCurrentUserAccessRootNIFRegistry(string)) {
            String string2 = this.getNIFRegistryPathForNonRootUser(string);
            try {
                File file = new File(string2);
                if (file.exists()) {
                    return string2;
                }
                return this.getNIFRegistryPathForRootUser(string);
            }
            catch (Exception exception) {
                return this.getNIFRegistryPathForRootUser(string);
            }
        }
        return this.getNIFRegistryPathForNonRootUser(string);
    }

    private String getNIFRegistryPathForNonRootUser(String string) {
        String string2 = this.normalizePath(System.getProperty(S_USER_HOME));
        String string3 = string2 + S_NIFREGISTRY_RELATIVEPATH;
        return string3 + S_PATH_SEPARATOR + string;
    }

    private String getNIFRegistryPathForRootUser(String string) {
        String string2 = null;
        string2 = this.getCurrentPlatform() == 5 ? this.getSystemRootOnWindows() : (this.getCurrentPlatform() == 1 ? "/usr/.ibm/.nif" : "/opt/.ibm/.nif");
        String string3 = string2 + S_PATH_SEPARATOR + string;
        return string3;
    }

    private String getFirstAvailableSystemDriveRootDirectory() {
        File[] fileArray = File.listRoots();
        String string = null;
        for (int i = 0; i < fileArray.length && ((string = fileArray[i].getAbsolutePath()).startsWith(S_DRIVE_A) || string.startsWith(S_DRIVE_B)); ++i) {
        }
        return string;
    }

    private String getSystemDriveOnWindows() {
        if (m_sSystemDriveOnWindows == null) {
            String string = null;
            String string2 = "SystemDrive";
            String string3 = "cmd /c SET";
            String string4 = null;
            try {
                Process process = Runtime.getRuntime().exec(string3);
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.indexOf(string2) <= -1) continue;
                    string = string4.substring(string4.indexOf(string2) + string2.length() + 1);
                    break;
                }
            }
            catch (Exception exception) {
                string = this.getFirstAvailableSystemDriveRootDirectory();
                string = string.substring(0, string.length() - 1);
            }
            m_sSystemDriveOnWindows = string;
        }
        return m_sSystemDriveOnWindows;
    }

    private String getSystemRootOnWindows() {
        if (m_sSystemRootOnWindows == null) {
            String string = null;
            String string2 = "SystemRoot";
            String string3 = "cmd /c SET";
            String string4 = null;
            try {
                Process process = Runtime.getRuntime().exec(string3);
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.indexOf(string2) <= -1) continue;
                    string = string4.substring(string4.indexOf(string2) + string2.length() + 1);
                    break;
                }
            }
            catch (Exception exception) {
                string = this.getFirstAvailableSystemDriveRootDirectory();
            }
            m_sSystemRootOnWindows = string;
        }
        return m_sSystemRootOnWindows;
    }

    private boolean isThisRegistryNIFRegistry(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (file == null || !file.exists() || file.isDirectory()) {
            return false;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                Pattern pattern;
                Matcher matcher;
                if (string2 != null && !string2.equals(S_EMPTY) && (matcher = (pattern = Pattern.compile(S_NIFREGISTRY_ROOT_PATTERN, 32)).matcher(string2)).matches()) {
                    bufferedReader.close();
                    return true;
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    private boolean isThisValidWASHome(File file) {
        if (file == null) {
            return false;
        }
        String string = file.getAbsolutePath() + S_RALATIVE_PROPERTIES_VERSION_DIR;
        File file2 = new File(string);
        File[] fileArray = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                try {
                    return file.getName().endsWith(WASSystem.S_DOT_PRODUCT);
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
        });
        return fileArray != null && fileArray.length > 0;
    }

    private String normalizePath(String string) {
        char c = '\\';
        char c2 = '/';
        if (this.getCurrentPlatform() == 5) {
            return string.replace(c, c2);
        }
        return string;
    }

    private void parseWASRegistry(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                File file2;
                if ((string2 = string2.trim()) != null && !string2.equals(S_EMPTY) && this.isThisValidWASHome(file2 = new File(string2))) {
                    this.addInstallPackageLocationsByProductID(null, file2);
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void parseNIFRegistry(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), S_UTF8_ENCODING));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                Pattern pattern;
                Matcher matcher;
                if (string2 != null && !string2.equals(S_EMPTY) && (matcher = (pattern = Pattern.compile(S_PRODUCT_ELEMENT_PATTERN, 32)).matcher(string2)).matches()) {
                    String string3 = null;
                    string3 = matcher.group(1);
                    String string4 = null;
                    string4 = matcher.group(2);
                    try {
                        File file2 = new File(new URI(string3));
                        if (this.isThisValidWASHome(file2)) {
                            this.addInstallPackageLocationsByProductID(string4, file2);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

