/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FeatureViewerSorter;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.utils.ProfileJobFeatureLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.ProfilesJobFeatureContentProvider;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.SummaryPage;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class UninstallSummaryPage
extends SummaryPage {
    private TreeViewer uninstallPkgTreeViewer;
    private Text profileName;
    private Text profileLocation;
    private boolean allFixes = false;

    public UninstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.UninstallSummaryPage");
    }

    @Override
    protected void createTargetLocationControl(Composite container) {
        this.checkIfMultipleProfiles();
        if (Agent.getInstance().isPortable() && this.multipleProfiles) {
            return;
        }
        Section targetLocationSection = this.getToolkit().createSection(container, 512);
        targetLocationSection.setText(Messages.ConfirmationPage_targetLocation);
        Composite targetLocationComposite = this.getToolkit().createComposite((Composite)targetLocationSection);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        targetLocationComposite.setLayout((Layout)gridLayout);
        targetLocationSection.setClient((Control)targetLocationComposite);
        targetLocationSection.setLayoutData((Object)new GridData(4, 1, true, false));
        if (InstallAgentUtils.onlyAgentJob(this.getSelectedJobs())) {
            this.getToolkit().createLabel(targetLocationComposite, Messages.InstallLocationDetailsPage_installLocationNameLabel);
            this.profileName = new Text(targetLocationComposite, 8);
            this.profileName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.getToolkit().createLabel(targetLocationComposite, Messages.SummaryPage_installLocationDirectory);
            this.profileLocation = new Text(targetLocationComposite, 8);
            this.profileLocation.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        if (!InstallAgentUtils.onlyAgentJob(this.getSelectedJobs())) {
            this.getToolkit().createLabel(targetLocationComposite, Messages.SummaryPage_commonComponentLocation);
            this.commonComponentLocation = new Text(targetLocationComposite, 8);
            this.commonComponentLocation.setLayoutData((Object)new GridData(4, 1, true, false));
        }
    }

    @Override
    protected void createFeatureControl(Composite container) {
        this.allFixes = AgentUIUtils.allFixJobs(this.getSelectedJobs());
        Section packagesSection = this.getToolkit().createSection(container, 512);
        packagesSection.setText(Messages.UninstallSummaryPage_uninstallTitle);
        Composite packagesComposite = this.getToolkit().createComposite((Composite)packagesSection);
        packagesComposite.setLayout((Layout)new GridLayout());
        packagesSection.setClient((Control)packagesComposite);
        packagesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 101124;
        this.uninstallPkgTreeViewer = new TreeViewer(packagesComposite, style);
        GridData gd = new GridData(1808);
        gd.heightHint = this.uninstallPkgTreeViewer.getTree().getItemHeight() * 3;
        this.uninstallPkgTreeViewer.getTree().setLayoutData((Object)gd);
        this.uninstallPkgTreeViewer.getTree().setLinesVisible(false);
        this.uninstallPkgTreeViewer.getTree().setHeaderVisible(true);
        TreeColumn updateCol = new TreeColumn(this.uninstallPkgTreeViewer.getTree(), 0x800000);
        if (this.allFixes) {
            updateCol.setText(Messages.UpdateSummaryPage_colFix);
        } else {
            updateCol.setText(Messages.UninstallSummaryPage_uninstallPackage);
        }
        TreeColumn installLocationCol = new TreeColumn(this.uninstallPkgTreeViewer.getTree(), 0x800000);
        installLocationCol.setText(Messages.InstallLocationSection_columnLocation);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(72, 280, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 120, true));
        this.uninstallPkgTreeViewer.getTree().setLayout((Layout)tableLayout);
        this.uninstallPkgTreeViewer.setContentProvider((IContentProvider)new ProfilesJobFeatureContentProvider(false));
        this.uninstallPkgTreeViewer.setLabelProvider((IBaseLabelProvider)new ProfileJobFeatureLabelProvider());
        this.uninstallPkgTreeViewer.setInput(null);
        this.uninstallPkgTreeViewer.setSorter((ViewerSorter)new FeatureViewerSorter(true));
    }

    @Override
    protected void showProfiles() {
        List profiles;
        Profile profile;
        if (Agent.getInstance().isPortable() && this.multipleProfiles) {
            return;
        }
        if (!InstallAgentUtils.onlyAgentJob(this.getSelectedJobs())) {
            String location = "";
            if (!Agent.getInstance().isPortable()) {
                location = CacheLocationManager.getInstance().getCacheLocation();
            } else {
                profile = (Profile)this.getProfiles().get(0);
                location = AgentUtil.genPortableSharedLocation((String)profile.getInstallLocation());
            }
            String processedLocation = TextProcessor.process((String)location);
            this.commonComponentLocation.setText(processedLocation);
        }
        if (InstallAgentUtils.onlyAgentJob(this.getSelectedJobs()) && (profiles = this.getProfiles()).size() > 0 && (profile = (Profile)this.getProfiles().get(0)) != null) {
            this.profileName.setText(profile.getProfileId());
            String installLocation = profile.getInstallLocation();
            String processedLocation = TextProcessor.process((String)installLocation);
            this.profileLocation.setText(processedLocation);
        }
    }

    private void showUninstallingPackages() {
        List jobs = this.getSelectedJobs();
        this.uninstallPkgTreeViewer.setInput((Object)AgentUIUtils.createProfileJobTreeView(jobs));
        this.uninstallPkgTreeViewer.expandAll();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showUninstallingPackages();
            this.reflowFor((Control)this.uninstallPkgTreeViewer.getTree());
        }
        super.setVisible(visible);
    }

    @Override
    protected void createEnvSpaceSummaryControl(Composite container) {
    }

    @Override
    protected void showDiskSpaceInformation() {
    }

    @Override
    protected List getSelectedJobs() {
        return super.getSortedSelectedJobs(true);
    }
}

