/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.LockedFilesChecker;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.DetermineDisksNeeded;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactsOnDisksInfo;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.ProcessInfo;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SummaryPage
extends AbstractAgentUIWizardPage {
    private Text profileName;
    private Text profileLocation;
    private Table profileTable;
    protected Text commonComponentLocation;
    private Table spaceTable;
    protected boolean multipleProfiles;
    private Text totalDownloadSizeText;
    private Text totalInstallationSizeText;
    private TreeViewer filesView;
    private Section filesSection;
    private TreeViewer processView;
    private Section blockingProcessSection;
    private Button stopProcessButton;
    private Button refreshProcessButton;
    private LockedFilesChecker checker;
    private Set<ProcessInfo> blockingProcesses;
    protected AgentUILabelProvider agentLabelProvider;
    private final Set driveSet = new HashSet();
    private boolean hasNoCollectionError = true;
    private boolean hasNoBlockingProcess = true;
    private static final CustomMessageWizardPage.ErrorId collectionFailed = new CustomMessageWizardPage.ErrorId();
    private static final CustomMessageWizardPage.ErrorId blockingProcessError = new CustomMessageWizardPage.ErrorId();
    private static final CustomMessageWizardPage.WarningId missingDiskWarning = new CustomMessageWizardPage.WarningId();

    public SummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        this(toolkit, wizard, Messages.ConfirmationPage_description);
    }

    public SummaryPage(FormToolkit toolkit, AgentUIWizard wizard, String description) {
        super(toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.ConfirmationPage_title, description, wizard);
        this.agentLabelProvider = AgentUI.getDefault().getLabelProvider();
        this.agentLabelProvider.connect((Object)this);
    }

    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
        super.dispose();
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        container.setLayout((Layout)layout);
        this.createTargetLocationControl(container);
        this.createPackageSummaryControl(container);
        this.createEnvSpaceSummaryControl(container);
        this.createCollectedFilesControl(container);
        this.createBlockingProcessControl(container);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected void checkIfMultipleProfiles() {
        List profileList = this.getProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        int i = 0;
        while (i < profileList.size()) {
            Profile profile = (Profile)profileList.get(i);
            if (!profile.getProfileKind().equals("license") && !profiles.contains(profile)) {
                profiles.add(profile);
            }
            ++i;
        }
        this.multipleProfiles = !profiles.isEmpty() && profiles.size() != 1;
    }

    protected void createTargetLocationControl(Composite container) {
        this.checkIfMultipleProfiles();
        Section targetLocationSection = this.getToolkit().createSection(container, 512);
        targetLocationSection.setText(Messages.ConfirmationPage_targetLocation);
        Composite targetLocationComposite = this.getToolkit().createComposite((Composite)targetLocationSection);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        targetLocationComposite.setLayout((Layout)gridLayout);
        targetLocationSection.setClient((Control)targetLocationComposite);
        targetLocationSection.setLayoutData((Object)new GridData(4, 1, true, false));
        if (!this.multipleProfiles) {
            this.getToolkit().createLabel(targetLocationComposite, Messages.InstallLocationDetailsPage_installLocationNameLabel);
            this.profileName = new Text(targetLocationComposite, 8);
            this.profileName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.getToolkit().createLabel(targetLocationComposite, Messages.SummaryPage_installLocationDirectory);
            this.profileLocation = new Text(targetLocationComposite, 8);
            this.profileLocation.setLayoutData((Object)new GridData(4, 1, true, false));
        } else {
            gridLayout.marginWidth = 0;
            Composite tableComp = new Composite(targetLocationComposite, 0);
            TableColumnLayout tableLayout = new TableColumnLayout();
            tableComp.setLayout((Layout)tableLayout);
            GridData gd = new GridData(4, 1, true, false);
            gd.horizontalSpan = 2;
            tableComp.setLayoutData((Object)gd);
            int style = 101124;
            this.profileTable = new Table(tableComp, style);
            GridData data = new GridData(4, 1, true, false);
            data.heightHint = this.profileTable.getItemHeight() * 3;
            this.profileTable.setLayoutData((Object)data);
            this.profileTable.setLinesVisible(true);
            this.profileTable.setHeaderVisible(true);
            TableColumn profileNameCol = new TableColumn(this.profileTable, 16384, 0);
            profileNameCol.setText(Messages.InstallLocationSection_columnName);
            TableColumn profileDirCol = new TableColumn(this.profileTable, 16384, 1);
            profileDirCol.setText(Messages.InstallLocationSection_columnLocation);
            tableLayout.setColumnData((Widget)profileNameCol, (ColumnLayoutData)new ColumnWeightData(40, 300, true));
            tableLayout.setColumnData((Widget)profileDirCol, (ColumnLayoutData)new ColumnWeightData(60, 400, true));
        }
        if (!(InstallAgentUtils.onlyAgentJob(this.getSelectedJobs()) || Agent.getInstance().isPortable() && this.multipleProfiles)) {
            this.getToolkit().createLabel(targetLocationComposite, Messages.SummaryPage_commonComponentLocation);
            this.commonComponentLocation = new Text(targetLocationComposite, 8);
            this.commonComponentLocation.setLayoutData((Object)new GridData(4, 1, true, false));
        }
    }

    protected void createPackageSummaryControl(Composite container) {
        this.createFeatureControl(container);
    }

    protected void createFeatureControl(Composite container) {
    }

    protected void createCollectedFilesControl(Composite container) {
        this.filesSection = this.getToolkit().createSection(container, 514);
        this.filesSection.setText(Messages.SummaryPage_CollectionResult_Title);
        Composite collectedFilesComposite = this.getToolkit().createComposite((Composite)this.filesSection);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        collectedFilesComposite.setLayout((Layout)layout);
        this.filesSection.setClient((Control)collectedFilesComposite);
        this.filesSection.setLayoutData((Object)new GridData(4, 4, true, false));
        this.getToolkit().createLabel(collectedFilesComposite, Messages.SummaryPage_CollectionResult_TabelTitle);
        int filesViewStyle = 101124;
        this.filesView = new TreeViewer(collectedFilesComposite, filesViewStyle);
        GridData data = new GridData(1808);
        data.heightHint = this.filesView.getTree().getItemHeight() * 3;
        this.filesView.getTree().setLayoutData((Object)data);
        this.filesView.getTree().setLinesVisible(true);
        this.filesView.getTree().setHeaderVisible(true);
        this.filesView.setContentProvider((IContentProvider)new RepositorySizeContentProvider());
        this.filesView.setLabelProvider((IBaseLabelProvider)new RepositorySizeLabelProvider());
        this.filesView.setAutoExpandLevel(-1);
        this.getToolkit().adapt(this.filesView.getControl(), true, true);
        TreeColumn col1 = new TreeColumn(this.filesView.getTree(), 16384, 0);
        col1.setText(Messages.SummaryPage_CollectionResult_Col1);
        col1.setWidth(420);
        TreeColumn col2 = new TreeColumn(this.filesView.getTree(), 16384, 1);
        col2.setText(Messages.SummaryPage_CollectionResult_Col2);
        col2.setWidth(200);
        this.filesView.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((SummaryPage)SummaryPage.this).filesView.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn repCol = SummaryPage.this.filesView.getTree().getColumn(0);
                TreeColumn sizeCol = SummaryPage.this.filesView.getTree().getColumn(1);
                repCol.setWidth(treeWidth - sizeCol.getWidth() - scrollBarWidth);
            }
        });
        this.filesView.setInput(null);
    }

    private LockedFilesChecker getBlockingProcessChecker() {
        if (this.checker == null) {
            List selectedProductJobs = this.getSelectedProductJobs();
            this.checker = new LockedFilesChecker(selectedProductJobs);
        }
        return this.checker;
    }

    protected void createBlockingProcessControl(Composite container) {
        if (!this.getBlockingProcessChecker().hasJobsRequiringLockedFilesCheck()) {
            return;
        }
        this.blockingProcessSection = this.getToolkit().createSection(container, 514);
        this.blockingProcessSection.setText(Messages.BlockingProcessPage_Title);
        Composite blockingProcessComposite = this.getToolkit().createComposite((Composite)this.blockingProcessSection);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        blockingProcessComposite.setLayout((Layout)layout);
        this.blockingProcessSection.setClient((Control)blockingProcessComposite);
        this.blockingProcessSection.setLayoutData((Object)new GridData(4, 4, true, false));
        int blockingProcessViewStyle = 101124;
        this.processView = new TreeViewer(blockingProcessComposite, blockingProcessViewStyle);
        GridData data = new GridData(1808);
        data.heightHint = this.processView.getTree().getItemHeight() * 3;
        this.processView.getTree().setLayoutData((Object)data);
        this.processView.getTree().setLinesVisible(true);
        this.processView.getTree().setHeaderVisible(true);
        this.processView.setContentProvider((IContentProvider)new ProcessContentProvider());
        this.processView.setLabelProvider((IBaseLabelProvider)new ProcessLabelProvider());
        this.processView.setAutoExpandLevel(-1);
        this.getToolkit().adapt(this.processView.getControl(), true, true);
        TreeColumn col1 = new TreeColumn(this.processView.getTree(), 16384, 0);
        col1.setText(Messages.BlockingProcessPage_ColProcessName);
        col1.setResizable(true);
        col1.setWidth(400);
        TreeColumn col2 = new TreeColumn(this.processView.getTree(), 16384, 1);
        col2.setText(Messages.BlockingProcessPage_ColProcessId);
        col2.setWidth(100);
        this.processView.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((SummaryPage)SummaryPage.this).processView.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn nameCol = SummaryPage.this.processView.getTree().getColumn(0);
                TreeColumn idCol = SummaryPage.this.processView.getTree().getColumn(1);
                nameCol.setWidth(treeWidth - idCol.getWidth() - scrollBarWidth);
            }
        });
        this.processView.setInput(null);
        Composite buttonComp = this.getToolkit().createComposite(blockingProcessComposite);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonLayout.marginHeight = 0;
        buttonComp.setLayout((Layout)buttonLayout);
        buttonComp.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        this.stopProcessButton = this.getToolkit().createButton(buttonComp, Messages.BlockingProcessPage_BtnStopAll, 8);
        this.stopProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LockedFilesChecker processChecker = SummaryPage.this.getBlockingProcessChecker();
                SummaryPage.this.blockingProcesses = processChecker.killRunningProcesses(SummaryPage.this.blockingProcesses);
                SummaryPage.this.refreshBlockingProcessSection();
            }
        });
        this.refreshProcessButton = this.getToolkit().createButton(buttonComp, Messages.BlockingProcessPage_BtnRefresh, 8);
        this.refreshProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LockedFilesChecker processChecker = SummaryPage.this.getBlockingProcessChecker();
                SummaryPage.this.blockingProcesses = processChecker.getFilteredLockingFiles();
                SummaryPage.this.refreshBlockingProcessSection();
            }
        });
    }

    private void refreshBlockingProcessSection() {
        if (this.blockingProcesses == null || this.blockingProcesses.isEmpty()) {
            if (this.processView != null) {
                this.processView.setInput(null);
                this.stopProcessButton.setEnabled(false);
            }
            this.hasNoBlockingProcess = true;
            this.setErrorState(blockingProcessError, null);
            this.displayProcessCannotBeFoundWarning();
        } else {
            if (this.processView != null) {
                this.processView.setInput(this.blockingProcesses);
                this.stopProcessButton.setEnabled(true);
            }
            this.hasNoBlockingProcess = false;
            this.setErrorState(blockingProcessError, Messages.BlockingProcessPage_SummaryWarning);
        }
        this.setPageComplete(this.hasNoCollectionError && this.hasNoBlockingProcess);
    }

    protected void createEnvSpaceSummaryControl(Composite container) {
        Composite comp = this.getToolkit().createComposite(container);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createSpaceSummaryControl(comp);
    }

    protected void createSpaceSummaryControl(Composite container) {
        Section spaceSection = this.getToolkit().createSection(container, 512);
        spaceSection.setText(Messages.ConfirmationPage_requiredSpace);
        Composite spaceComposite = this.getToolkit().createComposite((Composite)spaceSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        spaceComposite.setLayout((Layout)layout);
        spaceSection.setClient((Control)spaceComposite);
        spaceSection.setLayoutData((Object)new GridData(4, 1, true, false));
        int originalBorderStype = this.getToolkit().getBorderStyle();
        this.getToolkit().setBorderStyle(0);
        int spaceTableStyle = 32772;
        this.spaceTable = this.getToolkit().createTable(spaceComposite, spaceTableStyle);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.spaceTable.getItemHeight() * 2;
        this.spaceTable.setLayoutData((Object)data);
        this.spaceTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SummaryPage.this.adjustSpaceTableColumnWidth();
                SummaryPage.this.spaceTable.layout();
                SummaryPage.this.spaceTable.getParent().layout();
            }
        });
        TableColumn col1 = new TableColumn(this.spaceTable, 16384, 0);
        col1.setWidth(30);
        col1.setResizable(false);
        TableColumn col2 = new TableColumn(this.spaceTable, 131072, 1);
        col2.setWidth(100);
        col2.setResizable(false);
        this.spaceTable.pack();
        this.getToolkit().createLabel(spaceComposite, Messages.SummaryPage_spaceSection_totalDownloadSize);
        this.totalDownloadSizeText = this.getToolkit().createText(spaceComposite, "", 8);
        this.getToolkit().createLabel(spaceComposite, Messages.SummaryPage_spaceSection_totalInstallSize);
        this.totalInstallationSizeText = this.getToolkit().createText(spaceComposite, "", 8);
        this.getToolkit().setBorderStyle(originalBorderStype);
    }

    private void adjustSpaceTableColumnWidth() {
        GC gc = new GC((Drawable)this.spaceTable);
        gc.setFont(this.spaceTable.getFont());
        int width1 = this.spaceTable.getColumn(0).getWidth();
        int i = 0;
        while (i < this.spaceTable.getItemCount()) {
            String colText = this.spaceTable.getItem(i).getText(0);
            int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)colText)).append((String)"      ").toString()).x;
            if (width > width1) {
                width1 = width;
            }
            ++i;
        }
        this.spaceTable.getColumn(0).setWidth(width1);
        int width2 = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)Messages.SummaryPage_spaceTable_availableSpace)).append((String)"       ").toString()).x;
        int i2 = 0;
        while (i2 < this.spaceTable.getItemCount()) {
            String colText = this.spaceTable.getItem(i2).getText(1);
            int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)colText)).append((String)"       ").toString()).x;
            if (width > width2) {
                width2 = width;
            }
            ++i2;
        }
        this.spaceTable.getColumn(1).setWidth(width2);
        gc.dispose();
        int newWidthHint = width1 + width2 + 10;
        GridData data = (GridData)this.spaceTable.getLayoutData();
        data.widthHint = newWidthHint;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showProfiles();
            this.showDiskSpaceInformation();
            this.showCollectedFiles();
            this.reflowFor(this.getControl());
        } else {
            this.setPageComplete(false);
        }
        super.setVisible(visible);
    }

    protected void showProfiles() {
        Profile profile;
        if (!(InstallAgentUtils.onlyAgentJob(this.getSelectedJobs()) || Agent.getInstance().isPortable() && this.multipleProfiles)) {
            String location = "";
            if (!Agent.getInstance().isPortable()) {
                location = CacheLocationManager.getInstance().getCacheLocation();
            } else if (!this.multipleProfiles) {
                profile = (Profile)this.getProfiles().get(0);
                location = AgentUtil.genPortableSharedLocation((String)profile.getInstallLocation());
            }
            String processedLocation = TextProcessor.process((String)location);
            this.commonComponentLocation.setText(processedLocation);
        }
        List profiles = this.getProfiles();
        if (!this.multipleProfiles) {
            if (profiles.size() > 0 && (profile = (Profile)this.getProfiles().get(0)) != null) {
                this.profileName.setText(profile.getProfileId());
                String installLocation = profile.getInstallLocation();
                String processedLocation = TextProcessor.process((String)installLocation);
                this.profileLocation.setText(processedLocation);
            }
        } else {
            this.profileTable.removeAll();
            Set profilesWithJob = this.generateProfileListWithJob(this.getSelectedJobs());
            int i = 0;
            while (i < profiles.size()) {
                Profile profile2 = (Profile)profiles.get(i);
                if (!profile2.getProfileKind().equals("license") && profilesWithJob.contains(profile2)) {
                    String name = profile2.getProfileId();
                    String profileDir = profile2.getInstallLocation();
                    String processedLocation = TextProcessor.process((String)profileDir);
                    TableItem item = new TableItem(this.profileTable, 0);
                    item.setText(new String[]{name, processedLocation});
                }
                ++i;
            }
            this.reflowFor((Control)this.profileTable);
        }
    }

    private Set generateProfileListWithJob(List jobs) {
        HashSet<Profile> result = new HashSet<Profile>();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            result.add(job.getProfile());
            ++i;
        }
        return result;
    }

    protected void showDiskSpaceInformation() {
        this.spaceTable.removeAll();
        this.driveSet.clear();
        TableItem tableItem = new TableItem(this.spaceTable, 0);
        tableItem.setText(new String[]{"", Messages.SummaryPage_spaceTable_availableSpace});
        long totalDownloadSize = 0L;
        long totalInstallationSize = 0L;
        List jobs = this.getSelectedJobs();
        if (jobs == null || jobs.size() == 0) {
            return;
        }
        if (!Agent.getInstance().isSkipInstall()) {
            Map profileJobs = SpaceInfoUtils.createProfileJobsMap((List)jobs);
            Set entries = profileJobs.entrySet();
            for (Map.Entry entry : entries) {
                List jobsInOneProfile = (List)entry.getValue();
                AbstractJob[] abstractJobs = jobsInOneProfile.toArray(new AbstractJob[jobsInOneProfile.size()]);
                MaxInstallSizeInfo size = this.getAgentWizard().getSizeInfo((AgentJob[])abstractJobs, null);
                totalDownloadSize += size.getDownloadSize();
                totalInstallationSize += size.getMaxSize();
            }
        }
        IPreferenceStore agentPreferenceStore = AgentUI.getDefault().getAgentPreferenceStore();
        String cacheLocationDrive = PlatformUtils.getLocationDevice((String)agentPreferenceStore.getString(CacheLocationManager.getInstance().getCacheLocation()));
        if ("win32".equals(Platform.getOS())) {
            cacheLocationDrive = cacheLocationDrive.toUpperCase();
        }
        this.driveSet.add(cacheLocationDrive);
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            Profile profile = job.getProfile();
            if (!profile.getProfileKind().equals("license")) {
                String installLocationDrive = PlatformUtils.getLocationDevice((String)profile.getInstallLocation());
                if ("win32".equals(Platform.getOS())) {
                    installLocationDrive = installLocationDrive.toUpperCase();
                }
                this.driveSet.add(installLocationDrive);
            }
            ++i;
        }
        String totalDownloadSizeLabel = FormatUtil.formatBytes((long)totalDownloadSize);
        String totalInstallationSizeLabel = FormatUtil.formatBytes((long)totalInstallationSize);
        for (String driveName : this.driveSet) {
            String availableSpace = SpaceInfoUtils.getAvailableSpace((String)driveName);
            TableItem item = new TableItem(this.spaceTable, 0);
            item.setText(new String[]{TextProcessor.process((String)driveName), availableSpace});
        }
        int rowCount = this.driveSet.size() + 1;
        GridData data = (GridData)this.spaceTable.getLayoutData();
        data.heightHint = this.spaceTable.getItemHeight() * rowCount;
        this.totalDownloadSizeText.setText(totalDownloadSizeLabel);
        this.totalInstallationSizeText.setText(totalInstallationSizeLabel);
        this.spaceTable.redraw();
        this.adjustSpaceTableColumnWidth();
        this.spaceTable.layout();
        this.reflowFor((Control)this.spaceTable);
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public void previousPage() {
        this.getAgentWizard().setCollectedArtifacts(null);
        super.previousPage();
    }

    private void showCollectedFiles() {
        block25: {
            boolean hasMissingDisk = false;
            try {
                final CicMultiStatus[] multiStatus = new CicMultiStatus[]{Statuses.ST.createMultiStatus()};
                final Agent.IAssignedArtifacts[] assignedArtifacts = new Agent.IAssignedArtifacts[1];
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProgressDialog_collectingFile, (int)4);
                        SummaryPage.this.getAgentWizard().swapProfileLocaleSettings();
                        try {
                            SubMonitor collectionMonitor = subMonitor.newChild(3);
                            List selectedJobs = SummaryPage.this.getSelectedJobs();
                            AgentJob[] jobs = selectedJobs.toArray(new AgentJob[selectedJobs.size()]);
                            assignedArtifacts[0] = AgentUI.getDefault().getAgent().collect(multiStatus, jobs, (IProgressMonitor)collectionMonitor);
                            collectionMonitor.done();
                        }
                        finally {
                            SummaryPage.this.getAgentWizard().swapProfileLocaleSettings();
                        }
                        LockedFilesChecker processChecker = SummaryPage.this.getBlockingProcessChecker();
                        if (processChecker.hasJobsRequiringLockedFilesCheck()) {
                            SubMonitor blockingProcessMonitor = subMonitor.newChild(1, 0);
                            blockingProcessMonitor.beginTask(Messages.BlockingProcessPage_SearchProgress, 1);
                            SummaryPage.this.blockingProcesses = SummaryPage.this.getBlockingProcessChecker().getFilteredLockingFiles();
                        }
                        subMonitor.done();
                    }
                });
                ArrayList<RepositorySizeInfo> newInput = new ArrayList<RepositorySizeInfo>();
                this.filesView.getTree().setEnabled(false);
                this.filesView.getTree().setEnabled(true);
                if (this.processView != null) {
                    this.processView.getTree().setEnabled(false);
                    this.processView.getTree().setEnabled(true);
                }
                boolean bl = this.hasNoBlockingProcess = this.blockingProcesses == null || this.blockingProcesses.isEmpty();
                if (this.hasNoBlockingProcess) {
                    if (this.processView != null) {
                        this.processView.setInput(null);
                        this.stopProcessButton.setEnabled(false);
                        this.setErrorStateWithStatus(blockingProcessError, null);
                        this.blockingProcessSection.setExpanded(false);
                    }
                    this.displayProcessCannotBeFoundWarning();
                } else {
                    this.processView.setInput(this.blockingProcesses);
                    this.stopProcessButton.setEnabled(true);
                    this.setErrorState(blockingProcessError, Messages.BlockingProcessPage_SummaryWarning);
                    this.blockingProcessSection.setExpanded(true);
                }
                final CicMultiStatus missingDiskStatus = Statuses.ST.createMultiStatus(String.valueOf(Messages.SummaryPage_diskInfoMsg) + " " + Messages.SummaryPage_diskInfoMsgAction_detail, new Object[0]);
                if (!StatusUtil.isErrorOrCancel((IStatus)multiStatus[0])) {
                    Collection reps = assignedArtifacts[0].getRepositories();
                    for (IRepository rep : reps) {
                        if (this.isLicenseRepository(rep)) continue;
                        IVolumeAccessByDisk diskRep = RepoAs.IVolumeAccessByDisk((IReadArtifactRepo)rep);
                        if (diskRep == null) {
                            String artifactSize = this.calculateArtifactSize(assignedArtifacts[0].getAssignedArtifacts(rep));
                            String repLocation = rep.getLocationStr();
                            String processedRepLocation = TextProcessor.process((String)repLocation);
                            RepositorySizeInfo repSizeInfo = new RepositorySizeInfo(processedRepLocation, artifactSize);
                            newInput.add(repSizeInfo);
                            continue;
                        }
                        String repLocation = diskRep.getRepository().getLocationStr();
                        RepositorySizeInfo parentRepInfo = new RepositorySizeInfo(TextProcessor.process((String)repLocation), "");
                        try (IArtifactSession session = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                            ArtifactsOnDisksInfo aod = DetermineDisksNeeded.execute((IArtifactSession)session, (IVolumeAccessByDisk)diskRep, (Collection)assignedArtifacts[0].getAssignedArtifacts(rep), (IProgressMonitor)new NullProgressMonitor());
                            Set usedDiskSets = aod.getUsedDiskSets();
                            for (IVolumeAccessByDisk.IDiskSet diskSet : usedDiskSets) {
                                if (diskSet.equals(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET)) continue;
                                SizeInfo size = aod.getDiskSetArtifactsSize(diskSet);
                                String downloadSize = FormatUtil.formatBytes((long)size.getDownloadSize());
                                RepositorySizeInfo repSizeInfo = new RepositorySizeInfo(diskSet.getLabel(), downloadSize);
                                parentRepInfo.addChild(repSizeInfo);
                                IVolumeAccessByDisk.IDiskSetDisks usedDisks = aod.getDiskSetDisksUsed(diskSet);
                                List diskInfo = AgentUIUtils.getDiskInfoFromDiskSet(session, diskRep, diskSet, usedDisks);
                                String diskInfoString = "";
                                if (diskInfo.size() == 2) {
                                    String availableDiskString = (String)diskInfo.get(0);
                                    String missingDiskString = (String)diskInfo.get(1);
                                    if (availableDiskString != null && availableDiskString.length() > 0) {
                                        diskInfoString = String.valueOf(diskInfoString) + NLS.bind((String)Messages.SummaryPage_diskInfo, (Object)availableDiskString);
                                        diskInfoString = String.valueOf(diskInfoString) + " ";
                                    }
                                    if (missingDiskString != null && missingDiskString.length() > 0) {
                                        diskInfoString = String.valueOf(diskInfoString) + NLS.bind((String)Messages.SummaryPage_diskNotFoundInfo, (Object)missingDiskString);
                                        hasMissingDisk = true;
                                        Status diskMissingWarningStatus = new Status(2, "com.ibm.cic.agent.ui", diskInfoString);
                                        CicMultiStatus diskSetWarningStatus = Statuses.ST.createMultiStatus(diskSet.getLabel(), new Object[0]);
                                        diskSetWarningStatus.add((IStatus)diskMissingWarningStatus);
                                        CicMultiStatus repWarningStatus = Statuses.ST.createMultiStatus(repLocation, new Object[0]);
                                        repWarningStatus.add((IStatus)diskSetWarningStatus);
                                        missingDiskStatus.add((IStatus)repWarningStatus);
                                    }
                                }
                                if (diskInfoString.length() <= 0) continue;
                                repSizeInfo.diskInfo = diskInfoString;
                            }
                        }
                        List children = parentRepInfo.getChildren();
                        if (children == null || children.isEmpty()) continue;
                        newInput.add(parentRepInfo);
                    }
                    this.filesView.setInput(newInput);
                    this.setErrorState(collectionFailed, null);
                    this.hasNoCollectionError = true;
                    this.setPageComplete(this.hasNoBlockingProcess);
                    this.getAgentWizard().setCollectedArtifacts(assignedArtifacts[0]);
                    if (hasMissingDisk) {
                        boolean isESDInstall = DiskUtil.canFindAvailableDisksForRepositories((Collection)assignedArtifacts[0].getRepositories());
                        if (isESDInstall) {
                            this.setWarningState(missingDiskWarning, String.valueOf(Messages.SummaryPage_diskInfoMsg) + " " + Messages.SummaryPage_diskInfoMsgAction_rep);
                            if (this.hasNoBlockingProcess) {
                                final Shell shell = this.getShell();
                                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        WrapDetailUIDErrorDialog msgDialog = new WrapDetailUIDErrorDialog(shell, com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Warning, null, (IStatus)missingDiskStatus, 2);
                                        msgDialog.open();
                                    }
                                });
                            }
                        } else {
                            this.setWarningState(missingDiskWarning, null);
                        }
                    } else {
                        this.setWarningState(missingDiskWarning, null);
                    }
                    break block25;
                }
                this.filesView.setInput(null);
                this.setErrorStateWithStatus(collectionFailed, (IStatus)multiStatus[0]);
                this.hasNoCollectionError = false;
                this.setPageComplete(false);
                if (multiStatus[0].isMultiStatus() && multiStatus[0].getChildren().length > 0 || multiStatus[0].getException() != null) {
                    final Shell shell = this.getShell();
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WrapDetailUIDErrorDialog msgDialog = new WrapDetailUIDErrorDialog(shell, null, null, (IStatus)multiStatus[0], 4);
                            msgDialog.open();
                        }
                    });
                } else {
                    final Shell shell = this.getShell();
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Status status = new Status(multiStatus[0].getSeverity(), multiStatus[0].getPlugin(), multiStatus[0].getMessage());
                            WrapDetailUIDErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e, false);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e, false);
            }
        }
    }

    private boolean isLicenseRepository(IRepository rep) {
        List allOfferings = rep.getAllOfferings((IProgressMonitor)new NullProgressMonitor());
        if (allOfferings == null || allOfferings.isEmpty()) {
            return false;
        }
        return allOfferings.size() == 1 && LicenseUtils.isPEKOffering((IOffering)((IOffering)allOfferings.get(0)));
    }

    private String calculateArtifactSize(Collection artifacts) {
        SizeInfo total = new SizeInfo(0L, 0L);
        String fileInfo = com.ibm.cic.agent.core.sharedUI.Messages.DownloadCachePreferencePage_CleanUp_CurrentStatus_Unknown;
        for (IArtifact artifact : artifacts) {
            total.add(artifact.getContentInfo().getSizeInfo());
        }
        fileInfo = FormatUtil.formatBytes((long)total.getDownloadSize());
        return fileInfo;
    }

    protected void reflowFor(Control c) {
        for (Composite parent = c.getParent(); parent != null; parent = parent.getParent()) {
            parent.layout();
            if (!(parent instanceof ScrolledForm)) continue;
            ((ScrolledForm)parent).reflow(true);
            break;
        }
    }

    @Override
    protected void setFocus() {
        boolean hasSelectedJobs = !this.getSelectedJobs().isEmpty();
        this.setPageComplete(hasSelectedJobs && this.hasNoCollectionError && this.hasNoBlockingProcess);
    }

    protected List<AgentJob> getSortedSelectedJobs(boolean uninstallOrder) {
        return SortUtil.sortByProfileNameAndVersion((List)super.getSelectedJobs(), (boolean)uninstallOrder);
    }

    public boolean isReadOnlyPage() {
        return true;
    }

    protected boolean has64BitsProfiles() {
        List selectedJobs = this.getSelectedJobs();
        for (AbstractJob job : selectedJobs) {
            Profile profile = job.getProfile();
            if (!profile.is64bit()) continue;
            return true;
        }
        return false;
    }

    protected void displayProcessCannotBeFoundWarning() {
        if (CicCommonSettings.isWindows() && this.blockingProcesses != null && this.blockingProcesses.isEmpty() && PlatformUtils.is64bitOS() && !BitModeUtils.is64bitIM() && this.has64BitsProfiles()) {
            ICicStatus status = Statuses.WARNING.get(Messages.BlockingProcessPage_ProcessCannotBeFoundWarning, new Object[0]);
            this.setMessageWithStatus((IStatus)status);
        }
    }

    protected static class FeatureFilter
    extends ViewerFilter {
        protected FeatureFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof InstallJob) {
                InstallJob job = (InstallJob)element;
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                if (offeringOrFix instanceof IFix) {
                    return true;
                }
                IOffering offering = job.getOffering();
                return offering != null && !LicenseUtils.isPEKOffering((IOffering)offering);
            }
            if (element instanceof FeatureSelectionPage.FeatureGroupNode) {
                return ((FeatureSelectionPage.FeatureGroupNode)element).isVisible() && ((FeatureSelectionPage.FeatureGroupNode)element).isSelected();
            }
            if (element instanceof FeatureSelectionPage.FeatureNode) {
                return ((FeatureSelectionPage.FeatureNode)element).isVisible() && ((FeatureSelectionPage.FeatureNode)element).isSelected();
            }
            return true;
        }
    }

    private static class ProcessContentProvider
    implements ITreeContentProvider {
        private ProcessContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                return ((Set)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ProcessLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ProcessInfo) {
                ProcessInfo process = (ProcessInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return process.getFileName();
                    }
                    case 1: {
                        return String.valueOf(process.getProcID());
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ProcessInfo) {
                switch (columnIndex) {
                    case 0: {
                        return SummaryPage.this.agentLabelProvider.get(CommonImages.LOG_ERROR);
                    }
                }
            }
            return null;
        }
    }

    private static class RepositorySizeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private RepositorySizeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RepositorySizeInfo) {
                RepositorySizeInfo repSizeInfo = (RepositorySizeInfo)parentElement;
                List children = repSizeInfo.getChildren();
                if (children == null || children.isEmpty()) {
                    return new Object[]{((RepositorySizeInfo)parentElement).diskInfo};
                }
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RepositorySizeInfo) {
                RepositorySizeInfo repSizeInfo = (RepositorySizeInfo)element;
                List children = repSizeInfo.getChildren();
                if (children != null && !children.isEmpty()) {
                    return true;
                }
                String diskInfo = repSizeInfo.diskInfo;
                return diskInfo != null && diskInfo.length() > 0;
            }
            return false;
        }
    }

    private static class RepositorySizeInfo {
        String repositoryLabel;
        String sizeInfo;
        String diskInfo;
        List children = new ArrayList();

        RepositorySizeInfo(String repLabel, String sizeLabel) {
            this.repositoryLabel = repLabel;
            this.sizeInfo = sizeLabel;
        }

        void addChild(RepositorySizeInfo childRepInfo) {
            this.children.add(childRepInfo);
        }

        List getChildren() {
            return this.children;
        }
    }

    private static class RepositorySizeLabelProvider
    implements ITableLabelProvider {
        private RepositorySizeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof RepositorySizeInfo) {
                if (columnIndex == 0) {
                    return ((RepositorySizeInfo)element).repositoryLabel;
                }
                if (columnIndex == 1) {
                    return ((RepositorySizeInfo)element).sizeInfo;
                }
            } else if (element instanceof String && columnIndex == 0) {
                return (String)element;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

