/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LicenseDetailsPanel {
    private final FormToolkit toolkit;
    private Label vendorLabel;
    private Label packageLabel;
    private Label kindLabel;

    LicenseDetailsPanel(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    void createControl(Composite parent) {
        Composite inner = this.toolkit.createComposite(parent);
        GridData innerData = new GridData(4, 4, true, false);
        inner.setLayoutData((Object)innerData);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginWidth = 2;
        inner.setLayout((Layout)innerLayout);
        this.toolkit.createLabel(inner, Messages.LicenseImportPage_package);
        this.packageLabel = this.toolkit.createLabel(inner, "", 64);
        this.packageLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.toolkit.createLabel(inner, Messages.LicenseImportPage_vendor);
        this.vendorLabel = this.toolkit.createLabel(inner, "");
        this.vendorLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.toolkit.createLabel(inner, Messages.LicenseImportPage_kind);
        this.kindLabel = this.toolkit.createLabel(inner, "");
        this.kindLabel.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    void setInput(AbstractJob importJob) {
        if (importJob == null) {
            this.packageLabel.setText("");
            this.vendorLabel.setText("");
            this.kindLabel.setText("");
        } else {
            IInstallableUnit[] installableUnits;
            List offerings;
            IOffering pekOffering = importJob.getOffering();
            Agent agent = AgentUI.getDefault().getAgent();
            String targetId = LicenseUtils.getIdOfOfferingThatPekAppliesTo((IOffering)pekOffering);
            IOffering appliedOffering = null;
            Profile[] profiles = agent.getVisibleProfiles();
            int i = 0;
            while (i < profiles.length) {
                IOffering[] offerings2;
                if (!profiles[i].isAgentProfile() && !profiles[i].isLicenseProfile() && (offerings2 = agent.getInstalledOfferings(profiles[i], (IIdentity)new SimpleIdentity(targetId))) != null && offerings2.length > 0) {
                    appliedOffering = offerings2[0];
                    break;
                }
                ++i;
            }
            if (appliedOffering == null && !(offerings = UpdateOfferingUtils.findAllOfferingsAndTheirUpdates((IRepository)agent.getRepositoryGroup(), (IIdentity)new SimpleIdentity(targetId), null, (boolean)true, null)).isEmpty()) {
                appliedOffering = (IOffering)offerings.iterator().next();
            }
            if (appliedOffering != null) {
                this.packageLabel.setText(LicenseUtils.getLicenseNameThatPekAppliesTo((IOffering)pekOffering, appliedOffering));
            } else {
                this.packageLabel.setText(targetId);
            }
            String vendorName = pekOffering.getProperties().getProperty("vendor.name", "");
            if (vendorName != null) {
                this.vendorLabel.setText(vendorName);
            }
            if ((installableUnits = LicenseUtils.getIplaUnits((IOffering)pekOffering)).length > 0) {
                IInstallableUnit unit = installableUnits[0];
                this.kindLabel.setText(LicenseUtils.getLocalizedLicenseKind((IInstallableUnit)unit));
            }
        }
    }
}

