/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.agent.internal.ui.utils.ProductProfileFilter;
import com.ibm.cic.agent.internal.ui.wizards.InstallLocationPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class InstallLocationSection
extends TreeMasterPart {
    public static final int LOCATION_TYPE_NONE = 0;
    public static final int LOCATION_TYPE_EXISTING = 1;
    public static final int LOCATION_TYPE_NEW = 2;
    private List currentInput = new ArrayList();
    private Button existingLocationButton;
    private Button newLocationButton;
    private final InstallLocationPage locationPage;
    private int locationType;
    private Profile newProfile;
    private TreeViewer treeViewer;
    private IStatus getRecommendedProfileStatus = Status.OK_STATUS;

    private boolean isRecommendedProfile(Profile profile) {
        Profile[] profiles;
        Profile[] profileArray = profiles = this.locationPage.getRecommendedProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile2 = profileArray[n2];
            if (profile2 == profile) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public InstallLocationSection(IFormContext context, Composite parent, InstallLocationPage locationPage) {
        super(context, parent, 4096, new String[0], 512);
        this.locationPage = locationPage;
        this.configureViewer(this.getTreePart().getTreeViewer());
        this.getSection().setText(Messages.InstallLocationSection_header);
    }

    private void configureLocationButtons() {
        Profile profile = this.createNewProfile(this.locationPage.getSelectedProductJobs());
        Profile[] profiles = Agent.getInstance().getVisibleProfiles();
        if (profile == null) {
            this.newLocationButton.setEnabled(false);
        } else {
            this.newLocationButton.setEnabled(true);
        }
        if (!this.hasProductProfile(profiles)) {
            this.existingLocationButton.setEnabled(false);
        } else {
            this.existingLocationButton.setEnabled(true);
        }
        Profile[] recommendedProfiles = this.locationPage.getRecommendedProfiles();
        if (recommendedProfiles.length > 0) {
            Profile recommendedProfile = this.getRecommendedProfileFromSelectedJobs(recommendedProfiles);
            if (recommendedProfile != null || profile == null) {
                this.locationType = 1;
                this.existingLocationButton.setSelection(true);
            } else {
                this.locationType = 2;
                this.newLocationButton.setSelection(true);
            }
        } else if (profile != null) {
            this.locationType = 2;
            this.newLocationButton.setSelection(true);
        } else if (this.hasProductProfile(profiles)) {
            this.locationType = 1;
            this.existingLocationButton.setSelection(true);
        } else {
            this.locationType = 0;
        }
    }

    private boolean hasProductProfile(Profile[] profiles) {
        if (profiles == null || profiles.length == 0) {
            return false;
        }
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.getProfileKind().equals("product") || profile.getProfileKind().equals("existingEclipse")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        viewer.setContentProvider((IContentProvider)new ProfileContentProvider());
        viewer.setSorter((ViewerSorter)new ProfileSorter());
        viewer.addFilter((ViewerFilter)new ProductProfileFilter());
        this.createColumns(viewer);
        viewer.setInput(null);
    }

    private TreeColumn createColumn(Tree tree, String name, TableLayout tableLayout, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setResizable(true);
        if (tableLayout == null) {
            column.setWidth(width);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, width, true));
        }
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        int width = 300;
        int bitColWidth = 0;
        if (BitModeUtils.isMultiBitModePlatform()) {
            bitColWidth = CommonUIUtils.calculateStringWidth((Control)tree, (String)Messages.InstallLocationSection_columnBitMode, (int)2);
            width -= bitColWidth / 2;
        }
        this.createColumn(tree, Messages.InstallLocationSection_columnName, tableLayout, width);
        this.createColumn(tree, Messages.InstallLocationSection_columnLocation, tableLayout, width);
        if (BitModeUtils.isMultiBitModePlatform()) {
            this.createColumn(tree, Messages.InstallLocationSection_columnBitMode, tableLayout, bitColWidth);
        }
        tree.setLayout((Layout)tableLayout);
    }

    protected Control createLocationTypeButtons(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        buttonsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1, 1, false, false);
        gd.horizontalSpan = 2;
        buttonsGroup.setLayoutData((Object)gd);
        this.existingLocationButton = new Button(buttonsGroup, 0x800010);
        this.existingLocationButton.setText(Messages.InstallLocationSection_showExistingLocations);
        this.existingLocationButton.setEnabled(false);
        this.existingLocationButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                InstallLocationSection.this.handleExistingLocationPressed(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (InstallLocationSection.this.existingLocationButton.getSelection()) {
                    InstallLocationSection.this.handleExistingLocationPressed(e);
                }
            }
        });
        this.newLocationButton = new Button(buttonsGroup, 0x800010);
        this.newLocationButton.setText(Messages.InstallLocationSection_showNewLocation);
        this.newLocationButton.setEnabled(false);
        this.newLocationButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                InstallLocationSection.this.handleNewLocationPressed(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (InstallLocationSection.this.newLocationButton.getSelection()) {
                    InstallLocationSection.this.handleNewLocationPressed(e);
                }
            }
        });
        return buttonsGroup;
    }

    Profile createNewProfile(List jobs) {
        if (jobs.size() == 0) {
            return null;
        }
        this.newProfile = AgentUtil.makeNewProfileForOfferings((IOffering[])this.locationPage.getSelectedProductOfferings(), (List)jobs);
        return this.newProfile;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.createLocationTypeButtons(parent);
        this.treeViewer = new TreeViewer(parent, 2052);
        this.getContext().getForm().getToolkit().adapt(this.treeViewer.getControl(), true, true);
        return this.treeViewer;
    }

    ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)this.getTreePart().getTreeViewer().getContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getTreePart().getTreeViewer().getLabelProvider();
    }

    Profile getNewProfile() {
        return this.newProfile;
    }

    private void handleExistingLocationPressed(SelectionEvent event) {
        this.locationType = 1;
        this.refresh();
        this.primeSelection();
    }

    private void handleNewLocationPressed(SelectionEvent event) {
        this.locationType = 2;
        this.refresh();
        this.primeSelection();
    }

    @Override
    public void primeSelection() {
        TreeViewer profileTreeViewer = this.getTreeViewer();
        TreeItem[] items = profileTreeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return;
        }
        Profile profile = null;
        if (this.locationType == 2) {
            profile = this.getNewProfile();
        } else if (this.locationType == 1) {
            Profile[] profiles = this.locationPage.getRecommendedProfiles();
            if (profiles.length > 0) {
                profile = this.getRecommendedProfileFromSelectedJobs(profiles);
                if (profile == null) {
                    profile = profiles[0];
                }
            } else {
                TreeItem firstItem;
                Object data;
                Tree profileTree = this.getTreeViewer().getTree();
                int itemCount = profileTree.getItemCount();
                if (itemCount > 0 && (data = (firstItem = profileTree.getItem(0)).getData()) instanceof Profile) {
                    profile = (Profile)data;
                }
            }
        }
        if (profile != null) {
            Object[] selectProfile = new Profile[]{profile};
            StructuredSelection newSelection = new StructuredSelection(selectProfile);
            profileTreeViewer.setSelection((ISelection)newSelection);
        } else {
            this.locationPage.setSelection(null);
        }
    }

    public void refresh() {
        super.refresh();
        this.getTreePart().getTreeViewer().refresh();
    }

    protected void setInput(Object inputElement) {
        if (!(!(inputElement instanceof List) || this.currentInput.equals(inputElement) && this.getRecommendedProfileStatus.isOK())) {
            this.currentInput = (List)inputElement;
            this.getRecommendedProfileStatus = this.locationPage.calculateRecommendedProfiles();
            if (this.getRecommendedProfileStatus.isOK()) {
                this.configureLocationButtons();
                this.locationPage.calculateDependencyStatus();
                this.getTreePart().getTreeViewer().setInput(inputElement);
                this.primeSelection();
            }
        }
    }

    protected IStatus getCalculateRecommendedProfilStatus() {
        return this.getRecommendedProfileStatus;
    }

    void setNewProfile(Profile profile) {
        this.newProfile = profile;
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    int getLocationType() {
        return this.locationType;
    }

    private Profile getRecommendedProfileFromSelectedJobs(Profile[] recommendedProfiles) {
        IOffering offering;
        List jobs = this.locationPage.getSelectedProductJobs();
        String profileId = null;
        for (AbstractJob job : jobs) {
            Profile jobProfile = job.getProfile();
            if (jobProfile == null || jobProfile.isAgentProfile()) continue;
            profileId = jobProfile.getProfileId();
            break;
        }
        if (profileId == null && (offering = this.getOfferingWithShortestPath(this.locationPage.getSelectedProductOfferings())) != null) {
            profileId = OfferingProperty.getDefaultProfile((IOfferingOrFix)offering);
        }
        if (profileId != null) {
            Profile[] profileArray = recommendedProfiles;
            int n = recommendedProfiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile recommendedProfile = profileArray[n2];
                if (recommendedProfile.getProfileId().equals(profileId)) {
                    return recommendedProfile;
                }
                ++n2;
            }
        }
        return null;
    }

    private IOffering getOfferingWithShortestPath(IOffering[] offerings) {
        int minLength = Integer.MAX_VALUE;
        IOffering offering = null;
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            int pathLength;
            IOffering currentOffering = iOfferingArray[n2];
            if (!Agent.isExtensionOffering((IOfferingOrFix)currentOffering) && !LicenseUtils.isPEKOffering((IOffering)currentOffering) && (pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)currentOffering)) < minLength) {
                minLength = pathLength;
                offering = currentOffering;
            }
            ++n2;
        }
        return offering;
    }

    class ProfileContentProvider
    implements ITreeContentProvider {
        ProfileContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            Object[] profiles = null;
            profiles = InstallLocationSection.this.locationType == 2 ? new Profile[]{InstallLocationSection.this.getNewProfile()} : (InstallLocationSection.this.locationType == 1 ? Agent.getInstance().getVisibleProfiles() : new Profile[]{});
            return profiles;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ProfileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private final Color disabledColor;
        private final AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

        public ProfileLabelProvider(Display display) {
            this.agentLabelProvider.connect((Object)this);
            this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
        }

        public void dispose() {
            super.dispose();
            this.agentLabelProvider.disconnect((Object)this);
            this.disabledColor.dispose();
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (element instanceof Profile) {
                switch (columnIndex) {
                    case 0: {
                        return this.getText(element);
                    }
                    case 1: {
                        String location = ((Profile)element).getInstallLocation();
                        return TextProcessor.process((String)location);
                    }
                    case 2: {
                        return this.getBitModeText(element);
                    }
                }
            }
            return "";
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (InstallLocationSection.this.locationType == 1) {
                if (element instanceof Profile && InstallLocationSection.this.isRecommendedProfile((Profile)element)) {
                    return null;
                }
                return this.disabledColor;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Profile) {
                return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
            }
            if (element instanceof IOffering) {
                return this.agentLabelProvider.getOfferingImage((IOffering)element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Profile) {
                return ((Profile)element).getProfileId();
            }
            if (element instanceof IOffering) {
                return ((IOffering)element).getName();
            }
            return super.getText(element);
        }

        private String getBitModeText(Object element) {
            Profile profile;
            if (element instanceof Profile && BitModeUtils.isBitModeApplicable((Profile)(profile = (Profile)element), (IOffering[])InstallLocationSection.this.locationPage.getSelectedProductOfferings())) {
                return BitModeUtils.getBitModeText((Profile)profile);
            }
            return "";
        }
    }

    private class ProfileSorter
    extends ViewerSorter {
        private ProfileSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof Profile && e2 instanceof Profile) {
                String label1 = ((Profile)e1).getProfileId();
                String label2 = ((Profile)e2).getProfileId();
                return this.getComparator().compare(label1, label2);
            }
            return super.compare(viewer, e1, e2);
        }

        public int category(Object element) {
            if (element instanceof Profile && InstallLocationSection.this.isRecommendedProfile((Profile)element)) {
                return 0;
            }
            return 1;
        }
    }
}

