/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.OfferingTreeNode;
import com.ibm.cic.agent.internal.ui.utils.SummaryFeatureLabelProvider;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class UpdateResultLabelProvider
extends SummaryFeatureLabelProvider
implements ITableColorProvider {
    private final Color disabledColor;

    public UpdateResultLabelProvider(Display display) {
        this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
    }

    @Override
    public void dispose() {
        this.disabledColor.dispose();
        super.dispose();
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        Profile profile;
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (columnIndex == 1 && element instanceof IAdaptable && (profile = (Profile)((IAdaptable)element).getAdapter(Profile.class)) != null) {
            return TextProcessor.process((String)profile.getInstallLocation());
        }
        return "";
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof OfferingTreeNode && ((OfferingTreeNode)element).isInstalled()) {
            return this.disabledColor;
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        if (element instanceof OfferingTreeNode) {
            OfferingTreeNode offeringNode = (OfferingTreeNode)element;
            IOffering offering = offeringNode.getOffering();
            if (offeringNode.isInstalled()) {
                String label = String.valueOf(offering.getName()) + " " + AgentUIUtils.getDisplayableVersion((IOfferingOrFix)offering) + " " + Messages.AvailableUpdateSection_installed;
                return label;
            }
            return super.getText(offering);
        }
        if (element instanceof FixNode) {
            return super.getText(((FixNode)element).getJob());
        }
        return super.getText(element);
    }
}

